/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.io.CancellableFileIo;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0015\u0018\u0000 I2\u00020\u0001:\u0003GHIB\u0089\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0015H\u0002J<\u00101\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0004032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u001505H\u0002JP\u00106\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0004032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0015052\u0006\u00107\u001a\u00020\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0015H\u0002J,\u00109\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001505H\u0002JG\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u00042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001505H\u0002\u00a2\u0006\u0002\u0010=JL\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\"2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001505H\u0002JL\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001505H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010%\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006J"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor;", "", "sourceFolders", "", "Ljava/io/File;", "importFolders", "sourceOutputDir", "resOutputDir", "objOutputDir", "libOutputDir", "buildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "targetApi", "", "optimizationLevel", "ndkMode", "", "supportMode", "useAndroidX", "abiFilters", "", "", "logger", "Lcom/android/utils/ILogger;", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/android/sdklib/BuildToolInfo;IIZZZLjava/util/Set;Lcom/android/utils/ILogger;)V", "is32Bit", "is64Bit", "rsLib", "Ljava/nio/file/Path;", "libClCore", "", "abis32", "", "Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "abis64", "actualTargetApi", "genericRawFolder", "getGenericRawFolder", "()Ljava/io/File;", "build", "", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "processOutputHandler", "Lcom/android/ide/common/process/ProcessOutputHandler;", "getArchSpecificRawFolder", "architecture", "doMainCompilation", "inputFiles", "", "env", "", "compileBCFiles", "outputFile", "arch", "createSupportFiles", "createSupportFilesHelper", "rawFolder", "abis", "(Ljava/io/File;[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;Lcom/android/ide/common/process/ProcessExecutor;Lcom/android/ide/common/process/ProcessOutputHandler;Ljava/util/Map;)V", "createSupportObjFile", "bcFile", "abi", "objName", "objAbiFolder", "createSupportLibFile", "objFile", "soName", "libAbiFolder", "Abi", "AbiType", "Companion", "builder"})
@SourceDebugExtension(value={"SMAP\nRenderScriptProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderScriptProcessor.kt\ncom/android/builder/internal/compiler/RenderScriptProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,538:1\n12637#2,2:539\n12637#2,2:541\n1#3:543\n*S KotlinDebug\n*F\n+ 1 RenderScriptProcessor.kt\ncom/android/builder/internal/compiler/RenderScriptProcessor\n*L\n124#1:539,2\n127#1:541,2\n*E\n"})
public final class RenderScriptProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<File> sourceFolders;
    @NotNull
    private final Collection<File> importFolders;
    @NotNull
    private final File sourceOutputDir;
    @NotNull
    private final File resOutputDir;
    @NotNull
    private final File objOutputDir;
    @NotNull
    private final File libOutputDir;
    @NotNull
    private final BuildToolInfo buildToolInfo;
    private final int optimizationLevel;
    private final boolean ndkMode;
    private final boolean supportMode;
    private final boolean useAndroidX;
    @NotNull
    private final Set<String> abiFilters;
    @NotNull
    private final ILogger logger;
    private final boolean is32Bit;
    private final boolean is64Bit;
    @Nullable
    private final Path rsLib;
    @NotNull
    private final Map<String, Path> libClCore;
    @NotNull
    private final Abi[] abis32;
    @NotNull
    private final Abi[] abis64;
    private final int actualTargetApi;

    public RenderScriptProcessor(@NotNull Collection<? extends File> sourceFolders, @NotNull Collection<? extends File> importFolders, @NotNull File sourceOutputDir, @NotNull File resOutputDir, @NotNull File objOutputDir, @NotNull File libOutputDir, @NotNull BuildToolInfo buildToolInfo, int targetApi, int optimizationLevel, boolean ndkMode, boolean supportMode, boolean useAndroidX, @NotNull Set<String> abiFilters, @NotNull ILogger logger) {
        Abi[] rs4;
        Intrinsics.checkNotNullParameter(sourceFolders, (String)"sourceFolders");
        Intrinsics.checkNotNullParameter(importFolders, (String)"importFolders");
        Intrinsics.checkNotNullParameter((Object)sourceOutputDir, (String)"sourceOutputDir");
        Intrinsics.checkNotNullParameter((Object)resOutputDir, (String)"resOutputDir");
        Intrinsics.checkNotNullParameter((Object)objOutputDir, (String)"objOutputDir");
        Intrinsics.checkNotNullParameter((Object)libOutputDir, (String)"libOutputDir");
        Intrinsics.checkNotNullParameter((Object)buildToolInfo, (String)"buildToolInfo");
        Intrinsics.checkNotNullParameter(abiFilters, (String)"abiFilters");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.sourceFolders = sourceFolders;
        this.importFolders = importFolders;
        this.sourceOutputDir = sourceOutputDir;
        this.resOutputDir = resOutputDir;
        this.objOutputDir = objOutputDir;
        this.libOutputDir = libOutputDir;
        this.buildToolInfo = buildToolInfo;
        this.optimizationLevel = optimizationLevel;
        this.ndkMode = ndkMode;
        this.supportMode = supportMode;
        this.useAndroidX = useAndroidX;
        this.abiFilters = abiFilters;
        this.logger = logger;
        this.libClCore = new LinkedHashMap();
        this.actualTargetApi = this.supportMode ? Math.max(18, targetApi) : Math.max(11, targetApi);
        this.abis32 = RenderScriptProcessor.Companion.getAbis(AbiType.BIT_32);
        this.abis64 = RenderScriptProcessor.Companion.getAbis(AbiType.BIT_64);
        if (this.supportMode) {
            Path rsClCoreFile;
            rs4 = this.buildToolInfo.getLocation().resolve("renderscript");
            this.rsLib = rs4.resolve("lib");
            Path bcFolder = this.rsLib.resolve("bc");
            for (Abi abi : this.abis32) {
                rsClCoreFile = bcFolder.resolve(abi.getDevice() + "/libclcore.bc");
                if (!CancellableFileIo.exists((Path)rsClCoreFile, (LinkOption[])new LinkOption[0])) continue;
                this.libClCore.put(abi.getDevice(), rsClCoreFile);
            }
            for (Abi abi : this.abis64) {
                rsClCoreFile = bcFolder.resolve(abi.getDevice() + "/libclcore.bc");
                if (!CancellableFileIo.exists((Path)rsClCoreFile, (LinkOption[])new LinkOption[0])) continue;
                this.libClCore.put(abi.getDevice(), rsClCoreFile);
            }
        } else {
            this.rsLib = null;
        }
        if (this.abiFilters.isEmpty()) {
            this.is32Bit = true;
            this.is64Bit = true;
        } else {
            boolean bl5;
            boolean bl6;
            block10: {
                boolean bl7;
                Abi[] $this$any$iv;
                boolean $i$f$any;
                RenderScriptProcessor renderScriptProcessor;
                Abi abi;
                block9: {
                    rs4 = this.abis32;
                    renderScriptProcessor = this;
                    $i$f$any = false;
                    for (void var19_23 : $this$any$iv) {
                        abi = var19_23;
                        boolean bl8 = false;
                        if (!this.abiFilters.contains(abi.getDevice())) continue;
                        bl7 = true;
                        break block9;
                    }
                    bl7 = false;
                }
                renderScriptProcessor.is32Bit = bl6 = bl7;
                $this$any$iv = this.abis64;
                renderScriptProcessor = this;
                $i$f$any = false;
                int n15 = $this$any$iv.length;
                for (int i15 = 0; i15 < n15; ++i15) {
                    Abi abi2;
                    abi = abi2 = $this$any$iv[i15];
                    boolean bl9 = false;
                    if (!this.abiFilters.contains(abi.getDevice())) continue;
                    bl5 = true;
                    break block10;
                }
                bl5 = false;
            }
            renderScriptProcessor.is64Bit = bl6 = bl5;
        }
        if (targetApi < 21 && this.is64Bit && this.ndkMode) {
            throw new RuntimeException("Api version " + targetApi + " does not support 64 bit ndk compilation");
        }
    }

    private final File getGenericRawFolder() {
        return new File(this.resOutputDir, "raw");
    }

    public final void build(@NotNull ProcessExecutor processExecutor, @NotNull ProcessOutputHandler processOutputHandler) {
        Intrinsics.checkNotNullParameter((Object)processExecutor, (String)"processExecutor");
        Intrinsics.checkNotNullParameter((Object)processOutputHandler, (String)"processOutputHandler");
        List renderscriptFiles = new ArrayList();
        for (File dir : this.sourceFolders) {
            String[] stringArray = new String[]{"rs", "fs"};
            DirectoryWalker.builder().root(dir.toPath()).extensions(stringArray).action(new DirectoryWalker.FileAction(renderscriptFiles){
                final /* synthetic */ List<File> $renderscriptFiles;
                {
                    this.$renderscriptFiles = $renderscriptFiles;
                }

                public final void call(Path path, Path path2) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    File file = path2.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    this.$renderscriptFiles.add(file);
                }
            }).build().walk();
        }
        if (renderscriptFiles.isEmpty()) {
            return;
        }
        Map env = new LinkedHashMap();
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            env.put("DYLD_LIBRARY_PATH", ((Object)this.buildToolInfo.getLocation().toAbsolutePath()).toString());
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            env.put("LD_LIBRARY_PATH", ((Object)this.buildToolInfo.getLocation().toAbsolutePath()).toString());
        }
        this.doMainCompilation(renderscriptFiles, processExecutor, processOutputHandler, env);
        if (this.supportMode) {
            this.createSupportFiles(processExecutor, processOutputHandler, env);
        }
    }

    private final File getArchSpecificRawFolder(String architecture) {
        String[] stringArray = new String[]{"raw", "bc" + architecture};
        File file = FileUtils.join((File)this.resOutputDir, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(...)");
        return file;
    }

    private final void doMainCompilation(List<? extends File> inputFiles, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        List architectures = new ArrayList();
        if (this.is32Bit) {
            architectures.add("32");
        }
        if (this.is64Bit) {
            architectures.add("64");
        }
        if (this.actualTargetApi >= 21 && this.ndkMode) {
            for (String arch : architectures) {
                this.compileBCFiles(inputFiles, processExecutor, processOutputHandler, env, this.getArchSpecificRawFolder(arch), arch);
            }
        } else {
            RenderScriptProcessor.compileBCFiles$default(this, inputFiles, processExecutor, processOutputHandler, env, this.getGenericRawFolder(), null, 32, null);
        }
    }

    private final void compileBCFiles(List<? extends File> inputFiles, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env, File outputFile, String arch) {
        boolean bl5;
        String renderscript;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String string = renderscript = this.buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (string != null) {
            String it = string;
            boolean bl6 = false;
            bl5 = new File(it).isFile();
        } else {
            bl5 = false;
        }
        if (!bl5) {
            boolean $i$a$-check-RenderScriptProcessor$compileBCFiles$332 = false;
            String $i$a$-check-RenderScriptProcessor$compileBCFiles$332 = BuildToolInfo.PathId.LLVM_RS_CC + " is missing";
            throw new IllegalStateException($i$a$-check-RenderScriptProcessor$compileBCFiles$332.toString());
        }
        builder.setExecutable(renderscript);
        builder.addEnvironments(env);
        String rsPath = this.buildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS);
        String rsClangPath = this.buildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG);
        builder.addArgs("-I");
        builder.addArgs(rsPath);
        builder.addArgs("-I");
        builder.addArgs(rsClangPath);
        for (File file : this.importFolders) {
            if (!file.isDirectory()) continue;
            builder.addArgs("-I");
            builder.addArgs(file.getAbsolutePath());
        }
        if (this.supportMode) {
            ProcessInfoBuilder processInfoBuilder = this.useAndroidX ? builder.addArgs("-rs-package-name=androidx.renderscript") : builder.addArgs("-rs-package-name=android.support.v8.renderscript");
        }
        builder.addArgs("-p");
        builder.addArgs(this.sourceOutputDir.getAbsolutePath());
        builder.addArgs("-target-api");
        builder.addArgs(String.valueOf(this.actualTargetApi));
        for (File file : inputFiles) {
            builder.addArgs(file.getAbsolutePath());
        }
        if (this.ndkMode) {
            builder.addArgs("-reflect-c++");
        }
        builder.addArgs("-O");
        builder.addArgs(String.valueOf(this.optimizationLevel));
        builder.addArgs("-o");
        builder.addArgs(outputFile.getAbsolutePath());
        if (arch != null) {
            builder.addArgs("-m" + arch);
        }
        ProcessResult result = processExecutor.execute(builder.createProcess(), processOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
    }

    static /* synthetic */ void compileBCFiles$default(RenderScriptProcessor renderScriptProcessor, List list, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map map, File file, String string, int n15, Object object) {
        if ((n15 & 0x20) != 0) {
            string = null;
        }
        renderScriptProcessor.compileBCFiles(list, processExecutor, processOutputHandler, map, file, string);
    }

    private final void createSupportFiles(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        if (this.actualTargetApi < 21) {
            File rawFolder = this.getGenericRawFolder();
            this.createSupportFilesHelper(rawFolder, this.abis32, processExecutor, processOutputHandler, env);
        } else {
            File rawFolder32 = this.getArchSpecificRawFolder("32");
            this.createSupportFilesHelper(rawFolder32, this.abis32, processExecutor, processOutputHandler, env);
            File rawFolder64 = this.getArchSpecificRawFolder("64");
            this.createSupportFilesHelper(rawFolder64, this.abis64, processExecutor, processOutputHandler, env);
        }
    }

    private final void createSupportFilesHelper(File rawFolder, Abi[] abis, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        WaitableExecutor mExecutor = WaitableExecutor.useGlobalSharedThreadPool();
        List files = new ArrayList();
        String[] stringArray = new String[]{"bc"};
        DirectoryWalker.builder().root(rawFolder.toPath()).extensions(stringArray).action(new DirectoryWalker.FileAction(files){
            final /* synthetic */ List<File> $files;
            {
                this.$files = $files;
            }

            public final void call(Path path, Path path2) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                File file = path2.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                this.$files.add(file);
            }
        }).build().walk();
        for (File bcFile : files) {
            String name = bcFile.getName();
            Intrinsics.checkNotNull((Object)name);
            CharSequence charSequence = name;
            Object object = new Regex("\\.bc");
            String string = ".o";
            String objName = object.replace(charSequence, string);
            object = name;
            string = new Regex("\\.bc");
            String string2 = ".so";
            String soName = "librs." + string.replace((CharSequence)object, string2);
            for (Abi abi : abis) {
                if (!((Collection)this.abiFilters).isEmpty() && !this.abiFilters.contains(abi.getDevice())) continue;
                if (this.libClCore.get(abi.getDevice()) == null) {
                    this.logger.warning(StringsKt.trimMargin((String)("|Skipped RenderScript support mode compilation for " + abi.getDevice() + " : required components not found in Build-Tools " + this.buildToolInfo.getRevision() + "\n                           |Please check and update your BuildTools."), (String)"|"), new Object[0]);
                    continue;
                }
                File objAbiFolder = new File(this.objOutputDir, abi.getDevice());
                if (!objAbiFolder.isDirectory() && !objAbiFolder.mkdirs()) {
                    throw new IOException("Unable to create dir " + objAbiFolder.getAbsolutePath());
                }
                File libAbiFolder = new File(this.libOutputDir, abi.getDevice());
                if (!libAbiFolder.isDirectory() && !libAbiFolder.mkdirs()) {
                    throw new IOException("Unable to create dir " + libAbiFolder.getAbsolutePath());
                }
                mExecutor.execute(new Callable(this, bcFile, abi, objName, objAbiFolder, processExecutor, processOutputHandler, env, soName, libAbiFolder){
                    final /* synthetic */ RenderScriptProcessor this$0;
                    final /* synthetic */ File $bcFile;
                    final /* synthetic */ Abi $abi;
                    final /* synthetic */ String $objName;
                    final /* synthetic */ File $objAbiFolder;
                    final /* synthetic */ ProcessExecutor $processExecutor;
                    final /* synthetic */ ProcessOutputHandler $processOutputHandler;
                    final /* synthetic */ Map<String, String> $env;
                    final /* synthetic */ String $soName;
                    final /* synthetic */ File $libAbiFolder;
                    {
                        this.this$0 = $receiver;
                        this.$bcFile = $bcFile;
                        this.$abi = $abi;
                        this.$objName = $objName;
                        this.$objAbiFolder = $objAbiFolder;
                        this.$processExecutor = $processExecutor;
                        this.$processOutputHandler = $processOutputHandler;
                        this.$env = $env;
                        this.$soName = $soName;
                        this.$libAbiFolder = $libAbiFolder;
                    }

                    public final Void call() {
                        File objFile = RenderScriptProcessor.access$createSupportObjFile(this.this$0, this.$bcFile, this.$abi, this.$objName, this.$objAbiFolder, this.$processExecutor, this.$processOutputHandler, this.$env);
                        RenderScriptProcessor.access$createSupportLibFile(this.this$0, objFile, this.$abi, this.$soName, this.$libAbiFolder, this.$processExecutor, this.$processOutputHandler, this.$env);
                        return null;
                    }
                });
            }
        }
        mExecutor.waitForTasksWithQuickFail(true);
    }

    private final File createSupportObjFile(File bcFile, Abi abi, String objName, File objAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.buildToolInfo.getPath(BuildToolInfo.PathId.BCC_COMPAT));
        builder.addEnvironments(env);
        builder.addArgs("-O" + this.optimizationLevel);
        File outFile = new File(objAbiFolder, objName);
        builder.addArgs("-o", outFile.getAbsolutePath());
        builder.addArgs("-fPIC");
        builder.addArgs("-shared");
        builder.addArgs("-rt-path", ((Object)((Path)MapsKt.getValue(this.libClCore, (Object)abi.getDevice())).toAbsolutePath()).toString());
        builder.addArgs("-mtriple", abi.getToolchain());
        builder.addArgs(bcFile.getAbsolutePath());
        processExecutor.execute(builder.createProcess(), processOutputHandler).rethrowFailure().assertNormalExitValue();
        return outFile;
    }

    private final void createSupportLibFile(File objFile, Abi abi, String soName, File libAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        Path path = this.rsLib;
        if (path == null) {
            path = Paths.get("", new String[0]);
        }
        Path root = path;
        Path intermediatesFolder = root.resolve("intermediates");
        Path intermediatesAbiFolder = intermediatesFolder.resolve(abi.getDevice());
        Path packagedFolder = root.resolve("packaged");
        Path packagedAbiFolder = packagedFolder.resolve(abi.getDevice());
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.buildToolInfo.getPath(abi.getLinker()));
        builder.addEnvironments(env);
        String[] stringArray = new String[]{"noexecstack", "-z", "relro", "-z", "now"};
        builder.addArgs(abi.getLinkerArgs()).addArgs("--eh-frame-hdr").addArgs("-shared", "-Bsymbolic", "-z", stringArray);
        File outFile = new File(libAbiFolder, soName);
        builder.addArgs("-o", outFile.getAbsolutePath());
        String[] stringArray2 = new String[]{soName, objFile.getAbsolutePath(), ((Object)intermediatesAbiFolder.resolve("libcompiler_rt.a").toAbsolutePath()).toString(), "-lRSSupport", "-lm", "-lc"};
        builder.addArgs("-L" + intermediatesAbiFolder.toAbsolutePath(), "-L" + packagedAbiFolder.toAbsolutePath(), "-soname", stringArray2);
        processExecutor.execute(builder.createProcess(), processOutputHandler).rethrowFailure().assertNormalExitValue();
    }

    @JvmStatic
    @NotNull
    public static final File getSupportJar(@NotNull File buildToolsFolder, boolean useAndroidX) {
        return Companion.getSupportJar(buildToolsFolder, useAndroidX);
    }

    @JvmStatic
    @NotNull
    public static final File getSupportNativeLibFolder(@NotNull File buildToolsFolder) {
        return Companion.getSupportNativeLibFolder(buildToolsFolder);
    }

    @JvmStatic
    @NotNull
    public static final File getSupportBlasLibFolder(@NotNull File buildToolsFolder) {
        return Companion.getSupportBlasLibFolder(buildToolsFolder);
    }

    @JvmStatic
    private static final File getBaseRenderscriptLibFolder(File buildToolsFolder) {
        return RenderScriptProcessor.Companion.getBaseRenderscriptLibFolder(buildToolsFolder);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final Abi[] getAbis(@NotNull String abiType) {
        return Companion.getAbis(abiType);
    }

    public static final /* synthetic */ File access$createSupportObjFile(RenderScriptProcessor $this, File bcFile, Abi abi, String objName, File objAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map env) {
        return $this.createSupportObjFile(bcFile, abi, objName, objAbiFolder, processExecutor, processOutputHandler, env);
    }

    public static final /* synthetic */ void access$createSupportLibFile(RenderScriptProcessor $this, File objFile, Abi abi, String soName, File libAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map env) {
        $this.createSupportLibFile(objFile, abi, soName, libAbiFolder, processExecutor, processOutputHandler, env);
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "", "device", "", "toolchain", "linkerArgs", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getDevice", "()Ljava/lang/String;", "getToolchain", "[Ljava/lang/String;", "linker", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getLinker", "()Lcom/android/sdklib/BuildToolInfo$PathId;", "getLinkerArgs", "()[Ljava/lang/String;", "builder"})
    public static final class Abi {
        @NotNull
        private final String device;
        @NotNull
        private final String toolchain;
        @NotNull
        private final String[] linkerArgs;
        @NotNull
        private final BuildToolInfo.PathId linker;

        public Abi(@NotNull String device, @NotNull String toolchain, @NotNull String[] linkerArgs) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)toolchain, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)linkerArgs, (String)"linkerArgs");
            this.device = device;
            this.toolchain = toolchain;
            this.linkerArgs = linkerArgs;
            this.linker = BuildToolInfo.PathId.LLD;
        }

        @NotNull
        public final String getDevice() {
            return this.device;
        }

        @NotNull
        public final String getToolchain() {
            return this.toolchain;
        }

        @NotNull
        public final BuildToolInfo.PathId getLinker() {
            return this.linker;
        }

        @NotNull
        public final String[] getLinkerArgs() {
            Object[] objectArray = new String[]{"-flavor", "ld"};
            return (String[])ArraysKt.plus((Object[])objectArray, (Object[])this.linkerArgs);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor$AbiType;", "", "<init>", "(Ljava/lang/String;I)V", "BIT_32", "BIT_64", "builder"})
    private static final class AbiType
    extends Enum<AbiType> {
        public static final /* enum */ AbiType BIT_32 = new AbiType();
        public static final /* enum */ AbiType BIT_64 = new AbiType();
        private static final /* synthetic */ AbiType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AbiType[] values() {
            return (AbiType[])$VALUES.clone();
        }

        public static AbiType valueOf(String value) {
            return Enum.valueOf(AbiType.class, value);
        }

        @NotNull
        public static EnumEntries<AbiType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = abiTypeArray = new AbiType[]{AbiType.BIT_32, AbiType.BIT_64};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0003J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor$Companion;", "", "<init>", "()V", "getSupportJar", "Ljava/io/File;", "buildToolsFolder", "useAndroidX", "", "getSupportNativeLibFolder", "getSupportBlasLibFolder", "getBaseRenderscriptLibFolder", "getAbis", "", "Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "type", "Lcom/android/builder/internal/compiler/RenderScriptProcessor$AbiType;", "(Lcom/android/builder/internal/compiler/RenderScriptProcessor$AbiType;)[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "abiType", "", "(Ljava/lang/String;)[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "builder"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final File getSupportJar(@NotNull File buildToolsFolder, boolean useAndroidX) {
            Intrinsics.checkNotNullParameter((Object)buildToolsFolder, (String)"buildToolsFolder");
            return new File(this.getBaseRenderscriptLibFolder(buildToolsFolder), useAndroidX ? "androidx-rs.jar" : "renderscript-v8.jar");
        }

        @JvmStatic
        @NotNull
        public final File getSupportNativeLibFolder(@NotNull File buildToolsFolder) {
            Intrinsics.checkNotNullParameter((Object)buildToolsFolder, (String)"buildToolsFolder");
            return new File(this.getBaseRenderscriptLibFolder(buildToolsFolder), "packaged");
        }

        @JvmStatic
        @NotNull
        public final File getSupportBlasLibFolder(@NotNull File buildToolsFolder) {
            Intrinsics.checkNotNullParameter((Object)buildToolsFolder, (String)"buildToolsFolder");
            return new File(this.getBaseRenderscriptLibFolder(buildToolsFolder), "blas");
        }

        @JvmStatic
        private final File getBaseRenderscriptLibFolder(File buildToolsFolder) {
            return new File(buildToolsFolder, "renderscript/lib");
        }

        private final Abi[] getAbis(AbiType type) {
            Abi[] abiArray;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Abi[] abiArray2 = new Abi[3];
                    String[] stringArray = new String[]{"-dynamic-linker", "/system/bin/linker", "-X", "-m", "armelf_linux_eabi"};
                    abiArray2[0] = new Abi("armeabi-v7a", "armv7-none-linux-gnueabi", stringArray);
                    stringArray = new String[]{"-EL"};
                    abiArray2[1] = new Abi("mips", "mipsel-unknown-linux", stringArray);
                    stringArray = new String[]{"-m", "elf_i386"};
                    abiArray2[2] = new Abi("x86", "i686-unknown-linux", stringArray);
                    abiArray = abiArray2;
                    break;
                }
                case 2: {
                    Abi[] abiArray3 = new Abi[2];
                    String[] stringArray = new String[]{"-X", "--fix-cortex-a53-843419"};
                    abiArray3[0] = new Abi("arm64-v8a", "aarch64-linux-android", stringArray);
                    stringArray = new String[]{"-m", "elf_x86_64"};
                    abiArray3[1] = new Abi("x86_64", "x86_64-unknown-linux", stringArray);
                    abiArray = abiArray3;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return abiArray;
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final Abi[] getAbis(@NotNull String abiType) {
            Intrinsics.checkNotNullParameter((Object)abiType, (String)"abiType");
            String string = abiType;
            return Intrinsics.areEqual((Object)string, (Object)"32") ? this.getAbis(AbiType.BIT_32) : (Intrinsics.areEqual((Object)string, (Object)"64") ? this.getAbis(AbiType.BIT_64) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AbiType.values().length];
                try {
                    nArray[AbiType.BIT_32.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AbiType.BIT_64.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

