/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ThreadRecorder
implements Recorder {
    protected final ThreadLocal<Deque<Long>> recordStacks = ThreadLocal.withInitial(ArrayDeque::new);

    @Override
    public GradleBuildProfileSpan record(GradleBuildProfileSpan.ExecutionType executionType, Long projectId, Long variantId, Long recordId, Recorder.VoidBlock block) {
        return this.record(executionType, null, projectId, variantId, recordId, block);
    }

    @Override
    public GradleBuildProfileSpan record(GradleBuildProfileSpan.ExecutionType executionType, GradleTransformExecution transform, Long projectId, Long variantId, Long recordId, Recorder.VoidBlock block) {
        GradleBuildProfileSpan.Builder currentRecord = this.create(recordId, executionType, transform);
        try {
            block.call();
        }
        catch (Exception e15) {
            throw new RuntimeException(e15);
        }
        finally {
            if (this.recordStacks.get().pop().longValue() != currentRecord.getId()) {
                Logger.getLogger(ThreadRecorder.class.getName()).log(Level.SEVERE, "Profiler stack corrupted");
            }
            currentRecord.setDurationInMs(System.currentTimeMillis() - currentRecord.getStartTimeInMs());
            if (projectId != null) {
                currentRecord.setProject(projectId.longValue());
            }
            if (variantId != null) {
                currentRecord.setVariant(variantId.longValue());
            }
            if (this.recordStacks.get().isEmpty()) {
                this.recordStacks.remove();
            }
        }
        return currentRecord.build();
    }

    private GradleBuildProfileSpan.Builder create(Long recordId, GradleBuildProfileSpan.ExecutionType executionType, GradleTransformExecution transform) {
        Long parentId = this.recordStacks.get().peek();
        long startTimeInMs = System.currentTimeMillis();
        GradleBuildProfileSpan.Builder currentRecord = GradleBuildProfileSpan.newBuilder().setId(recordId.longValue()).setType(executionType).setThreadId(Thread.currentThread().getId()).setStartTimeInMs(startTimeInMs);
        if (transform != null) {
            currentRecord.setTransform(transform);
        }
        if (parentId != null) {
            currentRecord.setParentId(parentId.longValue());
        }
        currentRecord.setThreadId(Thread.currentThread().getId());
        this.recordStacks.get().push(recordId);
        return currentRecord;
    }
}

