/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.BuildBundleCommand;
import com.android.tools.build.bundletool.BuildModuleCommand;
import com.android.tools.build.bundletool.LinkCommand;
import com.android.tools.build.bundletool.SplitModuleCommand;
import com.android.tools.build.bundletool.ValidateBundleCommand;
import com.android.tools.build.bundletool.utils.flags.FlagParser;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import java.util.List;

public class BundleToolMain {
    public static final String HELP_CMD = "help";

    public static void main(String[] args) {
        ParsedFlags flags;
        try {
            flags = new FlagParser().parse(args);
        }
        catch (FlagParser.FlagParseException e) {
            System.out.println(String.format("Error while parsing the flags: %s", e.getMessage()));
            return;
        }
        List<String> commands = flags.getCommands();
        if (commands.isEmpty()) {
            System.out.println("Error: you have to specify a command");
            BundleToolMain.help();
            return;
        }
        try {
            switch (commands.get(0)) {
                case "build-bundle": {
                    BuildBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-module": {
                    BuildModuleCommand.fromFlags(flags).execute();
                    break;
                }
                case "split-module": {
                    SplitModuleCommand.fromFlags(flags).execute();
                    break;
                }
                case "validate": {
                    ValidateBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "link": {
                    LinkCommand.fromFlags(flags).execute();
                    break;
                }
                case "help": {
                    if (commands.size() > 1) {
                        BundleToolMain.help(commands.get(1));
                    } else {
                        BundleToolMain.help();
                    }
                    return;
                }
                default: {
                    System.out.println("Error: unrecognized command.");
                    BundleToolMain.help();
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void help() {
        System.out.println(String.format("bundletool [%s|%s|%s|%s|%s|%s] ...", "build-bundle", "build-module", "split-module", "link", "validate", HELP_CMD));
        System.out.println("Type: bundletool help [command] to learn more about a given command.");
    }

    public static void help(String commandName) {
        switch (commandName) {
            case "build-bundle": {
                BuildBundleCommand.help();
                break;
            }
            case "build-module": {
                BuildModuleCommand.help();
                break;
            }
            case "split-module": {
                SplitModuleCommand.help();
                break;
            }
            case "validate": {
                ValidateBundleCommand.help();
                break;
            }
            case "link": {
                LinkCommand.help();
                break;
            }
            default: {
                System.out.println("Unrecognized command.");
                BundleToolMain.help();
            }
        }
    }
}

