/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.converter;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.XmlParsingException;
import com.android.tools.build.bundletool.utils.GraphicsApiVersions;
import com.android.tools.build.bundletool.utils.xml.XmlValidator;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Int32Value;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TargetingXmlToProtoConverter {
    private static final String SCHEMA_PATH = "third_party/java_src/android_appbundle/schemas/xsd/targeting.xsd";

    public ImmutableList<Targeting.TargetingQualifier> convert(String xml) {
        return this.convert(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public ImmutableList<Targeting.TargetingQualifier> convert(InputStream xml) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Document doc = new XmlValidator(classLoader.getResource(SCHEMA_PATH)).validate(xml);
        return this.convertFromElement(doc.getDocumentElement());
    }

    private ImmutableList<Targeting.TargetingQualifier> convertFromElement(Element targetingQualifiersElement) {
        ImmutableList.Builder targetingQualifiers = ImmutableList.builder();
        NodeList targetingQualifierElements = targetingQualifiersElement.getChildNodes();
        for (int i = 0; i < targetingQualifierElements.getLength(); ++i) {
            Element targetingQualifierElement = (Element)targetingQualifierElements.item(i);
            targetingQualifiers.add((Object)TargetingXmlToProtoConverter.readTargetingQualifier(targetingQualifierElement));
        }
        return TargetingXmlToProtoConverter.validate((ImmutableList<Targeting.TargetingQualifier>)targetingQualifiers.build());
    }

    private static Targeting.TargetingQualifier readTargetingQualifier(Element targetingElement) {
        String localName;
        Targeting.TargetingQualifier.Builder targetingQualifier = Targeting.TargetingQualifier.newBuilder().setAlias(targetingElement.getAttribute("alias"));
        Element element = (Element)targetingElement.getChildNodes().item(0);
        switch (localName = element.getLocalName()) {
            case "screen-density": {
                targetingQualifier.setScreenDensity(TargetingXmlToProtoConverter.readScreenDensity(element));
                break;
            }
            case "sdk-version": {
                targetingQualifier.setSdkVersion(TargetingXmlToProtoConverter.readSdkVersion(element));
                break;
            }
            case "open-gl-version": {
                targetingQualifier.setGraphicsApi(TargetingXmlToProtoConverter.readGraphicsApi(element));
                break;
            }
            case "texture-compression-format": {
                targetingQualifier.setTextureCompressionFormat(TargetingXmlToProtoConverter.readTextureCompressionFormat(element));
                break;
            }
            case "abi": {
                targetingQualifier.setAbi(TargetingXmlToProtoConverter.readAbi(element));
                break;
            }
            default: {
                throw new RuntimeException("Oops! The tool does not support the tag <" + localName + "> at the moment.");
            }
        }
        return targetingQualifier.build();
    }

    private static Targeting.Abi readAbi(Element element) {
        Targeting.Abi.Builder abi = Targeting.Abi.newBuilder();
        String targetValue = element.getAttribute("target");
        try {
            abi.setAlias(Targeting.Abi.AbiAlias.valueOf(targetValue));
        }
        catch (IllegalStateException e) {
            throw new XmlParsingException("Unsupported value '%s' for ABI.", targetValue);
        }
        return abi.build();
    }

    private static Targeting.TextureCompressionFormat readTextureCompressionFormat(Element element) {
        Targeting.TextureCompressionFormat.Builder format = Targeting.TextureCompressionFormat.newBuilder();
        String targetValue = element.getAttribute("target");
        if ("3DC".equals(targetValue)) {
            targetValue = "THREE_DC";
        }
        try {
            format.setAlias(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.valueOf(targetValue));
        }
        catch (IllegalArgumentException e) {
            throw new XmlParsingException("Unsupported value '%s' for texture compression format.", targetValue);
        }
        return format.build();
    }

    private static Targeting.GraphicsApi readGraphicsApi(Element element) {
        Targeting.OpenGlVersionRange.Builder openGlVersionRange = Targeting.OpenGlVersionRange.newBuilder();
        Optional<String> minGlVersion = Optional.ofNullable(Strings.emptyToNull((String)element.getAttribute("min")));
        Optional<String> maxGlVersion = Optional.ofNullable(Strings.emptyToNull((String)element.getAttribute("max")));
        if (!minGlVersion.isPresent() && !maxGlVersion.isPresent()) {
            throw new XmlParsingException("XML tag <open-gl-version> should contain either the 'min' or the 'max' attribute.", new Object[0]);
        }
        minGlVersion.ifPresent(min -> openGlVersionRange.setMin(TargetingXmlToProtoConverter.readOpenGlVersion(min)));
        maxGlVersion.ifPresent(max -> openGlVersionRange.setMax(TargetingXmlToProtoConverter.readOpenGlVersion(max)));
        if (openGlVersionRange.hasMin() && openGlVersionRange.hasMax() && GraphicsApiVersions.getOpenGlVersionComparator().compare(openGlVersionRange.getMin(), openGlVersionRange.getMax()) > 0) {
            throw new XmlParsingException("XML tag <open-gl-version> has 'min' attribute (%s) greater than a 'max' attribute (%s).", minGlVersion.get(), maxGlVersion.get());
        }
        return Targeting.GraphicsApi.newBuilder().setOpenGlVersions(openGlVersionRange).build();
    }

    private static Targeting.OpenGlVersion readOpenGlVersion(String versionString) {
        String[] majorMinor = versionString.split("\\.");
        Preconditions.checkState((majorMinor.length > 0 && majorMinor.length <= 2 ? 1 : 0) != 0, (Object)String.format("Expected OpenGL version format 'X.Y', but got (%s)", versionString));
        Targeting.OpenGlVersion.Builder versionBuilder = Targeting.OpenGlVersion.newBuilder();
        versionBuilder.setMajor(Integer.parseInt(majorMinor[0]));
        if (majorMinor.length == 2) {
            versionBuilder.setMinor(Integer.parseInt(majorMinor[1]));
        }
        return versionBuilder.build();
    }

    private static Targeting.SdkVersion readSdkVersion(Element element) {
        Targeting.SdkVersion.Builder sdkVersion = Targeting.SdkVersion.newBuilder();
        Optional<String> minSdkVersion = Optional.ofNullable(Strings.emptyToNull((String)element.getAttribute("min")));
        Optional<String> maxSdkVersion = Optional.ofNullable(Strings.emptyToNull((String)element.getAttribute("max")));
        if (!minSdkVersion.isPresent() && !maxSdkVersion.isPresent()) {
            throw new XmlParsingException("XML tag <sdk-version> should contain either the 'min' or the 'max' attribute.", new Object[0]);
        }
        minSdkVersion.ifPresent(min -> sdkVersion.setMin(Int32Value.newBuilder().setValue(Integer.parseInt(min))));
        maxSdkVersion.ifPresent(max -> sdkVersion.setMax(Int32Value.newBuilder().setValue(Integer.parseInt(max))));
        if (sdkVersion.hasMin() && sdkVersion.hasMax() && sdkVersion.getMin().getValue() > sdkVersion.getMax().getValue()) {
            throw new XmlParsingException("XML tag <sdk-version> has 'min' attribute (%d) greater than a 'max' attribute (%d).", sdkVersion.getMin().getValue(), sdkVersion.getMax().getValue());
        }
        return sdkVersion.build();
    }

    private static Targeting.ScreenDensity readScreenDensity(Element element) {
        Targeting.ScreenDensity.Builder screenDensity = Targeting.ScreenDensity.newBuilder();
        String targetValue = element.getAttribute("target");
        try {
            screenDensity.setDensityAlias(Targeting.ScreenDensity.DensityAlias.valueOf(targetValue));
        }
        catch (IllegalArgumentException e) {
            try {
                screenDensity.setDensityDpi(Integer.parseInt(targetValue));
            }
            catch (NumberFormatException e2) {
                throw new XmlParsingException("Unsupported value '%s' for screen density.", targetValue);
            }
        }
        return screenDensity.build();
    }

    private static ImmutableList<Targeting.TargetingQualifier> validate(ImmutableList<Targeting.TargetingQualifier> qualifiers) {
        HashSet<String> usedAliases = new HashSet<String>();
        for (Targeting.TargetingQualifier qual : qualifiers) {
            if (usedAliases.add(qual.getAlias())) continue;
            throw new XmlParsingException("Found duplicate targeting qualifier alias '%s'.", qual.getAlias());
        }
        return qualifiers;
    }
}

