/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.bundle.Commands;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.AutoValue_BuildApksCommand;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.splitters.BundleSharder;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.files.FileUtils;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Int32Value;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.zip.ZipException;

@AutoValue
public abstract class BuildApksCommand {
    public static final String COMMAND_NAME = "build-apks";
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> OUTPUT_DIRECTORY_FLAG = Flag.path("output");
    private static final Flag<ImmutableList<String>> MODULES_FLAG = Flag.strings("modules");
    private static final Flag<ImmutableList<OptimizationDimension>> OPTIMIZE_FOR_FLAG = Flag.enums("optimize-for", OptimizationDimension.class);
    private static final Flag<Boolean> STANDALONE_FLAG = Flag.booleanFlag("standalone");

    public abstract Path getBundlePath();

    public abstract Path getOutputDirectory();

    public abstract ImmutableList<BundleModuleName> getModuleNames();

    public abstract ImmutableList<OptimizationDimension> getOptimizationDimensions();

    public abstract boolean getGenerateStandaloneApks();

    public static Builder builder() {
        return new AutoValue_BuildApksCommand.Builder().setGenerateStandaloneApks(false).setModuleNames((ImmutableList<BundleModuleName>)ImmutableList.of()).setOptimizationDimensions((ImmutableList<OptimizationDimension>)ImmutableList.of());
    }

    public static BuildApksCommand fromFlags(ParsedFlags flags) {
        Builder builder = BuildApksCommand.builder().setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputDirectory(OUTPUT_DIRECTORY_FLAG.getRequiredValue(flags)).setModuleNames((ImmutableList<BundleModuleName>)((ImmutableList)MODULES_FLAG.getRequiredValue(flags).stream().map(BundleModuleName::create).collect(ImmutableList.toImmutableList())));
        STANDALONE_FLAG.value(flags).ifPresent(builder::setGenerateStandaloneApks);
        OPTIMIZE_FOR_FLAG.value(flags).ifPresent(builder::setOptimizationDimensions);
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public Commands.BuildApksResult execute() throws CommandExecutionException {
        AppBundle appBundle;
        this.validateInput();
        try {
            appBundle = new AppBundleValidator().validate(this.getBundlePath());
        }
        catch (ZipException e) {
            throw new CommandExecutionException(e, "Zip error while opening the bundle", new Object[0]);
        }
        catch (FileNotFoundException e) {
            throw new CommandExecutionException(e, "Bundle file not found", new Object[0]);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "I/O error while processing the bundle", new Object[0]);
        }
        ImmutableList modules = this.getModuleNames().isEmpty() ? ImmutableList.copyOf((Collection)appBundle.getModules().values()) : (ImmutableList)this.getModuleNames().stream().map(appBundle::getModule).collect(ImmutableList.toImmutableList());
        Commands.BuildApksResult.Builder resultBuilder = Commands.BuildApksResult.newBuilder();
        if (this.getGenerateStandaloneApks()) {
            ImmutableList<ModuleSplit> standaloneApks = new BundleSharder((ImmutableList<BundleModule>)modules, this.getOptimizationDimensions()).shardBundle();
            for (ModuleSplit standaloneApk : standaloneApks) {
                resultBuilder.addVariant(Commands.Variant.newBuilder().setTargeting(BuildApksCommand.standaloneApkVariantTargeting(standaloneApk)).addApkSet(this.writeStandaloneApk(standaloneApk)));
            }
        } else {
            Commands.Variant.Builder variant = Commands.Variant.newBuilder().setTargeting(BuildApksCommand.lPlusVariantTargeting());
            for (BundleModule module : modules) {
                ImmutableList<ModuleSplit> splitApks = new ModuleSplitter(module, this.getOptimizationDimensions()).splitModule();
                variant.addApkSet(this.writeSplitApks(splitApks, module));
            }
            resultBuilder.addVariant(variant);
        }
        Commands.BuildApksResult result = resultBuilder.build();
        this.writeResultProto(result);
        return result;
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
        FilePreconditions.checkDirectoryExists(this.getOutputDirectory());
    }

    private Commands.ApkSet writeSplitApks(ImmutableList<ModuleSplit> splitApks, BundleModule module) {
        ImmutableList apkDescriptions = (ImmutableList)splitApks.stream().map(split -> split.writeAsSplitApkTo(this.getSplitApkOutputPath((ModuleSplit)split, module))).collect(ImmutableList.toImmutableList());
        return Commands.ApkSet.newBuilder().setModuleMetadata(Commands.ModuleMetadata.newBuilder().setName(module.getName().getName()).setOnDemand(module.getManifest().isDynamicModule())).addAllApkDescription((Iterable<? extends Commands.ApkDescription>)apkDescriptions).build();
    }

    private Path getSplitApkOutputPath(ModuleSplit apk, BundleModule module) {
        String splitId = apk.getAndroidManifest().get().getSplitId().orElse("master");
        String fileSuffix = (String)Iterables.getLast(Arrays.asList(splitId.split("\\.")));
        String fileName = String.format("%s-%s.apk", module.getName(), fileSuffix);
        return this.getOutputDirectory().resolve(fileName);
    }

    private Commands.ApkSet writeStandaloneApk(ModuleSplit standaloneApk) {
        Commands.ApkDescription standaloneApkDescription = standaloneApk.writeAsStandaloneApkTo(this.getStandaloneApkOutputPath(standaloneApk));
        return Commands.ApkSet.newBuilder().setModuleMetadata(Commands.ModuleMetadata.newBuilder().setName("base")).addApkDescription(standaloneApkDescription).build();
    }

    private Path getStandaloneApkOutputPath(ModuleSplit apk) {
        String fileName = String.format("standalone-%s.apk", apk.getSuffix());
        return this.getOutputDirectory().resolve(fileName);
    }

    private void writeResultProto(Commands.BuildApksResult result) {
        Path splitInfoFile = this.getOutputDirectory().resolve(FileUtils.getBaseFileName(this.getBundlePath()) + "-apks.pb.json");
        try {
            Files.write(splitInfoFile, JsonFormat.printer().print((MessageOrBuilder)result).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error while writing to the split info file to '%s'", splitInfoFile);
        }
    }

    private static Targeting.VariantTargeting lPlusVariantTargeting() {
        return Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build();
    }

    private static Targeting.VariantTargeting standaloneApkVariantTargeting(ModuleSplit standaloneApk) {
        Targeting.ApkTargeting apkTargeting = standaloneApk.getTargeting();
        Targeting.VariantTargeting.Builder variantTargeting = Targeting.VariantTargeting.newBuilder();
        if (apkTargeting.hasAbiTargeting()) {
            variantTargeting.setAbiTargeting(apkTargeting.getAbiTargeting());
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            variantTargeting.setScreenDensityTargeting(apkTargeting.getScreenDensityTargeting());
        }
        return variantTargeting.build();
    }

    public static void help() {
        System.out.printf("bundletool %s --%s=<bundle.zip> --%s=<module-names> --%s=<output-dir> [--%s=%s] [--%s]\n", COMMAND_NAME, BUNDLE_LOCATION_FLAG, MODULES_FLAG, OUTPUT_DIRECTORY_FLAG, OPTIMIZE_FOR_FLAG, BuildApksCommand.joinFlagOptions(OptimizationDimension.values()), STANDALONE_FLAG);
        System.out.println("Generates split APKs or standalone APKs for the given set of");
        System.out.println("bundle modules.");
        System.out.println("The command outputs <bundle-name>-splits.pb.json file with information");
        System.out.println("about the generated files.");
        System.out.println();
        System.out.printf("--%s: Path to the Android App Bundle to generate APKs from.\n", BUNDLE_LOCATION_FLAG);
        System.out.printf("--%s: List of the module names for which the split APKs must be generated. If not set, applies to all the modules of the Android App Bundle.\n", MODULES_FLAG);
        System.out.printf("--%s: Path to the directory where the APKs will be created.\n", OUTPUT_DIRECTORY_FLAG);
        System.out.printf("--%s: If set, will generate APKs with optimizations for the given dimensions. Acceptable values are '%s'.\n", OPTIMIZE_FOR_FLAG, BuildApksCommand.joinFlagOptions(OptimizationDimension.values()));
        System.out.printf("--%s: Whether the generated APKs should be standalone. A standalone APK will include all the modules (specified by the --modules flag) and can thus be installed on devices with SDK < 21 with no support for split APKs.\nIf present, flag --%s supports only the values '%s'.\n", STANDALONE_FLAG, OPTIMIZE_FOR_FLAG, BuildApksCommand.joinFlagOptions(OptimizationDimension.ABI, OptimizationDimension.DENSITY));
    }

    private static String joinFlagOptions(Enum<?> ... flagOptions) {
        return Arrays.stream(flagOptions).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining("|"));
    }

    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputDirectory(Path var1);

        public abstract Builder setModuleNames(ImmutableList<BundleModuleName> var1);

        public abstract Builder setOptimizationDimensions(ImmutableList<OptimizationDimension> var1);

        public abstract Builder setGenerateStandaloneApks(boolean var1);

        public abstract BuildApksCommand build();
    }
}

