/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.mergers.MergingUtils;
import com.android.tools.build.bundletool.mergers.ModuleSplitMerger;
import com.android.tools.build.bundletool.mergers.ResourceTableMerger;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ModuleSplitsToShardMerger
implements ModuleSplitMerger {
    public ImmutableList<ModuleSplit> merge(ImmutableCollection<ModuleSplit> splits) {
        ModuleSplit.Builder builder = ModuleSplit.builder();
        ImmutableList.Builder entries = ImmutableList.builder();
        AndroidManifest mergedManifest = null;
        Resources.ResourceTable mergedResourceTable = null;
        Files.NativeLibraries mergedNativeConfig = null;
        BundleModuleName mergedModuleName = null;
        Targeting.ApkTargeting mergedSplitTargeting = null;
        for (ModuleSplit split : splits) {
            if (split.getAndroidManifest().isPresent()) {
                mergedManifest = MergingUtils.getSameValueOrNonNull(mergedManifest, split.getAndroidManifest().get()).orElseThrow(() -> new IllegalStateException("Encountered two distinct manifests while merging."));
            }
            if (split.getResourceTable().isPresent()) {
                mergedResourceTable = MergingUtils.getMergedValueOrNonNull(mergedResourceTable, split.getResourceTable().get(), new ResourceTableMerger()::merge);
            }
            if (split.getNativeConfig().isPresent()) {
                mergedNativeConfig = MergingUtils.getSameValueOrNonNull(mergedNativeConfig, split.getNativeConfig().get()).orElseThrow(() -> new IllegalStateException("Encountered two distinct native configs while merging."));
            }
            mergedModuleName = MergingUtils.getSameValueOrNonNull(mergedModuleName, split.getModuleName()).orElseThrow(() -> new IllegalStateException("Encountered two distinct module names while merging."));
            mergedSplitTargeting = MergingUtils.mergeProtos(mergedSplitTargeting, split.getTargeting());
            entries.addAll(split.getEntries());
        }
        if (mergedManifest != null) {
            builder.setAndroidManifest(mergedManifest);
        }
        if (mergedResourceTable != null) {
            builder.setResourceTable(mergedResourceTable);
        }
        if (mergedNativeConfig != null) {
            builder.setNativeConfig(mergedNativeConfig);
        }
        if (mergedModuleName != null) {
            builder.setModuleName(mergedModuleName);
        }
        builder.setTargeting(mergedSplitTargeting);
        builder.setEntries((List<ModuleEntry>)entries.build());
        builder.setMasterSplit(false);
        return ImmutableList.of((Object)builder.build());
    }
}

