/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.HashSet;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Move;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;

class MoveEliminator {
    private final HashSet<Move> activeMoves = new HashSet();
    private final RegisterAllocator allocator;

    MoveEliminator(RegisterAllocator allocator) {
        this.allocator = allocator;
    }

    public boolean shouldBeEliminated(Instruction instruction) {
        if (instruction.isMove()) {
            int moveDstRegister;
            Move move = instruction.asMove();
            int moveSrcRegister = this.allocator.getRegisterForValue(move.src(), move.getNumber());
            if (moveSrcRegister == (moveDstRegister = this.allocator.getRegisterForValue(move.dest(), move.getNumber()))) {
                return true;
            }
            for (Move activeMove : this.activeMoves) {
                int activeMoveSrcRegister = this.allocator.getRegisterForValue(activeMove.src(), activeMove.getNumber());
                int activeMoveDstRegister = this.allocator.getRegisterForValue(activeMove.dest(), activeMove.getNumber());
                if (activeMoveSrcRegister == moveSrcRegister && activeMoveDstRegister == moveDstRegister) {
                    return true;
                }
                if (activeMoveDstRegister != moveSrcRegister || activeMoveSrcRegister != moveDstRegister) continue;
                if (!move.outType().isWide()) {
                    return true;
                }
                if (moveSrcRegister == moveDstRegister + 1 || moveSrcRegister + 1 == moveDstRegister) continue;
                return true;
            }
        }
        if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
            Value defined = instruction.outValue();
            int definedRegister = this.allocator.getRegisterForValue(defined, instruction.getNumber());
            this.activeMoves.removeIf(m -> {
                int moveSrcRegister = this.allocator.getRegisterForValue(m.src(), m.getNumber());
                int moveDstRegister = this.allocator.getRegisterForValue(m.dest(), m.getNumber());
                for (int i = 0; i < defined.requiredRegisters(); ++i) {
                    for (int j = 0; j < m.outValue().requiredRegisters(); ++j) {
                        if (definedRegister + i != moveDstRegister + j && definedRegister + i != moveSrcRegister + j) continue;
                        return true;
                    }
                }
                return false;
            });
        }
        if (instruction.isMove()) {
            this.activeMoves.add(instruction.asMove());
        }
        return false;
    }
}

