/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_InMemoryModuleEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

@Immutable
@AutoValue
public abstract class InMemoryModuleEntry
implements ModuleEntry {
    @Override
    public abstract ZipPath getPath();

    protected abstract ByteString getContentAsBytes();

    @Override
    public abstract boolean isDirectory();

    @Override
    public abstract boolean shouldCompress();

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.getContentAsBytes().toByteArray());
    }

    @Override
    public InMemoryModuleEntry setCompression(boolean shouldCompress) {
        if (shouldCompress == this.shouldCompress()) {
            return this;
        }
        return InMemoryModuleEntry.create(this.getPath(), this.getContentAsBytes(), this.isDirectory(), shouldCompress);
    }

    public static InMemoryModuleEntry ofFile(String path, byte[] content) {
        return InMemoryModuleEntry.ofFile(ZipPath.create(path), content);
    }

    public static InMemoryModuleEntry ofFile(ZipPath path, byte[] content) {
        return new AutoValue_InMemoryModuleEntry(path, ByteString.copyFrom((byte[])content), false, true);
    }

    public static InMemoryModuleEntry ofFile(String path, byte[] content, boolean shouldCompress) {
        return new AutoValue_InMemoryModuleEntry(ZipPath.create(path), ByteString.copyFrom((byte[])content), false, shouldCompress);
    }

    public static InMemoryModuleEntry ofDirectory(String path) {
        return new AutoValue_InMemoryModuleEntry(ZipPath.create(path), ByteString.copyFrom((byte[])new byte[0]), true, true);
    }

    private static InMemoryModuleEntry create(ZipPath zipPath, ByteString content, boolean isDirectory, boolean shouldCompress) {
        return new AutoValue_InMemoryModuleEntry(zipPath, content, isDirectory, shouldCompress);
    }
}

