/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.android.tools.build.bundletool.model.SizeConfiguration;
import com.android.tools.build.bundletool.model.utils.CsvFormatter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class GetSizeCsvUtils {
    private static final Ordering<GetSizeRequest.Dimension> DIMENSIONS_COMPARATOR = Ordering.explicit((Object)((Object)GetSizeRequest.Dimension.SDK), (Object[])new GetSizeRequest.Dimension[]{GetSizeRequest.Dimension.ABI, GetSizeRequest.Dimension.SCREEN_DENSITY, GetSizeRequest.Dimension.LANGUAGE});

    public static String getSizeTotalOutputInCsv(ConfigurationSizes configurationSizes, ImmutableSet<GetSizeRequest.Dimension> dimensions) {
        Preconditions.checkState((boolean)configurationSizes.getMinSizeConfigurationMap().keySet().equals((Object)configurationSizes.getMaxSizeConfigurationMap().keySet()), (Object)"Min and Max maps should contains same keys.");
        CsvFormatter.Builder csvFormatter = CsvFormatter.builder();
        csvFormatter.setHeader(GetSizeCsvUtils.getSizeTotalCsvHeader(dimensions));
        for (SizeConfiguration sizeConfiguration : configurationSizes.getMinSizeConfigurationMap().keySet()) {
            csvFormatter.addRow(GetSizeCsvUtils.getSizeTotalCsvRow(dimensions, sizeConfiguration, (Long)configurationSizes.getMinSizeConfigurationMap().get((Object)sizeConfiguration), (Long)configurationSizes.getMaxSizeConfigurationMap().get((Object)sizeConfiguration)));
        }
        return csvFormatter.build().format();
    }

    private static ImmutableList<String> getSizeTotalCsvHeader(ImmutableSet<GetSizeRequest.Dimension> dimensions) {
        return (ImmutableList)Stream.concat(dimensions.stream().sorted(DIMENSIONS_COMPARATOR).map(Enum::name), Stream.of("MIN", "MAX")).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<String> getSizeTotalCsvRow(ImmutableSet<GetSizeRequest.Dimension> dimensions, SizeConfiguration sizeConfiguration, long minSize, long maxSize) {
        ImmutableMap dimensionToTextMap = ImmutableMap.of((Object)((Object)GetSizeRequest.Dimension.ABI), sizeConfiguration::getAbi, (Object)((Object)GetSizeRequest.Dimension.SDK), sizeConfiguration::getSdkVersion, (Object)((Object)GetSizeRequest.Dimension.LANGUAGE), sizeConfiguration::getLocale, (Object)((Object)GetSizeRequest.Dimension.SCREEN_DENSITY), sizeConfiguration::getScreenDensity);
        return (ImmutableList)Stream.concat(dimensions.stream().sorted(DIMENSIONS_COMPARATOR).map(dimension -> ((Optional)((Supplier)dimensionToTextMap.get((Object)dimension)).get()).orElse("")), Stream.of(String.valueOf(minSize), String.valueOf(maxSize))).collect(ImmutableList.toImmutableList());
    }

    private GetSizeCsvUtils() {
    }
}

