/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.SparseConditionalConstantPropagation;
import shadow.bundletool.com.android.tools.r8.ir.code.AlwaysMaterializingDefinition;
import shadow.bundletool.com.android.tools.r8.ir.code.AlwaysMaterializingUser;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraph;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallSiteInformation;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.LensCodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OptimizationFeedbackDirect;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OptimizationFeedbackIgnore;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.StringConcatRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.ConstantCanonicalizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DeadCodeRemover;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.MemberValuePropagation;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Outliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierNameStringMarker;
import shadow.bundletool.com.android.tools.r8.shaking.protolite.ProtoLitePruner;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class IRConverter {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    private final Timing timing;
    public final AppInfo appInfo;
    private final Outliner outliner;
    private final StringConcatRewriter stringConcatRewriter;
    private final LambdaRewriter lambdaRewriter;
    private final InterfaceMethodRewriter interfaceMethodRewriter;
    private final InternalOptions options;
    private final CfgPrinter printer;
    private final GraphLense graphLense;
    private final CodeRewriter codeRewriter;
    private final MemberValuePropagation memberValuePropagation;
    private final LensCodeRewriter lensCodeRewriter;
    private final Inliner inliner;
    private final ProtoLitePruner protoLiteRewriter;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final OptimizationFeedback ignoreOptimizationFeedback = new OptimizationFeedbackIgnore();
    private DexString highestSortingString;

    private IRConverter(AppInfo appInfo, InternalOptions options, Timing timing, CfgPrinter printer, GraphLense graphLense, boolean enableWholeProgramOptimizations) {
        assert (appInfo != null);
        assert (options != null);
        assert (options.programConsumer != null);
        this.timing = timing != null ? timing : new Timing("internal");
        this.appInfo = appInfo;
        this.graphLense = graphLense != null ? graphLense : GraphLense.getIdentityLense();
        this.options = options;
        this.printer = printer;
        this.codeRewriter = new CodeRewriter(appInfo, this.libraryMethodsReturningReceiver(), options);
        this.stringConcatRewriter = new StringConcatRewriter(options.itemFactory);
        this.lambdaRewriter = options.enableDesugaring ? new LambdaRewriter(this) : null;
        InterfaceMethodRewriter interfaceMethodRewriter = this.interfaceMethodRewriter = options.enableDesugaring && this.enableInterfaceMethodDesugaring() ? new InterfaceMethodRewriter(this, options) : null;
        if (enableWholeProgramOptimizations) {
            assert (appInfo.hasLiveness());
            this.inliner = new Inliner(appInfo.withLiveness(), graphLense, options);
            this.outliner = new Outliner(appInfo.withLiveness(), options);
            this.memberValuePropagation = options.propagateMemberValue ? new MemberValuePropagation(appInfo.withLiveness()) : null;
            this.lensCodeRewriter = new LensCodeRewriter(graphLense, appInfo.withSubtyping());
            if (appInfo.hasLiveness()) {
                ProtoLitePruner protoLitePruner = this.protoLiteRewriter = options.forceProguardCompatibility ? null : new ProtoLitePruner(appInfo.withLiveness());
                this.identifierNameStringMarker = !appInfo.withLiveness().identifierNameStrings.isEmpty() && !options.skipMinification ? new IdentifierNameStringMarker(appInfo.withLiveness()) : null;
            } else {
                this.protoLiteRewriter = null;
                this.identifierNameStringMarker = null;
            }
        } else {
            this.inliner = null;
            this.outliner = null;
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.protoLiteRewriter = null;
            this.identifierNameStringMarker = null;
        }
    }

    public IRConverter(AppInfo appInfo, InternalOptions options) {
        this(appInfo, options, null, null, null, false);
    }

    public IRConverter(AppInfo appInfo, InternalOptions options, Timing timing, CfgPrinter printer) {
        this(appInfo, options, timing, printer, null, false);
    }

    public IRConverter(AppInfoWithSubtyping appInfo, InternalOptions options, Timing timing, CfgPrinter printer, GraphLense graphLense) {
        this(appInfo, options, timing, printer, graphLense, true);
    }

    private boolean enableInterfaceMethodDesugaring() {
        switch (this.options.interfaceMethodDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseDefaultAndStaticInterfaceMethods();
            }
        }
        throw new Unreachable();
    }

    private boolean enableTryWithResourcesDesugaring() {
        switch (this.options.tryWithResourcesDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseSuppressedExceptions();
            }
        }
        throw new Unreachable();
    }

    private Set<DexMethod> libraryMethodsReturningReceiver() {
        HashSet<DexMethod> methods = new HashSet<DexMethod>();
        DexItemFactory dexItemFactory = this.appInfo.dexItemFactory;
        dexItemFactory.stringBufferMethods.forEachAppendMethod(methods::add);
        dexItemFactory.stringBuilderMethods.forEachAppendMethod(methods::add);
        return methods;
    }

    private void removeLambdaDeserializationMethods() {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.removeLambdaDeserializationMethods(this.appInfo.classes());
        }
    }

    private void synthesizeLambdaClasses(DexApplication.Builder<?> builder) throws ApiLevelException {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.adjustAccessibility();
            this.lambdaRewriter.synthesizeLambdaClasses(builder);
        }
    }

    private void desugarInterfaceMethods(DexApplication.Builder<?> builder, InterfaceMethodRewriter.Flavor includeAllResources) throws ApiLevelException {
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.desugarInterfaceMethods(builder, includeAllResources);
        }
    }

    public DexApplication convertToDex(DexApplication application, ExecutorService executor) throws ExecutionException, ApiLevelException {
        this.removeLambdaDeserializationMethods();
        this.convertClassesToDex(application.classes(), executor);
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        this.synthesizeLambdaClasses(builder);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.ExcludeDexResources);
        this.handleSynthesizedClassMapping(builder);
        return builder.build();
    }

    private void handleSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        if (this.options.intermediate) {
            this.updateSynthesizedClassMapping(builder);
        }
        this.updateMainDexListWithSynthesizedClassMap(builder);
        if (!this.options.intermediate) {
            this.clearSynthesizedClassMapping(builder);
        }
    }

    private void updateMainDexListWithSynthesizedClassMap(DexApplication.Builder<?> builder) {
        Set<DexType> inputMainDexList = builder.getMainDexList();
        if (!inputMainDexList.isEmpty()) {
            Map programClasses = builder.getProgramClasses().stream().collect(Collectors.toMap(programClass -> programClass.type, Function.identity()));
            ArrayList<DexType> synthesized = new ArrayList<DexType>();
            for (DexType dexType : inputMainDexList) {
                DexProgramClass programClass2 = (DexProgramClass)programClasses.get(dexType);
                if (programClass2 == null) continue;
                synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(programClass2, builder.dexItemFactory));
            }
            builder.addToMainDexList(synthesized);
        }
    }

    private void clearSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        for (DexProgramClass programClass : builder.getProgramClasses()) {
            programClass.annotations = programClass.annotations.getWithout(builder.dexItemFactory.annotationSynthesizedClassMap);
        }
    }

    private void updateSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        ArrayListMultimap originalToSynthesized = ArrayListMultimap.create();
        for (DexProgramClass dexProgramClass2 : builder.getSynthesizedClasses()) {
            for (DexProgramClass original : dexProgramClass2.getSynthesizedFrom()) {
                originalToSynthesized.put((Object)original, (Object)dexProgramClass2);
            }
        }
        for (Map.Entry entry : originalToSynthesized.asMap().entrySet()) {
            DexProgramClass original = (DexProgramClass)entry.getKey();
            HashSet<DexType> synthesized = new HashSet<DexType>();
            ((Collection)entry.getValue()).stream().map(dexProgramClass -> dexProgramClass.type).forEach(synthesized::add);
            synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(original, builder.dexItemFactory));
            DexAnnotation updatedAnnotation = DexAnnotation.createAnnotationSynthesizedClassMap(synthesized, builder.dexItemFactory);
            original.annotations = original.annotations.getWithAddedOrReplaced(updatedAnnotation);
        }
    }

    private void convertClassesToDex(Iterable<DexProgramClass> classes, ExecutorService executor) throws ExecutionException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexProgramClass clazz : classes) {
            futures.add(executor.submit(() -> {
                clazz.forEachMethodThrowing(this::convertMethodToDex);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    void convertMethodToDex(DexEncodedMethod method) throws ApiLevelException {
        boolean matchesMethodFilter;
        if (method.getCode() != null && (matchesMethodFilter = this.options.methodMatchesFilter(method))) {
            if (method.getCode().isJarCode()) {
                this.rewriteCode(method, this.ignoreOptimizationFeedback, x -> true, CallSiteInformation.empty(), Outliner::noProcessing);
            }
            this.updateHighestSortingStrings(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexApplication optimize(DexApplication application) throws ExecutionException, ApiLevelException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.optimize(application, executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public DexApplication optimize(DexApplication application, ExecutorService executorService) throws ExecutionException, ApiLevelException {
        this.removeLambdaDeserializationMethods();
        OptimizationFeedbackDirect directFeedback = new OptimizationFeedbackDirect();
        this.timing.begin("Build call graph");
        CallGraph callGraph = CallGraph.build(application, this.appInfo.withLiveness(), this.graphLense, this.options);
        this.timing.end();
        this.timing.begin("IR conversion phase 1");
        callGraph.forEachMethod((method, isProcessedConcurrently) -> this.processMethod((DexEncodedMethod)method, directFeedback, (Predicate<DexEncodedMethod>)isProcessedConcurrently, callGraph, this.outliner == null ? Outliner::noProcessing : this.outliner::identifyCandidates), executorService);
        this.timing.end();
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        if (this.inliner != null) {
            this.inliner.processDoubleInlineCallers(this, this.ignoreOptimizationFeedback);
        }
        this.synthesizeLambdaClasses(builder);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.IncludeAllResources);
        this.handleSynthesizedClassMapping(builder);
        if (this.outliner != null) {
            this.timing.begin("IR conversion phase 2");
            DexProgramClass outlineClass = this.prepareOutlining();
            if (outlineClass != null) {
                CallGraph callGraph2 = CallGraph.build(application, this.appInfo.withLiveness(), GraphLense.getIdentityLense(), this.options);
                Set<DexEncodedMethod> outlineMethods = this.outliner.getMethodsSelectedForOutlining();
                callGraph2.forEachMethod((method, isProcessedConcurrently) -> {
                    if (!outlineMethods.contains(method)) {
                        return;
                    }
                    assert (!method.getCode().isOutlineCode());
                    this.processMethod((DexEncodedMethod)method, this.ignoreOptimizationFeedback, (Predicate<DexEncodedMethod>)isProcessedConcurrently, callGraph2, this.outliner::applyOutliningCandidate);
                    assert (method.isProcessed());
                }, executorService);
                builder.addSynthesizedClass(outlineClass, true);
                this.clearDexMethodCompilationState(outlineClass);
            }
            this.timing.end();
        }
        this.clearDexMethodCompilationState();
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInFields();
        }
        return builder.build();
    }

    private void clearDexMethodCompilationState() {
        this.appInfo.classes().forEach(this::clearDexMethodCompilationState);
    }

    private void clearDexMethodCompilationState(DexProgramClass clazz) {
        clazz.forEachMethod(DexEncodedMethod::markNotProcessed);
    }

    public void replaceCodeForTesting(DexEncodedMethod method, IRCode code) {
        assert (code.isConsistentSSA());
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.options);
    }

    private DexType computeOutlineClassType() {
        String name;
        DexType result;
        int count = 0;
        do {
            name = "r8.GeneratedOutlineSupport" + (count == 0 ? "" : Integer.toString(count));
            ++count;
        } while (this.appInfo.definitionFor(result = this.appInfo.dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(name))) != null);
        this.appInfo.registerNewType(result, this.appInfo.dexItemFactory.objectType);
        return result;
    }

    private DexProgramClass prepareOutlining() throws ApiLevelException {
        if (!this.outliner.selectMethodsForOutlining()) {
            return null;
        }
        DexProgramClass outlineClass = this.outliner.buildOutlinerClass(this.computeOutlineClassType());
        this.optimizeSynthesizedClass(outlineClass);
        return outlineClass;
    }

    public void optimizeSynthesizedClass(DexProgramClass clazz) throws ApiLevelException {
        clazz.forEachMethodThrowing(this::optimizeSynthesizedMethod);
    }

    public void optimizeSynthesizedMethod(DexEncodedMethod method) throws ApiLevelException {
        this.processMethod(method, this.ignoreOptimizationFeedback, x -> false, CallSiteInformation.empty(), Outliner::noProcessing);
    }

    private String logCode(InternalOptions options, DexEncodedMethod method) {
        return options.useSmaliSyntax ? method.toSmaliString(null) : method.codeToString();
    }

    public void processMethod(DexEncodedMethod method, OptimizationFeedback feedback, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) throws ApiLevelException {
        Code code = method.getCode();
        boolean matchesMethodFilter = this.options.methodMatchesFilter(method);
        if (code != null && matchesMethodFilter) {
            this.rewriteCode(method, feedback, isProcessedConcurrently, callSiteInformation, outlineHandler);
        } else {
            method.markProcessed(Inliner.Constraint.NEVER);
        }
    }

    private void rewriteCode(DexEncodedMethod method, OptimizationFeedback feedback, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) throws ApiLevelException {
        IRCode code;
        if (this.options.verbose) {
            this.options.reporter.info(new StringDiagnostic("Processing: " + method.toSourceString()));
        }
        if ((code = method.buildIR(this.appInfo, this.options)) == null) {
            feedback.markProcessed(method, Inliner.Constraint.NEVER);
            return;
        }
        this.printC1VisualizerHeader(method);
        this.printMethod(code, "Initial IR (SSA)");
        if (this.options.debug) {
            this.codeRewriter.simplifyDebugLocals(code);
        }
        if (!method.isProcessed()) {
            if (this.protoLiteRewriter != null && this.protoLiteRewriter.appliesTo(method)) {
                this.protoLiteRewriter.rewriteProtoLiteSpecialMethod(code, method);
            }
            if (this.lensCodeRewriter != null) {
                this.lensCodeRewriter.rewrite(code, method);
            } else assert (this.graphLense.isIdentityLense());
        }
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInMethod(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.memberValuePropagation != null) {
            this.memberValuePropagation.rewriteWithConstantValues(code, method.method.holder);
        }
        if (this.options.removeSwitchMaps && this.appInfo.hasLiveness()) {
            this.codeRewriter.removeSwitchMaps(code);
        }
        if (this.options.disableAssertions) {
            this.codeRewriter.disableAssertions(code);
        }
        if (this.options.inlineAccessors && this.inliner != null) {
            assert (!this.options.debug);
            this.inliner.performInlining(method, code, isProcessedConcurrently, callSiteInformation);
        }
        this.codeRewriter.removeCastChains(code);
        this.codeRewriter.rewriteLongCompareAndRequireNonNull(code, this.options);
        this.codeRewriter.commonSubexpressionElimination(code);
        this.codeRewriter.simplifyArrayConstruction(code);
        this.codeRewriter.rewriteMoveResult(code);
        this.codeRewriter.splitRangeInvokeConstants(code);
        new SparseConditionalConstantPropagation(code).run();
        this.codeRewriter.rewriteSwitch(code);
        this.codeRewriter.simplifyIf(code);
        if (!this.options.debug) {
            this.codeRewriter.collectClassInitializerDefaults(method, code);
        }
        DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.options);
        assert (code.isConsistentSSA());
        if (this.options.enableDesugaring && this.enableTryWithResourcesDesugaring()) {
            this.codeRewriter.rewriteThrowableAddAndGetSuppressed(code);
        }
        this.stringConcatRewriter.desugarStringConcats(method.method, code);
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.desugarLambdas(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.rewriteMethodReferences(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.options.outline.enabled) {
            outlineHandler.accept(code, method);
            assert (code.isConsistentSSA());
        }
        ConstantCanonicalizer.canonicalize(code);
        this.codeRewriter.useDedicatedConstantForLitInstruction(code);
        this.codeRewriter.shortenLiveRanges(code);
        this.codeRewriter.identifyReturnsArgument(method, code, feedback);
        if (this.options.methodMatchesLogArgumentsFilter(method)) {
            this.codeRewriter.logArgumentTypes(method, code);
            assert (code.isConsistentSSA());
        }
        this.printMethod(code, "Optimized IR (SSA)");
        this.finalizeIR(method, code, feedback);
    }

    private void finalizeIR(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        if (this.options.isGeneratingClassFiles()) {
            this.finalizeToCf(method, code, feedback);
        } else {
            assert (this.options.isGeneratingDex());
            this.finalizeToDex(method, code, feedback);
        }
    }

    private void finalizeToCf(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        assert (!method.getCode().isDexCode());
        CfBuilder builder = new CfBuilder(method, code, this.options.itemFactory);
        Code result = builder.build(this.codeRewriter, this.options, this.appInfo.withSubtyping());
        assert (result.isCfCode() || result.isJarCode());
        method.setCode(result);
        this.markProcessed(method, code, feedback);
    }

    private void finalizeToDex(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.options);
        this.updateHighestSortingStrings(method);
        this.printMethod(code, "Final IR (non-SSA)");
        this.markProcessed(method, code, feedback);
    }

    private void markProcessed(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        Inliner.Constraint state = !this.options.inlineAccessors || this.inliner == null ? Inliner.Constraint.NEVER : this.inliner.computeInliningConstraint(code, method);
        feedback.markProcessed(method, state);
    }

    private synchronized void updateHighestSortingStrings(DexEncodedMethod method) {
        DexString highestSortingReferencedString = method.getCode().asDexCode().highestSortingString;
        if (highestSortingReferencedString != null && (this.highestSortingString == null || highestSortingReferencedString.slowCompareTo(this.highestSortingString) > 0)) {
            this.highestSortingString = highestSortingReferencedString;
        }
    }

    private RegisterAllocator performRegisterAllocation(IRCode code, DexEncodedMethod method) {
        DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.options);
        IRConverter.materializeInstructionBeforeLongOperationsWorkaround(code, this.options);
        LinearScanRegisterAllocator registerAllocator = new LinearScanRegisterAllocator(code, this.options);
        registerAllocator.allocateRegisters(this.options.debug);
        this.printMethod(code, "After register allocation (non-SSA)");
        for (int i = 0; i < 2; ++i) {
            CodeRewriter.collapsTrivialGotos(method, code);
            PeepholeOptimizer.optimize(code, registerAllocator);
        }
        CodeRewriter.collapsTrivialGotos(method, code);
        return registerAllocator;
    }

    private static void materializeInstructionBeforeLongOperationsWorkaround(IRCode code, InternalOptions options) {
        if (!options.canHaveDex2OatLinkedListBug()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            Object firstMaterializing = it.nextUntil(IRConverter::isMaterializingInstructionOnArtArmVersionM);
            if (!IRConverter.needsInstructionBeforeLongOperation((Instruction)firstMaterializing)) continue;
            IRConverter.ensureInstructionBeforeLongOperation(code, block, (Instruction)firstMaterializing, it);
        }
    }

    private static void ensureInstructionBeforeLongOperation(IRCode code, BasicBlock block, Instruction firstMaterializing, InstructionListIterator it) {
        Instruction check = (Instruction)it.previous();
        assert (firstMaterializing == check);
        Value fixitValue = code.createValue(ValueType.INT);
        AlwaysMaterializingDefinition fixitDefinition = new AlwaysMaterializingDefinition(fixitValue);
        fixitDefinition.setBlock(block);
        fixitDefinition.setPosition(firstMaterializing.getPosition());
        it.add(fixitDefinition);
        AlwaysMaterializingUser fixitUser = new AlwaysMaterializingUser(fixitValue);
        fixitUser.setBlock(block);
        it.add(fixitUser);
    }

    private static boolean needsInstructionBeforeLongOperation(Instruction instruction) {
        if (!instruction.isAdd() && !instruction.isSub() || !instruction.outType().isWide()) {
            return false;
        }
        BasicBlock block = instruction.getBlock();
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return false;
        }
        return true;
    }

    private static boolean isMaterializingInstructionOnArtArmVersionM(Instruction instruction) {
        return !instruction.isDebugInstruction() && !instruction.isMove() && !IRConverter.isPossiblyNonMaterializingLongOperationOnArtArmVersionM(instruction);
    }

    private static boolean isPossiblyNonMaterializingLongOperationOnArtArmVersionM(Instruction instruction) {
        return (instruction.isMul() || instruction.isDiv()) && instruction.outType().isWide();
    }

    private void printC1VisualizerHeader(DexEncodedMethod method) {
        if (this.printer != null) {
            this.printer.begin("compilation");
            this.printer.print("name \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("method \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("date 0").ln();
            this.printer.end("compilation");
        }
    }

    private void printMethod(IRCode code, String title) {
        if (this.printer != null) {
            this.printer.resetUnusedValue();
            this.printer.begin("cfg");
            this.printer.print("name \"").append(title).append("\"\n");
            code.print(this.printer);
            this.printer.end("cfg");
        }
    }
}

