/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class ConstantCanonicalizer {
    private static final int MAX_CANONICALIZED_CONSTANT = 15;

    public static void canonicalize(IRCode code) {
        Object2ObjectLinkedOpenCustomHashMap valuesDefinedByConstant = new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ConstNumber>(){

            public int hashCode(ConstNumber constNumber) {
                return Long.hashCode(constNumber.getRawValue()) + 13 * constNumber.outType().hashCode();
            }

            public boolean equals(ConstNumber a, ConstNumber b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a != null && b != null && a.identicalNonValueNonPositionParts(b);
            }
        });
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isConstNumber() || current.outValue().hasLocalInfo() || ConstantCanonicalizer.constantUsedByInvokeRange(current.asConstNumber())) continue;
                ArrayList<Value> oldValuesDefinedByConstant = (ArrayList<Value>)valuesDefinedByConstant.get((Object)current);
                if (oldValuesDefinedByConstant == null) {
                    oldValuesDefinedByConstant = new ArrayList<Value>();
                    valuesDefinedByConstant.put((Object)current.asConstNumber(), oldValuesDefinedByConstant);
                }
                oldValuesDefinedByConstant.add(current.outValue());
            }
        }
        if (!valuesDefinedByConstant.isEmpty()) {
            Object2ObjectSortedMap.FastSortedEntrySet entries = valuesDefinedByConstant.object2ObjectEntrySet();
            entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(15L).forEach(entry -> {
                ConstNumber canonicalizedConstant = ((ConstNumber)entry.getKey()).asConstNumber();
                ConstNumber newConst = ConstNumber.copyOf(code, canonicalizedConstant);
                ConstantCanonicalizer.insertCanonicalizedConstant(code, newConst);
                newConst.setPosition(Position.none());
                for (Value outValue : (List)entry.getValue()) {
                    outValue.replaceUsers(newConst.outValue());
                }
            });
        }
        assert (code.isConsistentSSA());
    }

    private static void insertCanonicalizedConstant(IRCode code, ConstNumber canonicalizedConstant) {
        BasicBlock entryBlock = code.blocks.get(0);
        InstructionListIterator it = entryBlock.listIterator();
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedConstant);
    }

    private static boolean constantUsedByInvokeRange(ConstNumber constant) {
        for (Instruction user : constant.outValue().uniqueUsers()) {
            if (!user.isInvoke() || user.asInvoke().requiredArgumentRegisters() <= 5) continue;
            return true;
        }
        return false;
    }
}

