/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.ClassKind;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriter;
import shadow.bundletool.com.android.tools.r8.utils.ClassMap;

public class ProgramClassCollection
extends ClassMap<DexProgramClass> {
    public static ProgramClassCollection create(List<DexProgramClass> classes, ApplicationReader.ProgramClassConflictResolver conflictResolver) {
        ConcurrentHashMap<DexType, Supplier<DexProgramClass>> map = new ConcurrentHashMap<DexType, Supplier<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            map.merge(clazz.type, clazz, (a, b) -> conflictResolver.resolveClassConflict((DexProgramClass)a.get(), (DexProgramClass)b.get()));
        }
        return new ProgramClassCollection(map);
    }

    private ProgramClassCollection(ConcurrentHashMap<DexType, Supplier<DexProgramClass>> classes) {
        super(classes, null);
    }

    @Override
    public String toString() {
        return "program classes: " + super.toString();
    }

    @Override
    DexProgramClass resolveClassConflict(DexProgramClass a, DexProgramClass b) {
        return ProgramClassCollection.resolveClassConflictImpl(a, b);
    }

    @Override
    Supplier<DexProgramClass> getTransparentSupplier(DexProgramClass clazz) {
        return clazz;
    }

    @Override
    ClassKind getClassKind() {
        return ClassKind.PROGRAM;
    }

    public static DexProgramClass resolveClassConflictImpl(DexProgramClass a, DexProgramClass b) {
        if (a.originatesFromDexResource() && b.originatesFromDexResource() && a.accessFlags.isSynthetic() && b.accessFlags.isSynthetic() && LambdaRewriter.hasLambdaClassPrefix(a.type) && LambdaRewriter.hasLambdaClassPrefix(b.type)) {
            return a;
        }
        throw new CompilationError("Program type already present: " + a.type.toSourceString());
    }
}

