/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import shadow.bundletool.com.android.utils.ArrayUtils;

public class SparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        initialCapacity = ArrayUtils.idealIntArraySize(initialCapacity);
        this.mKeys = new int[initialCapacity];
        this.mValues = new Object[initialCapacity];
        this.mSize = 0;
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E valueIfKeyNotFound) {
        int i3 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i3 < 0 || this.mValues[i3] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i3];
    }

    public void delete(int key) {
        int i3 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i3 >= 0 && this.mValues[i3] != DELETED) {
            this.mValues[i3] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int key) {
        this.delete(key);
    }

    private void gc() {
        int n3 = this.mSize;
        int o3 = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i3 = 0; i3 < n3; ++i3) {
            Object val = values[i3];
            if (val == DELETED) continue;
            if (i3 != o3) {
                keys[o3] = keys[i3];
                values[o3] = val;
            }
            ++o3;
        }
        this.mGarbage = false;
        this.mSize = o3;
    }

    public void put(int key, E value) {
        int i3 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i3 >= 0) {
            this.mValues[i3] = value;
        } else {
            if ((i3 ^= 0xFFFFFFFF) < this.mSize && this.mValues[i3] == DELETED) {
                this.mKeys[i3] = key;
                this.mValues[i3] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i3 = ~SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n3 = ArrayUtils.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n3];
                Object[] nvalues = new Object[n3];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i3 != 0) {
                System.arraycopy(this.mKeys, i3, this.mKeys, i3 + 1, this.mSize - i3);
                System.arraycopy(this.mValues, i3, this.mValues, i3 + 1, this.mSize - i3);
            }
            this.mKeys[i3] = key;
            this.mValues[i3] = value;
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i3 = 0; i3 < this.mSize; ++i3) {
            if (this.mValues[i3] != value) continue;
            return i3;
        }
        return -1;
    }

    public void clear() {
        int n3 = this.mSize;
        Object[] values = this.mValues;
        for (int i3 = 0; i3 < n3; ++i3) {
            values[i3] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n3 = ArrayUtils.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n3];
            Object[] nvalues = new Object[n3];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public SparseArray<E> getUnmodifiable() {
        final SparseArray mStorage = this;
        return new SparseArray<E>(){

            @Override
            public E get(int key) {
                return mStorage.get(key);
            }

            @Override
            public E get(int key, E valueIfKeyNotFound) {
                return mStorage.get(key, valueIfKeyNotFound);
            }

            @Override
            public void delete(int key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void put(int key, E value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return mStorage.size();
            }

            @Override
            public int keyAt(int index) {
                return mStorage.keyAt(index);
            }

            @Override
            public E valueAt(int index) {
                return mStorage.valueAt(index);
            }

            @Override
            public void setValueAt(int index, E value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int indexOfKey(int key) {
                return mStorage.indexOfKey(key);
            }

            @Override
            public int indexOfValue(E value) {
                return mStorage.indexOfValue(value);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void append(int key, E value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static int binarySearch(int[] a3, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a3[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a3[high] == key) {
            return high;
        }
        return ~high;
    }
}

