/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;

public class TempDirectory
implements AutoCloseable {
    private final Path dirPath;

    public TempDirectory() {
        this(null);
    }

    public TempDirectory(@Nullable String prefix) {
        try {
            this.dirPath = Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e3) {
            throw new UncheckedIOException(e3);
        }
    }

    public Path getPath() {
        return this.dirPath;
    }

    @Override
    public void close() {
        try {
            MoreFiles.deleteRecursively((Path)this.dirPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e3) {
            throw new UncheckedIOException(e3);
        }
    }
}

