/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.AssertionsConfiguration;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommand;
import shadow.bundletool.com.android.tools.r8.ByteDataView;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.L8CommandParser;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.R8Command;
import shadow.bundletool.com.android.tools.r8.R8CommandParser;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Pair;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

@Keep
public final class L8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = R8CommandParser.USAGE_MESSAGE;
    private final D8Command d8Command;
    private final R8Command r8Command;
    private final DesugaredLibraryConfiguration libraryConfiguration;
    private final DexItemFactory factory;

    boolean isShrinking() {
        return this.r8Command != null;
    }

    D8Command getD8Command() {
        return this.d8Command;
    }

    R8Command getR8Command() {
        return this.r8Command;
    }

    public static Builder parse(String[] args, Origin origin) {
        return L8CommandParser.parse(args, origin);
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return L8CommandParser.parse(args, origin, handler);
    }

    private L8Command(R8Command r8Command, D8Command d8Command, AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer, StringConsumer mainDexListConsumer, int minApiLevel, Reporter diagnosticsHandler, DesugaredLibraryConfiguration libraryConfiguration, List<AssertionsConfiguration> assertionsConfiguration, DexItemFactory factory) {
        super(inputApp, mode, programConsumer, mainDexListConsumer, minApiLevel, diagnosticsHandler, true, false, false, (String name, Long checksum) -> true, assertionsConfiguration);
        this.d8Command = d8Command;
        this.r8Command = r8Command;
        this.libraryConfiguration = libraryConfiguration;
        this.factory = factory;
    }

    private L8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.r8Command = null;
        this.d8Command = null;
        this.libraryConfiguration = null;
        this.factory = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.factory, this.getReporter());
        assert (!internal.debug);
        boolean bl = internal.debug = this.getMode() == CompilationMode.DEBUG;
        assert (internal.mainDexListConsumer == null);
        assert (!internal.minimalMainDex);
        internal.minApiLevel = this.getMinApiLevel();
        assert (!internal.intermediate);
        assert (internal.readCompileTimeAnnotations);
        internal.programConsumer = this.getProgramConsumer();
        assert (internal.programConsumer instanceof ClassFileConsumer);
        assert (!internal.isShrinking());
        assert (!internal.isMinifying());
        assert (!internal.passthroughDexCode);
        assert (!internal.enableDynamicTypeOptimization);
        assert (!internal.enableInlining);
        assert (!internal.enableClassInlining);
        assert (!internal.enableHorizontalClassMerging);
        assert (!internal.enableVerticalClassMerging);
        assert (!internal.enableClassStaticizer);
        assert (!internal.enableEnumValueOptimization);
        assert (!internal.outline.enabled);
        assert (!internal.enableValuePropagation);
        assert (!internal.enableLambdaMerging);
        assert (!internal.enableTreeShakingOfLibraryMethodOverrides);
        internal.enableNonNullTracking = false;
        assert (internal.enableDesugaring);
        assert (internal.enableInheritanceClassInDexDistributor);
        internal.enableInheritanceClassInDexDistributor = false;
        internal.desugaredLibraryConfiguration = this.libraryConfiguration;
        assert (internal.assertionsConfiguration == null);
        internal.assertionsConfiguration = new AssertionConfigurationWithDefault(AssertionsConfiguration.AssertionTransformation.DISABLE, this.getAssertionsConfiguration());
        return internal;
    }

    static class DesugaredLibrary
    implements ClassFileConsumer,
    ProgramResourceProvider {
        private final List<ProgramResource> resources = new ArrayList<ProgramResource>();

        DesugaredLibrary() {
        }

        @Override
        public synchronized void accept(ByteDataView data2, String descriptor, DiagnosticsHandler handler) {
            this.resources.add(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.CF, data2.copyByteData(), Collections.singleton(descriptor)));
        }

        @Override
        public Collection<ProgramResource> getProgramResources() throws ResourceException {
            return this.resources;
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
        }
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<L8Command, Builder> {
        private final List<Pair<List<String>, Origin>> proguardConfigStrings = new ArrayList<Pair<List<String>, Origin>>();
        private final List<Path> proguardConfigFiles = new ArrayList<Path>();

        private Builder() {
            this(new DefaultL8DiagnosticsHandler());
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        public boolean isShrinking() {
            return !this.proguardConfigStrings.isEmpty() || !this.proguardConfigFiles.isEmpty();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.DEBUG;
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            Collections.addAll(this.proguardConfigFiles, paths);
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.proguardConfigFiles.addAll(paths);
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines, Origin origin) {
            this.proguardConfigStrings.add(new Pair<List<String>, Origin>(lines, origin));
            return this.self();
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (!this.hasDesugaredLibraryConfiguration()) {
                reporter.error("L8 requires a desugared library configuration");
            }
            if (this.getProgramConsumer() instanceof ClassFileConsumer) {
                reporter.error("L8 does not support compiling to class files");
            }
            if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                reporter.error("L8 does not support compiling to dex per class");
            }
            if (this.getAppBuilder().hasMainDexList()) {
                reporter.error("L8 does not support a main dex list");
            } else if (this.getMainDexListConsumer() != null) {
                reporter.error("L8 does not support generating a main dex list");
            }
            super.validate();
        }

        @Override
        L8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new L8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            if (this.getMode() == null) {
                this.setMode(this.defaultCompilationMode());
            }
            DexItemFactory factory = new DexItemFactory();
            DesugaredLibraryConfiguration libraryConfiguration = this.getDesugaredLibraryConfiguration(factory, true);
            R8Command r8Command = null;
            D8Command d8Command = null;
            AndroidApp inputs = this.getAppBuilder().build();
            DesugaredLibrary desugaredLibrary = new DesugaredLibrary();
            if (this.isShrinking()) {
                R8Command.Builder r8Builder = (R8Command.Builder)((R8Command.Builder)((R8Command.Builder)R8Command.builder(this.getReporter()).addProgramResourceProvider(desugaredLibrary).setMinApiLevel(this.getMinApiLevel())).setMode(this.getMode())).setProgramConsumer(this.getProgramConsumer());
                for (ClassFileResourceProvider classFileResourceProvider : inputs.getLibraryResourceProviders()) {
                    r8Builder.addLibraryResourceProvider(classFileResourceProvider);
                }
                for (Pair pair : this.proguardConfigStrings) {
                    r8Builder.addProguardConfiguration((List)pair.getFirst(), (Origin)pair.getSecond());
                }
                r8Builder.addProguardConfiguration(libraryConfiguration.getExtraKeepRules(), Origin.unknown());
                r8Builder.addProguardConfigurationFiles(this.proguardConfigFiles);
                r8Command = r8Builder.makeCommand();
            } else {
                D8Command.Builder d8Builder = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder(this.getReporter()).addProgramResourceProvider(desugaredLibrary)).setMinApiLevel(this.getMinApiLevel())).setMode(this.getMode())).setProgramConsumer(this.getProgramConsumer());
                for (ClassFileResourceProvider classFileResourceProvider : inputs.getLibraryResourceProviders()) {
                    d8Builder.addLibraryResourceProvider(classFileResourceProvider);
                }
                d8Command = d8Builder.makeCommand();
            }
            return new L8Command(r8Command, d8Command, inputs, this.getMode(), desugaredLibrary, this.getMainDexListConsumer(), this.getMinApiLevel(), this.getReporter(), libraryConfiguration, this.getAssertionsConfiguration(), factory);
        }
    }

    protected static class DefaultL8DiagnosticsHandler
    implements DiagnosticsHandler {
        protected DefaultL8DiagnosticsHandler() {
        }

        @Override
        public void error(Diagnostic error) {
            if (error instanceof DexFileOverflowDiagnostic) {
                DexFileOverflowDiagnostic overflowDiagnostic = (DexFileOverflowDiagnostic)error;
                DiagnosticsHandler.super.error(new StringDiagnostic(overflowDiagnostic.getDiagnosticMessage() + ". Library too large. L8 can only produce a single .dex file"));
                return;
            }
            DiagnosticsHandler.super.error(error);
        }
    }
}

