/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import shadow.bundletool.com.android.tools.r8.utils.VersionProperties;

public final class Version {
    public static final String LABEL = "2.0.23";

    private Version() {
    }

    public static String getVersionString() {
        return "2.0.23 (" + VersionProperties.INSTANCE.getDescription() + ")";
    }

    public static int getMajorVersion() {
        return Version.getMajorVersion(LABEL);
    }

    static int getMajorVersion(String label) {
        if (label.equals("master")) {
            return -1;
        }
        int start = 0;
        int end = label.indexOf(46);
        return Integer.parseInt(label.substring(start, end));
    }

    public static int getMinorVersion() {
        return Version.getMinorVersion(LABEL);
    }

    static int getMinorVersion(String label) {
        if (label.equals("master")) {
            return -1;
        }
        int start = label.indexOf(46) + 1;
        int end = label.indexOf(46, start);
        return Integer.parseInt(label.substring(start, end));
    }

    public static int getPatchVersion() {
        return Version.getPatchVersion(LABEL);
    }

    static int getPatchVersion(String label) {
        int start;
        if (label.equals("master")) {
            return -1;
        }
        int skip = label.indexOf(46) + 1;
        int end = label.indexOf(45, start = label.indexOf(46, skip) + 1);
        return Integer.parseInt(label.substring(start, end != -1 ? end : label.length()));
    }

    public static String getPreReleaseString() {
        return Version.getPreReleaseString(LABEL);
    }

    static String getPreReleaseString(String label) {
        if (label.equals("master")) {
            return null;
        }
        int start = label.indexOf(45) + 1;
        if (start > 0) {
            return label.substring(start);
        }
        return "";
    }

    public static boolean isDevelopmentVersion() {
        return Version.isDevelopmentVersion(LABEL, VersionProperties.INSTANCE.isEngineering());
    }

    static boolean isDevelopmentVersion(String label, boolean isEngineering) {
        return label.equals("master") || label.endsWith("-dev") || isEngineering;
    }
}

