/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNull;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstString;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvoke;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLoad;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNew;
import shadow.bundletool.com.android.tools.r8.cf.code.CfStackInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfStore;
import shadow.bundletool.com.android.tools.r8.cf.code.CfThrow;
import shadow.bundletool.com.android.tools.r8.code.Const;
import shadow.bundletool.com.android.tools.r8.code.ConstString;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.code.Throw;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.JumboStringRewriter;
import shadow.bundletool.com.android.tools.r8.dex.MethodToCodeObjectMapping;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.errors.InternalCompilerError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.desugar.NestBasedAccessDesugaring;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NestUtils;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.UpdatableMethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.EmulateInterfaceSyntheticCfCodeProvider;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.FieldAccessorSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.SynthesizedCode;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinMetadataSynthesizer;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public class DexEncodedMethod
extends KeyedDexItem<DexMethod> {
    public static final String CONFIGURATION_DEBUGGING_PREFIX = "Shaking error: Missing method in ";
    public static final DexEncodedMethod[] EMPTY_ARRAY = new DexEncodedMethod[0];
    public static final DexEncodedMethod SENTINEL = new DexEncodedMethod(null, null, null, ParameterAnnotationsList.empty(), null);
    public static final DexEncodedMethod ANNOTATION_REFERENCE = new DexEncodedMethod(null, null, null, ParameterAnnotationsList.empty(), null);
    public static final Int2ReferenceMap<DebugLocalInfo> NO_PARAMETER_INFO = new Int2ReferenceArrayMap<DebugLocalInfo>(0);
    public final DexMethod method;
    public final MethodAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    public ParameterAnnotationsList parameterAnnotationsList;
    private Code code;
    private CompilationState compilationState = CompilationState.NOT_PROCESSED;
    private MethodOptimizationInfo optimizationInfo = DefaultMethodOptimizationInfo.DEFAULT_INSTANCE;
    private CallSiteOptimizationInfo callSiteOptimizationInfo = CallSiteOptimizationInfo.BOTTOM;
    private int classFileVersion;
    private DexEncodedMethod defaultInterfaceMethodImplementation = null;
    private OptionalBool isLibraryMethodOverride = OptionalBool.unknown();
    private Int2ReferenceMap<DebugLocalInfo> parameterInfo = NO_PARAMETER_INFO;
    private boolean obsolete = false;
    private final boolean d8R8Synthesized;

    public boolean isD8R8Synthesized() {
        return this.d8R8Synthesized;
    }

    private void checkIfObsolete() {
        assert (!this.obsolete);
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete() {
        this.obsolete = true;
    }

    public DexEncodedMethod getDefaultInterfaceMethodImplementation() {
        return this.defaultInterfaceMethodImplementation;
    }

    public void setDefaultInterfaceMethodImplementation(DexEncodedMethod implementation) {
        assert (this.defaultInterfaceMethodImplementation == null);
        assert (implementation != null);
        assert (this.code != null);
        assert (this.code == implementation.getCode());
        this.accessFlags.setAbstract();
        this.removeCode();
        this.defaultInterfaceMethodImplementation = implementation;
    }

    public void unsetObsolete() {
        this.obsolete = false;
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code) {
        this(method, accessFlags, annotations, parameterAnnotationsList, code, -1);
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code, int classFileVersion) {
        this(method, accessFlags, annotations, parameterAnnotationsList, code, classFileVersion, false);
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code, boolean d8R8Synthesized) {
        this(method, accessFlags, annotations, parameterAnnotationsList, code, -1, d8R8Synthesized);
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code, int classFileVersion, boolean d8R8Synthesized) {
        this.method = method;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.parameterAnnotationsList = parameterAnnotationsList;
        this.code = code;
        this.classFileVersion = classFileVersion;
        this.d8R8Synthesized = d8R8Synthesized;
        assert (code == null || !this.shouldNotHaveCode());
        assert (parameterAnnotationsList != null);
    }

    public OptionalBool isLibraryMethodOverride() {
        return this.isNonPrivateVirtualMethod() ? this.isLibraryMethodOverride : OptionalBool.FALSE;
    }

    public void setLibraryMethodOverride(OptionalBool isLibraryMethodOverride) {
        assert (this.isNonPrivateVirtualMethod());
        assert (!isLibraryMethodOverride.isUnknown());
        assert (isLibraryMethodOverride.isPossiblyFalse() || this.isLibraryMethodOverride.isPossiblyTrue()) : "Method `" + this.method.toSourceString() + "` went from not overriding a library method to overriding a library method";
        assert (isLibraryMethodOverride.isPossiblyTrue() || this.isLibraryMethodOverride.isPossiblyFalse()) : "Method `" + this.method.toSourceString() + "` went from overriding a library method to not overriding a library method";
        this.isLibraryMethodOverride = isLibraryMethodOverride;
    }

    public boolean isProgramMethod(DexDefinitionSupplier definitions) {
        if (this.method.holder.isClassType()) {
            DexClass clazz = definitions.definitionFor(this.method.holder);
            return clazz != null && clazz.isProgramClass();
        }
        return false;
    }

    public boolean isProcessed() {
        this.checkIfObsolete();
        return this.compilationState != CompilationState.NOT_PROCESSED;
    }

    public boolean isAbstract() {
        return this.accessFlags.isAbstract();
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    public boolean isInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() || this.isClassInitializer();
    }

    public boolean isInstanceInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && !this.accessFlags.isStatic();
    }

    public boolean isDefaultInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() && this.method.proto.parameters.isEmpty();
    }

    public boolean isClassInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && this.accessFlags.isStatic();
    }

    public boolean isDefaultMethod() {
        return !this.isStatic() && !this.isAbstract() && !this.isPrivateMethod() && !this.isInstanceInitializer();
    }

    public boolean isVirtualMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isStatic() && !this.accessFlags.isConstructor();
    }

    public boolean isNonPrivateVirtualMethod() {
        this.checkIfObsolete();
        return !this.isPrivateMethod() && this.isVirtualMethod();
    }

    public boolean isNonAbstractVirtualMethod() {
        this.checkIfObsolete();
        return this.isVirtualMethod() && !this.accessFlags.isAbstract();
    }

    public boolean isNonAbstractNonNativeMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isAbstract() && !this.accessFlags.isNative();
    }

    public boolean isPublicized() {
        this.checkIfObsolete();
        return this.accessFlags.isPromotedToPublic();
    }

    public boolean isPublicMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPublic();
    }

    public boolean isPrivateMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPrivate();
    }

    public boolean isDirectMethod() {
        this.checkIfObsolete();
        return (this.accessFlags.isPrivate() || this.accessFlags.isConstructor()) && !this.accessFlags.isStatic();
    }

    @Override
    public boolean isStatic() {
        this.checkIfObsolete();
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        this.checkIfObsolete();
        return this.isStatic();
    }

    public boolean isSyntheticMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isSynthetic();
    }

    KmConstructor findCompatibleKotlinConstructor(List<KmConstructor> constructors, AppView<?> appView) {
        if (!this.isInstanceInitializer()) {
            return null;
        }
        for (KmConstructor constructor : constructors) {
            if (!KotlinMetadataSynthesizer.isCompatibleConstructor(constructor, this, appView)) continue;
            return constructor;
        }
        return null;
    }

    KmFunction findCompatibleKotlinExtension(List<KmFunction> extensions, AppView<?> appView) {
        if (!this.isStaticMember()) {
            return null;
        }
        for (KmFunction extension : extensions) {
            if (!KotlinMetadataSynthesizer.isCompatibleExtension(extension, this, appView)) continue;
            return extension;
        }
        return null;
    }

    KmFunction findCompatibleKotlinFunction(List<KmFunction> functions, AppView<?> appView) {
        if (this.isStaticMember()) {
            return null;
        }
        for (KmFunction function : functions) {
            if (!KotlinMetadataSynthesizer.isCompatibleFunction(function, this, appView)) continue;
            return function;
        }
        return null;
    }

    boolean isKotlinProperty(List<KmProperty> properties, AppView<?> appView) {
        return this.findCompatibleKotlinProperty(properties, appView) != null;
    }

    KmProperty findCompatibleKotlinProperty(List<KmProperty> properties, AppView<?> appView) {
        if (this.isStaticMember()) {
            return null;
        }
        for (KmProperty property : properties) {
            if (!KotlinMetadataSynthesizer.isCompatibleProperty(property, this, appView)) continue;
            return property;
        }
        return null;
    }

    public boolean isOnlyInlinedIntoNestMembers() {
        return this.compilationState == CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_NEST;
    }

    public boolean isInliningCandidate(DexEncodedMethod container, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        this.checkIfObsolete();
        return this.isInliningCandidate(container.method.holder, inliningReason, appInfo, whyAreYouNotInliningReporter);
    }

    public boolean isInliningCandidate(DexType containerType, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        this.checkIfObsolete();
        if (inliningReason == Inliner.Reason.FORCE) {
            if (!this.isInliningCandidate(containerType, Inliner.Reason.SIMPLE, appInfo, whyAreYouNotInliningReporter)) {
                throw new InternalCompilerError("FORCE inlining on non-inlinable: " + this.toSourceString());
            }
            return true;
        }
        switch (this.compilationState) {
            case PROCESSED_INLINING_CANDIDATE_ANY: {
                return true;
            }
            case PROCESSED_INLINING_CANDIDATE_SUBCLASS: {
                if (appInfo.isSubtype(containerType, this.method.holder)) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSubtype();
                return false;
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE: {
                if (containerType.isSamePackage(this.method.holder)) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSamePackage();
                return false;
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_NEST: {
                if (NestUtils.sameNest(containerType, this.method.holder, appInfo)) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSameNest();
                return false;
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_CLASS: {
                if (containerType == this.method.holder) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSameClass();
                return false;
            }
            case PROCESSED_NOT_INLINING_CANDIDATE: {
                whyAreYouNotInliningReporter.reportInlineeNotInliningCandidate();
                return false;
            }
            case NOT_PROCESSED: {
                whyAreYouNotInliningReporter.reportInlineeNotProcessed();
                return false;
            }
        }
        throw new Unreachable("Unexpected compilation state: " + (Object)((Object)this.compilationState));
    }

    public boolean markProcessed(Inliner.ConstraintWithTarget state) {
        this.checkIfObsolete();
        CompilationState prevCompilationState = this.compilationState;
        switch (state.constraint) {
            case ALWAYS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_ANY;
                break;
            }
            case SUBCLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SUBCLASS;
                break;
            }
            case PACKAGE: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE;
                break;
            }
            case SAMENEST: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_NEST;
                break;
            }
            case SAMECLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_CLASS;
                break;
            }
            case NEVER: {
                this.compilationState = CompilationState.PROCESSED_NOT_INLINING_CANDIDATE;
            }
        }
        return prevCompilationState != this.compilationState;
    }

    public void markNotProcessed() {
        this.checkIfObsolete();
        this.compilationState = CompilationState.NOT_PROCESSED;
    }

    public IRCode buildIR(AppView<?> appView, Origin origin) {
        this.checkIfObsolete();
        return this.code == null ? null : this.code.buildIR(this, appView, origin);
    }

    public IRCode buildInliningIR(DexEncodedMethod context, AppView<?> appView, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        this.checkIfObsolete();
        return this.code.buildInliningIR(context, this, appView, valueNumberGenerator, callerPosition, origin);
    }

    public void setCode(Code newCode, AppView<?> appView) {
        this.checkIfObsolete();
        if (this.code != null && this.code.isCfCode() && !this.hasParameterInfo() && !this.keepLocals(appView.options())) {
            this.setParameterInfo(this.code.collectParameterInfo(this, appView));
        }
        this.code = newCode;
    }

    public void setCode(IRCode ir, RegisterAllocator registerAllocator, AppView<?> appView) {
        this.checkIfObsolete();
        DexBuilder builder = new DexBuilder(ir, registerAllocator);
        this.setCode(builder.build(), appView);
    }

    public boolean keepLocals(InternalOptions options) {
        if (options.testing.noLocalsTableOnInput) {
            return false;
        }
        return options.debug || this.getOptimizationInfo().isReachabilitySensitive();
    }

    private void setParameterInfo(Int2ReferenceMap<DebugLocalInfo> parameterInfo) {
        assert (this.parameterInfo == NO_PARAMETER_INFO);
        this.parameterInfo = parameterInfo;
    }

    public boolean hasParameterInfo() {
        return this.parameterInfo != NO_PARAMETER_INFO;
    }

    public Map<Integer, DebugLocalInfo> getParameterInfo() {
        return this.parameterInfo;
    }

    public String toString() {
        this.checkIfObsolete();
        return "Encoded method " + this.method;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.checkIfObsolete();
        this.method.collectIndexedItems(indexedItems);
        if (this.code != null) {
            this.code.collectIndexedItems(indexedItems, this.method);
        }
        this.annotations.collectIndexedItems(indexedItems);
        this.parameterAnnotationsList.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.visit(this);
    }

    public void collectMixedSectionItemsWithCodeMapping(MixedSectionCollection mixedItems, MethodToCodeObjectMapping mapping) {
        DexCode code = mapping.getCode(this);
        if (code != null) {
            code.collectMixedSectionItems(mixedItems);
        }
        this.annotations.collectMixedSectionItems(mixedItems);
        this.parameterAnnotationsList.collectMixedSectionItems(mixedItems);
    }

    public boolean shouldNotHaveCode() {
        return this.accessFlags.isAbstract() || this.accessFlags.isNative();
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public Code getCode() {
        this.checkIfObsolete();
        return this.code;
    }

    public void removeCode() {
        this.checkIfObsolete();
        this.code = null;
    }

    public int getClassFileVersion() {
        this.checkIfObsolete();
        assert (this.classFileVersion >= 0);
        return this.classFileVersion;
    }

    public boolean hasClassFileVersion() {
        this.checkIfObsolete();
        return this.classFileVersion >= 0;
    }

    public void upgradeClassFileVersion(int version) {
        this.checkIfObsolete();
        assert (version >= 0);
        assert (!this.hasClassFileVersion() || version >= this.getClassFileVersion());
        this.classFileVersion = version;
    }

    public String qualifiedName() {
        this.checkIfObsolete();
        return this.method.qualifiedName();
    }

    public String descriptor() {
        this.checkIfObsolete();
        return this.descriptor(NamingLens.getIdentityLens());
    }

    public String descriptor(NamingLens namingLens) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (DexType type : this.method.proto.parameters.values) {
            builder.append(namingLens.lookupDescriptor(type).toString());
        }
        builder.append(")");
        builder.append(namingLens.lookupDescriptor(this.method.proto.returnType).toString());
        return builder.toString();
    }

    public String toSmaliString(ClassNameMapper naming) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append(".method ");
        builder.append(this.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(this.method.name.toSmaliString());
        builder.append(this.method.proto.toSmaliString());
        builder.append("\n");
        if (this.code != null) {
            DexCode dexCode = this.code.asDexCode();
            builder.append("    .registers ");
            builder.append(dexCode.registerSize);
            builder.append("\n\n");
            builder.append(dexCode.toSmaliString(naming));
        }
        builder.append(".end method\n");
        return builder.toString();
    }

    @Override
    public String toSourceString() {
        this.checkIfObsolete();
        return this.method.toSourceString();
    }

    public DexEncodedMethod toAbstractMethod() {
        this.checkIfObsolete();
        assert (!this.accessFlags.isFinal());
        assert (!this.accessFlags.isStatic());
        this.accessFlags.setAbstract();
        this.code = null;
        return this;
    }

    private DexCode generateCodeFromTemplate(int numberOfRegisters, int outRegisters, Instruction ... instructions) {
        int offset = 0;
        for (Instruction instruction : instructions) {
            instruction.setOffset(offset);
            offset += instruction.getSize();
        }
        int requiredArgRegisters = this.accessFlags.isStatic() ? 0 : 1;
        for (DexType type : this.method.proto.parameters.values) {
            requiredArgRegisters += ValueType.fromDexType(type).requiredRegisters();
        }
        return new DexCode(Math.max(numberOfRegisters, requiredArgRegisters), requiredArgRegisters, outRegisters, instructions, new DexCode.Try[0], new DexCode.TryHandler[0], null);
    }

    public DexCode buildEmptyThrowingDexCode() {
        Instruction[] insn = new Instruction[]{new Const(0, 0), new Throw(0)};
        return this.generateCodeFromTemplate(1, 0, insn);
    }

    public DexEncodedMethod toEmptyThrowingMethod(InternalOptions options) {
        return options.isGeneratingClassFiles() ? this.toEmptyThrowingMethodCf() : this.toEmptyThrowingMethodDex();
    }

    public DexEncodedMethod toEmptyThrowingMethodDex() {
        this.checkIfObsolete();
        assert (!this.shouldNotHaveCode());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(this.buildEmptyThrowingDexCode());
        return builder.build();
    }

    public CfCode buildEmptyThrowingCfCode() {
        CfInstruction[] insn = new CfInstruction[]{new CfConstNull(), new CfThrow()};
        return new CfCode(this.method.holder, 1, this.method.proto.parameters.size() + 1, Arrays.asList(insn), Collections.emptyList(), Collections.emptyList());
    }

    public DexEncodedMethod toEmptyThrowingMethodCf() {
        this.checkIfObsolete();
        assert (!this.shouldNotHaveCode());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(this.buildEmptyThrowingCfCode());
        return builder.build();
    }

    public DexEncodedMethod toMethodThatLogsError(AppView<?> appView) {
        if (appView.options().isGeneratingDex()) {
            return this.toMethodThatLogsErrorDexCode(appView.dexItemFactory());
        }
        return this.toMethodThatLogsErrorCfCode(appView.dexItemFactory());
    }

    public static void setDebugInfoWithFakeThisParameter(Code code, int arity, AppView<?> appView) {
        if (code.isDexCode()) {
            DexCode dexCode = code.asDexCode();
            dexCode.setDebugInfo(dexCode.debugInfoWithFakeThisParameter(appView.dexItemFactory()));
            assert (dexCode.getDebugInfo() == null || arity == dexCode.getDebugInfo().parameters.length);
        } else {
            assert (appView.options().isDesugaredLibraryCompilation() || appView.options().enableCfInterfaceMethodDesugaring);
            assert (code.isCfCode());
            CfCode cfCode = code.asCfCode();
            cfCode.addFakeThisParameter(appView.dexItemFactory());
        }
    }

    private DexEncodedMethod toMethodThatLogsErrorDexCode(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString(CONFIGURATION_DEBUGGING_PREFIX + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("[R8]");
        DexType[] args = new DexType[]{itemFactory.stringType, itemFactory.stringType};
        DexProto proto = itemFactory.createProto(itemFactory.intType, args);
        DexMethod logMethod = itemFactory.createMethod(itemFactory.createType("Landroid/util/Log;"), proto, itemFactory.createString("e"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        DexCode code = this.generateCodeFromTemplate(2, 2, new ConstString(0, tag), new ConstString(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0));
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        this.setObsolete();
        return builder.build();
    }

    private DexEncodedMethod toMethodThatLogsErrorCfCode(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString(CONFIGURATION_DEBUGGING_PREFIX + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("[R8]");
        DexType logger = itemFactory.createType("Ljava/util/logging/Logger;");
        DexMethod getLogger = itemFactory.createMethod(logger, itemFactory.createProto(logger, itemFactory.stringType), itemFactory.createString("getLogger"));
        DexMethod severe = itemFactory.createMethod(logger, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.createString("severe"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        int locals = this.method.proto.parameters.size() + 1;
        if (!this.isStaticMember()) {
            ++locals;
        }
        ImmutableList.Builder instructionBuilder = ImmutableList.builder();
        ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)instructionBuilder.add(new CfConstString(tag))).add(new CfInvoke(184, getLogger, false))).add(new CfStore(ValueType.OBJECT, locals - 1))).add(new CfLoad(ValueType.OBJECT, locals - 1))).add(new CfConstString(message))).add(new CfInvoke(182, severe, false))).add(new CfNew(exceptionType))).add(new CfStackInstruction(CfStackInstruction.Opcode.Dup))).add(new CfConstString(message))).add(new CfInvoke(183, exceptionInitMethod, false))).add(new CfThrow());
        CfCode code = new CfCode(this.method.holder, 3, locals, (List<CfInstruction>)((Object)instructionBuilder.build()), Collections.emptyList(), Collections.emptyList());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        this.setObsolete();
        return builder.build();
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method) {
        this.checkIfObsolete();
        return this.toTypeSubstitutedMethod(method, null);
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method, Consumer<Builder> consumer) {
        this.checkIfObsolete();
        if (this.method == method) {
            return this;
        }
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(method);
        if (consumer != null) {
            consumer.accept(builder);
        }
        return builder.build();
    }

    public DexEncodedMethod toInitializerForwardingBridge(DexClass holder, DexMethod newMethod) {
        assert (this.accessFlags.isPrivate()) : "Expected to create bridge for private constructor as part of nest-based access desugaring";
        Builder builder = DexEncodedMethod.syntheticBuilder(this);
        builder.setMethod(newMethod);
        ForwardMethodSourceCode.Builder forwardSourceCodeBuilder = ForwardMethodSourceCode.builder(newMethod);
        forwardSourceCodeBuilder.setReceiver(holder.type).setTargetReceiver(holder.type).setTarget(this.method).setInvokeType(Invoke.Type.DIRECT).setExtraNullParameter();
        builder.setCode(new SynthesizedCode(forwardSourceCodeBuilder::build, registry -> registry.registerInvokeDirect(this.method)));
        assert (!builder.accessFlags.isStatic());
        assert (!holder.isInterface());
        builder.accessFlags.unsetPrivate();
        builder.accessFlags.setSynthetic();
        builder.accessFlags.setConstructor();
        return builder.build();
    }

    public static DexEncodedMethod createFieldAccessorBridge(NestBasedAccessDesugaring.DexFieldWithAccess fieldWithAccess, DexClass holder, DexMethod newMethod) {
        assert (holder.type == fieldWithAccess.getHolder());
        MethodAccessFlags accessFlags = MethodAccessFlags.fromSharedAccessFlags(0x1008 | (holder.isInterface() ? 1 : 0), false);
        SynthesizedCode code = new SynthesizedCode(callerPosition -> new FieldAccessorSourceCode(null, newMethod, callerPosition, newMethod, fieldWithAccess), registry -> {
            if (fieldWithAccess.isInstanceGet()) {
                registry.registerInstanceFieldRead(fieldWithAccess.getField());
            } else if (fieldWithAccess.isStaticGet()) {
                registry.registerStaticFieldRead(fieldWithAccess.getField());
            } else if (fieldWithAccess.isInstancePut()) {
                registry.registerInstanceFieldWrite(fieldWithAccess.getField());
            } else {
                assert (fieldWithAccess.isStaticPut());
                registry.registerStaticFieldWrite(fieldWithAccess.getField());
            }
        });
        return new DexEncodedMethod(newMethod, accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)code, true);
    }

    public DexEncodedMethod toRenamedHolderMethod(DexType newHolderType, DexItemFactory factory) {
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(factory.createMethod(newHolderType, this.method.proto, this.method.name));
        return builder.build();
    }

    public static DexEncodedMethod toEmulateDispatchLibraryMethod(DexType interfaceType, DexMethod newMethod, DexMethod companionMethod, DexMethod libraryMethod, List<Pair<DexType, DexMethod>> extraDispatchCases, AppView<?> appView) {
        MethodAccessFlags accessFlags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
        CfCode code = new EmulateInterfaceSyntheticCfCodeProvider(interfaceType, companionMethod, libraryMethod, extraDispatchCases, appView).generateCfCode();
        return new DexEncodedMethod(newMethod, accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)code, true);
    }

    public DexEncodedMethod toStaticForwardingBridge(DexClass holder, DexMethod newMethod) {
        assert (this.accessFlags.isPrivate()) : "Expected to create bridge for private method as part of nest-based access desugaring";
        Builder builder = DexEncodedMethod.syntheticBuilder(this);
        builder.setMethod(newMethod);
        ForwardMethodSourceCode.Builder forwardSourceCodeBuilder = ForwardMethodSourceCode.builder(newMethod);
        forwardSourceCodeBuilder.setTargetReceiver(this.accessFlags.isStatic() ? null : this.method.holder).setTarget(this.method).setInvokeType(this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.DIRECT).setIsInterface(holder.isInterface());
        builder.setCode(new SynthesizedCode(forwardSourceCodeBuilder::build, registry -> {
            if (this.accessFlags.isStatic()) {
                registry.registerInvokeStatic(this.method);
            } else {
                registry.registerInvokeDirect(this.method);
            }
        }));
        builder.accessFlags.setSynthetic();
        builder.accessFlags.setStatic();
        builder.accessFlags.unsetPrivate();
        if (holder.isInterface()) {
            builder.accessFlags.setPublic();
        }
        return builder.build();
    }

    public DexEncodedMethod toForwardingMethod(DexClass holder, DexDefinitionSupplier definitions) {
        this.checkIfObsolete();
        this.accessFlags.demoteFromFinal();
        DexMethod newMethod = definitions.dexItemFactory().createMethod(holder.type, this.method.proto, this.method.name);
        Invoke.Type type = this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.SUPER;
        Builder builder = DexEncodedMethod.syntheticBuilder(this);
        builder.setMethod(newMethod);
        if (this.accessFlags.isAbstract()) {
            builder.accessFlags.setAbstract();
        } else {
            DexClass target = definitions.definitionFor(this.method.holder);
            ForwardMethodSourceCode.Builder forwardSourceCodeBuilder = ForwardMethodSourceCode.builder(newMethod);
            forwardSourceCodeBuilder.setReceiver(this.accessFlags.isStatic() ? null : holder.type).setTargetReceiver(this.accessFlags.isStatic() ? null : this.method.holder).setTarget(this.method).setInvokeType(type).setIsInterface(target.isInterface());
            builder.setCode(new SynthesizedCode(forwardSourceCodeBuilder::build, registry -> {
                if (this.accessFlags.isStatic()) {
                    registry.registerInvokeStatic(this.method);
                } else {
                    registry.registerInvokeSuper(this.method);
                }
            }));
            builder.accessFlags.setBridge();
        }
        builder.accessFlags.setSynthetic();
        return builder.build();
    }

    public static DexEncodedMethod createDesugaringForwardingMethod(DexEncodedMethod target, DexClass clazz, DexMethod forwardMethod, DexItemFactory factory) {
        DexMethod method = target.method;
        assert (forwardMethod != null);
        DexMethod newMethod = factory.createMethod(clazz.type, method.proto, method.name);
        MethodAccessFlags newFlags = target.accessFlags.copy();
        newFlags.setSynthetic();
        ForwardMethodSourceCode.Builder forwardSourceCodeBuilder = ForwardMethodSourceCode.builder(newMethod);
        forwardSourceCodeBuilder.setReceiver(clazz.type).setTarget(forwardMethod).setInvokeType(Invoke.Type.STATIC).setIsInterface(false);
        return new DexEncodedMethod(newMethod, newFlags, target.annotations, target.parameterAnnotationsList, (Code)new SynthesizedCode(forwardSourceCodeBuilder::build), true);
    }

    public DexEncodedMethod toStaticMethodWithoutThis() {
        this.checkIfObsolete();
        assert (!this.accessFlags.isStatic());
        Builder builder = DexEncodedMethod.builder(this).promoteToStatic().withoutThisParameter().adjustOptimizationInfoAfterRemovingThisParameter();
        DexEncodedMethod method = builder.build();
        method.copyMetadata(this);
        this.setObsolete();
        return method;
    }

    public DexCode rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, DexItemFactory factory, boolean force) {
        this.checkIfObsolete();
        assert (this.code == null || this.code.isDexCode());
        if (this.code == null) {
            return null;
        }
        DexCode code = this.code.asDexCode();
        DexString firstJumboString = null;
        if (force) {
            firstJumboString = mapping.getFirstString();
        } else {
            assert (code.highestSortingString != null || Arrays.stream(code.instructions).noneMatch(Instruction::isConstString));
            assert (Arrays.stream(code.instructions).noneMatch(Instruction::isDexItemBasedConstString));
            if (code.highestSortingString != null && mapping.getOffsetFor(code.highestSortingString) > 65535) {
                firstJumboString = mapping.getFirstJumboString();
            }
        }
        if (firstJumboString != null) {
            JumboStringRewriter rewriter = new JumboStringRewriter(this, firstJumboString, factory);
            return rewriter.rewrite();
        }
        return code;
    }

    public String codeToString() {
        this.checkIfObsolete();
        return this.code == null ? "<no code>" : this.code.toString(this, null);
    }

    @Override
    public DexMethod getKey() {
        return this.method;
    }

    @Override
    public DexReference toReference() {
        this.checkIfObsolete();
        return this.method;
    }

    @Override
    public boolean isDexEncodedMethod() {
        this.checkIfObsolete();
        return true;
    }

    @Override
    public DexEncodedMethod asDexEncodedMethod() {
        this.checkIfObsolete();
        return this;
    }

    public boolean hasAnnotation() {
        this.checkIfObsolete();
        return !this.annotations.isEmpty() || !this.parameterAnnotationsList.isEmpty();
    }

    public void registerCodeReferences(UseRegistry registry) {
        this.checkIfObsolete();
        if (this.code != null) {
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Registering definitions reachable from `%s`.", this.method);
            }
            this.code.registerCodeReferences(this, registry);
        }
    }

    public static int slowCompare(DexEncodedMethod m1, DexEncodedMethod m2) {
        return m1.method.slowCompareTo(m2.method);
    }

    public MethodOptimizationInfo getOptimizationInfo() {
        this.checkIfObsolete();
        return this.optimizationInfo;
    }

    public synchronized UpdatableMethodOptimizationInfo getMutableOptimizationInfo() {
        this.checkIfObsolete();
        if (this.optimizationInfo == DefaultMethodOptimizationInfo.DEFAULT_INSTANCE) {
            this.optimizationInfo = this.optimizationInfo.mutableCopy();
        }
        return (UpdatableMethodOptimizationInfo)this.optimizationInfo;
    }

    public void setOptimizationInfo(UpdatableMethodOptimizationInfo info) {
        this.checkIfObsolete();
        this.optimizationInfo = info;
    }

    public synchronized CallSiteOptimizationInfo getCallSiteOptimizationInfo() {
        this.checkIfObsolete();
        return this.callSiteOptimizationInfo;
    }

    public synchronized void joinCallSiteOptimizationInfo(CallSiteOptimizationInfo other, AppView<?> appView) {
        this.checkIfObsolete();
        this.callSiteOptimizationInfo = this.callSiteOptimizationInfo.join(other, appView, this);
    }

    public void copyMetadata(DexEncodedMethod from) {
        this.checkIfObsolete();
        if (from.classFileVersion > this.classFileVersion) {
            this.upgradeClassFileVersion(from.getClassFileVersion());
        }
    }

    public void copyMetadata(DexEncodedMethod from, OptimizationFeedback feedback) {
        if (from.getOptimizationInfo().useIdentifierNameString()) {
            feedback.markUseIdentifierNameString(this);
        }
        this.copyMetadata(from);
    }

    private static Builder syntheticBuilder(DexEncodedMethod from) {
        return new Builder(from, true);
    }

    private static Builder builder(DexEncodedMethod from) {
        return new Builder(from);
    }

    public static class Builder {
        private DexMethod method;
        private final MethodAccessFlags accessFlags;
        private final DexAnnotationSet annotations;
        private ParameterAnnotationsList parameterAnnotations;
        private Code code;
        private CompilationState compilationState;
        private MethodOptimizationInfo optimizationInfo;
        private final int classFileVersion;
        private boolean d8R8Synthesized;

        private Builder(DexEncodedMethod from) {
            this(from, from.d8R8Synthesized);
        }

        private Builder(DexEncodedMethod from, boolean d8R8Synthesized) {
            this.method = from.method;
            this.accessFlags = from.accessFlags.copy();
            this.annotations = from.annotations;
            this.code = from.code;
            this.compilationState = from.compilationState;
            this.optimizationInfo = from.optimizationInfo.mutableCopy();
            this.classFileVersion = from.classFileVersion;
            this.d8R8Synthesized = d8R8Synthesized;
            this.parameterAnnotations = from.parameterAnnotationsList.isEmpty() || from.parameterAnnotationsList.size() == this.method.proto.parameters.size() ? from.parameterAnnotationsList : from.parameterAnnotationsList.withParameterCount(this.method.proto.parameters.size());
        }

        public void setMethod(DexMethod method) {
            this.method = method;
        }

        public Builder setParameterAnnotations(ParameterAnnotationsList parameterAnnotations) {
            this.parameterAnnotations = parameterAnnotations;
            return this;
        }

        public Builder removeParameterAnnotations(IntPredicate predicate) {
            if (this.parameterAnnotations.isEmpty()) {
                return this;
            }
            ArrayList<DexAnnotationSet> newParameterAnnotations = new ArrayList<DexAnnotationSet>();
            int newNumberOfMissingParameterAnnotations = 0;
            for (int oldIndex = 0; oldIndex < this.parameterAnnotations.size(); ++oldIndex) {
                if (predicate.test(oldIndex)) continue;
                if (this.parameterAnnotations.isMissing(oldIndex)) {
                    ++newNumberOfMissingParameterAnnotations;
                    continue;
                }
                newParameterAnnotations.add(this.parameterAnnotations.get(oldIndex));
            }
            if (newParameterAnnotations.isEmpty()) {
                return this.setParameterAnnotations(ParameterAnnotationsList.empty());
            }
            return this.setParameterAnnotations(new ParameterAnnotationsList(newParameterAnnotations.toArray(DexAnnotationSet.EMPTY_ARRAY), newNumberOfMissingParameterAnnotations));
        }

        public Builder promoteToStatic() {
            this.accessFlags.promoteToStatic();
            return this;
        }

        public Builder withoutThisParameter() {
            assert (this.code != null);
            if (!this.code.isDexCode()) {
                throw new Unreachable("Code " + this.code.getClass().getSimpleName() + " is not supported.");
            }
            this.code = this.code.asDexCode().withoutThisParameter();
            return this;
        }

        public Builder adjustOptimizationInfoAfterRemovingThisParameter() {
            if (this.optimizationInfo.isUpdatableMethodOptimizationInfo()) {
                this.optimizationInfo.asUpdatableMethodOptimizationInfo().adjustOptimizationInfoAfterRemovingThisParameter();
            }
            return this;
        }

        public void setCode(Code code) {
            this.code = code;
        }

        public DexEncodedMethod build() {
            assert (this.method != null);
            assert (this.accessFlags != null);
            assert (this.annotations != null);
            assert (this.parameterAnnotations != null);
            assert (this.parameterAnnotations.isEmpty() || this.parameterAnnotations.size() == this.method.proto.parameters.size());
            DexEncodedMethod result = new DexEncodedMethod(this.method, this.accessFlags, this.annotations, this.parameterAnnotations, this.code, this.classFileVersion, this.d8R8Synthesized);
            result.compilationState = this.compilationState;
            result.optimizationInfo = this.optimizationInfo;
            return result;
        }
    }

    public static enum CompilationState {
        NOT_PROCESSED,
        PROCESSED_NOT_INLINING_CANDIDATE,
        PROCESSED_INLINING_CANDIDATE_ANY,
        PROCESSED_INLINING_CANDIDATE_SUBCLASS,
        PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE,
        PROCESSED_INLINING_CANDIDATE_SAME_NEST,
        PROCESSED_INLINING_CANDIDATE_SAME_CLASS;

    }
}

