/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto;

import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;

public class ProtoInliningReasonStrategy
implements InliningReasonStrategy {
    private static final int METHOD_TO_INVOKE_ARGUMENT_POSITION_IN_DYNAMIC_METHOD = 1;
    private final InliningReasonStrategy parent;
    private final ProtoReferences references;

    public ProtoInliningReasonStrategy(AppView<?> appView, InliningReasonStrategy parent) {
        this.parent = parent;
        this.references = appView.protoShrinker().references;
    }

    @Override
    public Inliner.Reason computeInliningReason(InvokeMethod invoke, DexEncodedMethod target) {
        return this.references.isDynamicMethod(target) ? this.computeInliningReasonForDynamicMethod(invoke) : this.parent.computeInliningReason(invoke, target);
    }

    private Inliner.Reason computeInliningReasonForDynamicMethod(InvokeMethod invoke) {
        Value methodToInvokeValue = invoke.inValues().get(1).getAliasedValue();
        if (methodToInvokeValue.isPhi()) {
            return Inliner.Reason.NEVER;
        }
        Instruction methodToInvokeDefinition = methodToInvokeValue.definition;
        if (!methodToInvokeDefinition.isStaticGet()) {
            return Inliner.Reason.NEVER;
        }
        ProtoReferences.MethodToInvokeMembers methodToInvokeMembers = this.references.methodToInvokeMembers;
        DexField field = methodToInvokeDefinition.asStaticGet().getField();
        if (methodToInvokeMembers.isMethodToInvokeWithSimpleBody(field)) {
            return Inliner.Reason.ALWAYS;
        }
        assert (field.holder != this.references.methodToInvokeType || methodToInvokeMembers.isMethodToInvokeWithNonSimpleBody(field));
        return Inliner.Reason.NEVER;
    }
}

