/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema;

import java.util.List;
import java.util.OptionalInt;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldTypeFactory;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;

public class ProtoFieldInfo {
    private final int number;
    private final ProtoFieldType type;
    private OptionalInt auxData;
    private final List<ProtoObject> objects;

    public ProtoFieldInfo(int number, ProtoFieldType type, OptionalInt auxData, List<ProtoObject> objects) {
        this.number = number;
        this.type = type;
        this.auxData = auxData;
        this.objects = objects;
    }

    public boolean hasAuxData() {
        return this.auxData.isPresent();
    }

    public int getAuxData() {
        assert (this.hasAuxData());
        return this.auxData.getAsInt();
    }

    void setAuxData(int value) {
        assert (this.hasAuxData());
        this.auxData = OptionalInt.of(value);
    }

    public int getNumber() {
        return this.number;
    }

    public List<ProtoObject> getObjects() {
        return this.objects;
    }

    public ProtoFieldType getType() {
        return this.type;
    }

    public DexType getBaseMessageType(ProtoFieldTypeFactory factory) {
        if (this.type.isOneOf()) {
            ProtoFieldType actualFieldType = this.type.asOneOf().getActualFieldType(factory);
            if (actualFieldType.isGroup() || actualFieldType.isMessage()) {
                ProtoObject object = this.objects.get(0);
                assert (object.isProtoTypeObject());
                return object.asProtoTypeObject().getType();
            }
            return null;
        }
        if (this.type.isMessage() || this.type.isGroup()) {
            ProtoObject object = this.objects.get(0);
            assert (object.isLiveProtoFieldObject());
            return object.asLiveProtoFieldObject().getField().type;
        }
        if (this.type.isMessageList() || this.type.isGroupList()) {
            ProtoObject object = this.objects.get(1);
            assert (object.isProtoTypeObject());
            return object.asProtoTypeObject().getType();
        }
        return null;
    }

    public boolean hasHazzerBitField(ProtoMessageInfo protoMessageInfo) {
        return protoMessageInfo.isProto2() && this.type.isSingular();
    }

    public DexEncodedField getHazzerBitField(AppView<?> appView, ProtoMessageInfo protoMessageInfo) {
        assert (this.hasHazzerBitField(protoMessageInfo));
        int hasBitsIndex = this.getAuxData() / 32;
        assert (hasBitsIndex < protoMessageInfo.numberOfHasBitsObjects());
        ProtoObject object = protoMessageInfo.getHasBitsObjects().get(hasBitsIndex);
        assert (object.isLiveProtoFieldObject());
        return ((AppInfo)appView.appInfo()).resolveField(object.asLiveProtoFieldObject().getField());
    }

    public int getHazzerBitFieldIndex(ProtoMessageInfo protoMessageInfo) {
        assert (this.hasHazzerBitField(protoMessageInfo));
        return this.getAuxData() % 32 + 1;
    }

    public DexEncodedField getOneOfCaseField(AppView<?> appView, ProtoMessageInfo protoMessageInfo) {
        assert (this.type.isOneOf());
        ProtoFieldObject object = protoMessageInfo.getOneOfObjects().get(this.getAuxData()).getOneOfCaseObject();
        assert (object.isLiveProtoFieldObject());
        return ((AppInfo)appView.appInfo()).resolveField(object.asLiveProtoFieldObject().getField());
    }

    public DexEncodedField getValueStorage(AppView<?> appView, ProtoMessageInfo protoMessageInfo) {
        ProtoObject object;
        ProtoObject protoObject = object = this.type.isOneOf() ? protoMessageInfo.getOneOfObjects().get(this.getAuxData()).getOneOfObject() : this.objects.get(0);
        assert (object.isLiveProtoFieldObject());
        return ((AppInfo)appView.appInfo()).resolveField(object.asLiveProtoFieldObject().getField());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProtoFieldInfo(number=").append(this.number).append(", type=").append(this.type).append(", aux data=").append(this.auxData).append(", objects=[");
        if (this.objects.size() > 0) {
            builder.append(this.objects.get(0));
            for (int i = 1; i < this.objects.size(); ++i) {
                builder.append(", ").append(this.objects.get(i));
            }
        }
        return builder.append("])").toString();
    }
}

