/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.value;

import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleValue;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class SingleNumberValue
extends SingleValue {
    private final long value;

    SingleNumberValue(long value) {
        this.value = value;
    }

    @Override
    public boolean isSingleNumberValue() {
        return true;
    }

    @Override
    public SingleNumberValue asSingleNumberValue() {
        return this;
    }

    public boolean getBooleanValue() {
        assert (this.value == 0L || this.value == 1L);
        return this.value != 0L;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return "SingleNumberValue(" + this.value + ")";
    }

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithSubtyping> appView, IRCode code, TypeAndLocalInfoSupplier info) {
        TypeLatticeElement typeLattice = info.getTypeLattice();
        DebugLocalInfo debugLocalInfo = info.getLocalInfo();
        assert (!typeLattice.isReference() || this.value == 0L);
        Value returnedValue = code.createValue(typeLattice.isReference() ? TypeLatticeElement.NULL : typeLattice, debugLocalInfo);
        return new ConstNumber(returnedValue, this.value);
    }

    @Override
    public boolean isMaterializableInContext(AppView<?> appView, DexType context) {
        return true;
    }
}

