/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;

public class CanonicalPositions {
    private final Position callerPosition;
    private final Map<Position, Position> canonicalPositions;
    private final Position preamblePosition;
    private Position syntheticPosition;

    public CanonicalPositions(Position callerPosition, int expectedPositionsCount, DexMethod method) {
        this.canonicalPositions = new HashMap<Position, Position>(1 + (callerPosition == null ? 0 : 1) + expectedPositionsCount);
        this.callerPosition = callerPosition;
        if (callerPosition != null) {
            this.canonicalPositions.put(callerPosition, callerPosition);
        }
        this.preamblePosition = callerPosition == null ? Position.synthetic(0, method, null) : new Position(0, null, method, callerPosition);
        this.canonicalPositions.put(this.preamblePosition, this.preamblePosition);
    }

    public Position getPreamblePosition() {
        return this.preamblePosition;
    }

    public Position getCanonical(Position position) {
        Position canonical = this.canonicalPositions.putIfAbsent(position, position);
        return canonical != null ? canonical : position;
    }

    public Position canonicalizeCallerPosition(Position caller) {
        if (caller == null) {
            return this.callerPosition;
        }
        if (caller.callerPosition == null && this.callerPosition == null) {
            return this.getCanonical(caller);
        }
        Position callerOfCaller = this.canonicalizeCallerPosition(caller.callerPosition);
        return this.getCanonical(caller.isNone() ? Position.noneWithMethod(caller.method, callerOfCaller) : new Position(caller.line, caller.file, caller.method, callerOfCaller));
    }

    public Position getExceptionalExitPosition(boolean debug, Supplier<Iterable<Position>> positions, DexMethod originalMethod) {
        if (this.syntheticPosition == null) {
            if (debug) {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                for (Position position : positions.get()) {
                    assert (position == position.getOutermostCaller());
                    int line = position.line;
                    min = Math.min(min, line);
                    max = Math.max(max, line);
                }
                this.syntheticPosition = min == Integer.MAX_VALUE ? this.getPreamblePosition() : Position.synthetic(min < max ? min - 1 : min, originalMethod, this.callerPosition);
            } else {
                this.syntheticPosition = Position.syntheticNone();
            }
        }
        return this.syntheticPosition;
    }
}

