/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvoke;
import shadow.bundletool.com.android.tools.r8.code.Base3Format;
import shadow.bundletool.com.android.tools.r8.code.InvokeDirectRange;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.modeling.LibraryMethodReadSetModeling;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class InvokeDirect
extends InvokeMethodWithReceiver {
    private final boolean itf;

    public InvokeDirect(DexMethod target, Value result, List<Value> arguments) {
        this(target, result, arguments, false);
    }

    public InvokeDirect(DexMethod target, Value result, List<Value> arguments, boolean itf) {
        super(target, result, arguments);
        this.itf = itf;
        assert (!target.name.toString().equals("<init>") || result == null);
    }

    @Override
    public int opcode() {
        return 32;
    }

    public boolean isInterface() {
        return this.itf;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.DIRECT;
    }

    @Override
    protected String getTypeString() {
        return "Direct";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeDirectRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new shadow.bundletool.com.android.tools.r8.code.InvokeDirect(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    public boolean sameConstructorReceiverValue(Invoke other) {
        if (!this.getInvokedMethod().name.toString().equals("<init>")) {
            return true;
        }
        return this.inValues.get(0) == other.inValues.get(0);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeDirect() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeDirect() {
        return true;
    }

    @Override
    public InvokeDirect asInvokeDirect() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(AppView<?> appView, DexType invocationContext) {
        DexMethod invokedMethod = this.getInvokedMethod();
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppInfoWithLiveness appInfo = ((AppInfo)appView.appInfo()).withLiveness();
            return appInfo.lookupDirectTarget(invokedMethod);
        }
        if (invokedMethod.holder == invocationContext) {
            DexClass clazz = appView.definitionFor(invokedMethod.holder);
            if (clazz != null && clazz.isProgramClass()) {
                DexEncodedMethod singleTarget = clazz.lookupDirectMethod(invokedMethod);
                if (!singleTarget.isStatic()) {
                    return singleTarget;
                }
            } else assert (false);
        }
        return null;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeDirect(this.getInvokedMethod(), invocationContext);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(183, this.getInvokedMethod(), this.itf));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeDirect(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (!appView.enableWholeProgramOptimizations()) {
            return true;
        }
        if (appView.options().debug) {
            return true;
        }
        Value receiver = this.getReceiver();
        if (receiver.getTypeLattice().isNullable()) {
            return true;
        }
        Predicate<InvokeMethod> noSideEffectsPredicate = appView.dexItemFactory().libraryMethodsWithoutSideEffects.get(this.getInvokedMethod());
        if (noSideEffectsPredicate != null && noSideEffectsPredicate.test(this)) {
            return false;
        }
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            InstanceInitializerInfo initializerInfo;
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            DexEncodedMethod target = this.lookupSingleTarget(appViewWithLiveness, context);
            if (target == null) {
                return true;
            }
            if (!MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appView, context, target.method.holder, target.accessFlags)) {
                return true;
            }
            DexClass clazz = appView.definitionFor(target.method.holder);
            if (clazz == null) {
                assert (false) : "Expected to be able to find the enclosing class of a method definition";
                return true;
            }
            if (appViewWithLiveness.appInfo().noSideEffects.containsKey(target.method)) {
                return false;
            }
            MethodOptimizationInfo optimizationInfo = target.getOptimizationInfo();
            if (target.isInstanceInitializer() && !(initializerInfo = optimizationInfo.getInstanceInitializerInfo()).mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
                return false;
            }
            return optimizationInfo.mayHaveSideEffects();
        }
        return true;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        DexEncodedMethod method = code.method;
        if (this.instructionMayHaveSideEffects(appView, method.method.holder)) {
            return false;
        }
        if (appView.dexItemFactory().isConstructor(this.getInvokedMethod())) {
            ArrayList<InvokeDirect> otherInitCalls = null;
            for (Instruction user : this.getReceiver().uniqueUsers()) {
                if (user == this || !user.isInvokeDirect()) continue;
                InvokeDirect invoke = user.asInvokeDirect();
                if (!appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()) || invoke.getReceiver() != this.getReceiver()) continue;
                if (invoke.instructionMayHaveSideEffects(appView, method.method.holder)) {
                    return false;
                }
                if (otherInitCalls == null) {
                    otherInitCalls = new ArrayList<InvokeDirect>();
                }
                otherInitCalls.add(invoke);
            }
            ArrayList<InvokeDirect> finalOtherInitCalls = otherInitCalls;
            Predicate<Instruction> ignoreConstructorCalls = instruction -> instruction == this || finalOtherInitCalls != null && finalOtherInitCalls.contains(instruction);
            if (!this.getReceiver().isDead(appView, code, ignoreConstructorCalls)) {
                return false;
            }
            if (this.getReceiver().getAliasedValue() == code.getThis()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public AbstractFieldSet readSet(AppView<?> appView, DexType context) {
        DexEncodedMethod singleTarget;
        DexMethod invokedMethod = this.getInvokedMethod();
        if (appView.dexItemFactory().isConstructor(invokedMethod) && (singleTarget = this.lookupSingleTarget(appView, context)) != null && singleTarget.isProgramMethod(appView)) {
            return singleTarget.getOptimizationInfo().getInstanceInitializerInfo().readSet();
        }
        return LibraryMethodReadSetModeling.getModeledReadSetOrUnknown(this, appView.dexItemFactory());
    }
}

