/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;

public interface CodeOptimization {
    public void optimize(IRCode var1, OptimizationFeedback var2, MethodProcessor var3);

    public static CodeOptimization from(Consumer<IRCode> consumer) {
        return (code, feedback, methodProcessor) -> consumer.accept(code);
    }

    public static CodeOptimization sequence(CodeOptimization ... codeOptimizations) {
        return CodeOptimization.sequence(Arrays.asList(codeOptimizations));
    }

    public static CodeOptimization sequence(Collection<CodeOptimization> codeOptimizations) {
        return (code, feedback, methodProcessor) -> {
            for (CodeOptimization codeOptimization : codeOptimizations) {
                codeOptimization.optimize(code, feedback, methodProcessor);
            }
        };
    }

    public static class Builder {
        private ImmutableList.Builder<CodeOptimization> processingQueue = ImmutableList.builder();

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder addIRCodeConsumer(Consumer<IRCode> consumer) {
            this.processingQueue.add((Object)CodeOptimization.from(consumer));
            return this;
        }

        public Builder addCodeOptimization(CodeOptimization optimization) {
            this.processingQueue.add((Object)optimization);
            return this;
        }

        public CodeOptimization build() {
            return (code, feedback, methodProcessor) -> ((ImmutableList)this.processingQueue.build()).forEach(codeOptimization -> codeOptimization.optimize(code, feedback, methodProcessor));
        }
    }
}

