/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraph;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallSiteInformation;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PostMethodProcessor;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.Action;
import shadow.bundletool.com.android.tools.r8.utils.IROrdering;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingConsumer;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

class PrimaryMethodProcessor
implements MethodProcessor {
    private final CallSiteInformation callSiteInformation;
    private final PostMethodProcessor.Builder postMethodProcessorBuilder;
    private final Deque<Collection<DexEncodedMethod>> waves;
    private Collection<DexEncodedMethod> wave;

    private PrimaryMethodProcessor(AppView<AppInfoWithLiveness> appView, PostMethodProcessor.Builder postMethodProcessorBuilder, CallGraph callGraph) {
        this.callSiteInformation = callGraph.createCallSiteInformation(appView);
        this.postMethodProcessorBuilder = postMethodProcessorBuilder;
        this.waves = this.createWaves(appView, callGraph, this.callSiteInformation);
    }

    static PrimaryMethodProcessor create(AppView<AppInfoWithLiveness> appView, PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        CallGraph callGraph = CallGraph.builder(appView).build(executorService, timing);
        return new PrimaryMethodProcessor(appView, postMethodProcessorBuilder, callGraph);
    }

    @Override
    public MethodProcessor.Phase getPhase() {
        return MethodProcessor.Phase.PRIMARY;
    }

    @Override
    public CallSiteInformation getCallSiteInformation() {
        return this.callSiteInformation;
    }

    private Deque<Collection<DexEncodedMethod>> createWaves(AppView<?> appView, CallGraph callGraph, CallSiteInformation callSiteInformation) {
        IROrdering shuffle = appView.options().testing.irOrdering;
        ArrayDeque<Collection<DexEncodedMethod>> waves = new ArrayDeque<Collection<DexEncodedMethod>>();
        Set<CallGraph.Node> nodes = callGraph.nodes;
        Set<DexEncodedMethod> reprocessing = Sets.newIdentityHashSet();
        int waveCount = 1;
        while (!nodes.isEmpty()) {
            Set<DexEncodedMethod> wave = Sets.newIdentityHashSet();
            PrimaryMethodProcessor.extractLeaves(nodes, leaf -> {
                wave.add(leaf.method);
                if (callSiteInformation.hasSingleCallSite(leaf.method.method)) {
                    callGraph.cycleEliminationResult.forEachRemovedCaller((CallGraph.Node)leaf, caller -> reprocessing.add(caller.method));
                }
            });
            waves.addLast(shuffle.order((Collection<DexEncodedMethod>)wave));
            if (!Log.ENABLED || !Log.isLoggingEnabledFor(PrimaryMethodProcessor.class)) continue;
            Log.info(this.getClass(), "Wave #%d: %d", waveCount++, wave.size());
        }
        if (!reprocessing.isEmpty()) {
            this.postMethodProcessorBuilder.put(reprocessing);
        }
        return waves;
    }

    static void extractLeaves(Set<CallGraph.Node> nodes, Consumer<CallGraph.Node> fn) {
        Set<CallGraph.Node> removed = Sets.newIdentityHashSet();
        Iterator<CallGraph.Node> nodeIterator = nodes.iterator();
        while (nodeIterator.hasNext()) {
            CallGraph.Node node = nodeIterator.next();
            if (!node.isLeaf()) continue;
            fn.accept(node);
            nodeIterator.remove();
            removed.add(node);
        }
        removed.forEach(CallGraph.Node::cleanCallersForRemoval);
    }

    @Override
    public boolean isProcessedConcurrently(DexEncodedMethod method) {
        return this.wave != null && this.wave.contains(method);
    }

    <E extends Exception> void forEachMethod(ThrowingConsumer<DexEncodedMethod, E> consumer, WaveStartAction waveStartAction, Action waveDone, ExecutorService executorService) throws ExecutionException {
        while (!this.waves.isEmpty()) {
            this.wave = this.waves.removeFirst();
            assert (this.wave.size() > 0);
            waveStartAction.notifyWaveStart(this.wave, executorService);
            ThreadUtils.processItems(this.wave, consumer, executorService);
            waveDone.execute();
        }
    }

    static interface WaveStartAction {
        public void notifyWaveStart(Collection<DexEncodedMethod> var1, ExecutorService var2) throws ExecutionException;
    }
}

