/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.StringSwitch;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierNameStringMarker;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class StringSwitchRemover {
    private final AppView<?> appView;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final ClassTypeLatticeElement stringType;
    private final BasicBlock.ThrowingInfo throwingInfo;

    StringSwitchRemover(AppView<?> appView, IdentifierNameStringMarker identifierNameStringMarker) {
        this.appView = appView;
        this.identifierNameStringMarker = identifierNameStringMarker;
        this.stringType = TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull());
        this.throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
    }

    void run(DexEncodedMethod method, IRCode code) {
        if (!code.metadata().mayHaveStringSwitch()) {
            assert (Streams.stream(code.instructions()).noneMatch(Instruction::isStringSwitch));
            return;
        }
        Set<BasicBlock> newBlocks = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            JumpInstruction exit = block.exit();
            if (!exit.isStringSwitch()) continue;
            this.removeStringSwitch(code, blockIterator, block, exit.asStringSwitch(), newBlocks);
        }
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInBlocks(method, code, newBlocks);
        }
        assert (code.isConsistentSSA());
    }

    private void removeStringSwitch(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block, StringSwitch theSwitch, Set<BasicBlock> newBlocks) {
        BasicBlock fallthroughBlock = theSwitch.fallthroughBlock();
        IdentityHashMap stringToTargetMap = new IdentityHashMap();
        theSwitch.forEachCase(stringToTargetMap::put);
        for (BasicBlock successor : block.getNormalSuccessors()) {
            successor.removePredecessor(block, null);
        }
        block.removeAllNormalSuccessors();
        Set<BasicBlock> blocksTargetedByMultipleSwitchCases = Sets.newIdentityHashSet();
        Set seenBefore = SetUtils.newIdentityHashSet(stringToTargetMap.size());
        for (BasicBlock basicBlock : stringToTargetMap.values()) {
            if (seenBefore.add(basicBlock)) continue;
            blocksTargetedByMultipleSwitchCases.add(basicBlock);
        }
        BasicBlock previous = null;
        for (Map.Entry entry : stringToTargetMap.entrySet()) {
            ConstString constStringInstruction = new ConstString(code.createValue(this.stringType), (DexString)entry.getKey(), this.throwingInfo);
            constStringInstruction.setPosition(Position.syntheticNone());
            InvokeVirtual invokeInstruction = new InvokeVirtual(this.appView.dexItemFactory().stringMethods.equals, code.createValue(PrimitiveTypeLatticeElement.INT), ImmutableList.of(theSwitch.value(), constStringInstruction.outValue()));
            invokeInstruction.setPosition(Position.syntheticNone());
            If ifInstruction = new If(If.Type.NE, invokeInstruction.outValue());
            ifInstruction.setPosition(Position.none());
            BasicBlock targetBlock = (BasicBlock)entry.getValue();
            if (blocksTargetedByMultipleSwitchCases.contains(targetBlock)) {
                BasicBlock intermediateBlock = BasicBlock.createGotoBlock(code.blocks.size(), Position.none(), code.metadata());
                intermediateBlock.link(targetBlock);
                blockIterator.add(intermediateBlock);
                newBlocks.add(intermediateBlock);
                targetBlock = intermediateBlock;
            }
            BasicBlock newBlock = BasicBlock.createIfBlock(code.blocks.size(), ifInstruction, code.metadata(), constStringInstruction, invokeInstruction);
            newBlock.link(targetBlock);
            blockIterator.add(newBlock);
            newBlocks.add(newBlock);
            if (previous == null) {
                block.exit().replace(new Goto(newBlock), code);
                block.link(newBlock);
            } else {
                previous.link(newBlock);
            }
            previous = newBlock;
        }
        assert (previous != null);
        previous.link(fallthroughBlock);
    }
}

