/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaClass;
import shadow.bundletool.com.android.tools.r8.ir.desugar.SynthesizedLambdaSourceCode;

final class AccessorMethodSourceCode
extends SynthesizedLambdaSourceCode {
    AccessorMethodSourceCode(LambdaClass lambda2, Position callerPosition) {
        super(lambda2, lambda2.target.callTarget, callerPosition, null);
        assert (!this.descriptor().implHandle.type.isInvokeInterface());
        assert (this.checkSignatures());
    }

    private boolean checkSignatures() {
        DexMethodHandle implHandle = this.descriptor().implHandle;
        assert (implHandle != null);
        DexType[] accessorParams = this.proto.parameters.values;
        DexMethod implMethod = implHandle.asMethod();
        DexProto implProto = implMethod.proto;
        DexType[] implParams = implProto.parameters.values;
        int index = 0;
        if (implHandle.type.isInvokeInstance() || implHandle.type.isInvokeDirect()) {
            assert (accessorParams[index] == this.descriptor().getImplReceiverType());
            ++index;
        }
        for (DexType implParam : implParams) {
            assert (accessorParams[index] == implParam);
            ++index;
        }
        assert (index == accessorParams.length);
        assert (!this.delegatingToConstructor() ? this.proto.returnType == implProto.returnType : this.proto.returnType == implMethod.holder);
        return true;
    }

    private boolean isPrivateMethod() {
        MethodAccessFlags flags = this.descriptor().getAccessibility();
        return flags != null && flags.isPrivate();
    }

    private boolean delegatingToConstructor() {
        return this.descriptor().implHandle.type.isInvokeConstructor();
    }

    private Invoke.Type inferInvokeType() {
        switch (this.descriptor().implHandle.type) {
            case INVOKE_INSTANCE: {
                return Invoke.Type.VIRTUAL;
            }
            case INVOKE_STATIC: {
                return Invoke.Type.STATIC;
            }
            case INVOKE_DIRECT: 
            case INVOKE_CONSTRUCTOR: {
                return Invoke.Type.DIRECT;
            }
            case INVOKE_INTERFACE: {
                throw new Unreachable("Accessor for an interface method?");
            }
        }
        throw new Unreachable();
    }

    @Override
    protected void prepareInstructions() {
        DexMethod implMethod = this.descriptor().implHandle.asMethod();
        DexType[] accessorParams = this.proto.parameters.values;
        ArrayList<ValueType> argValueTypes = new ArrayList<ValueType>();
        ArrayList<Integer> argRegisters = new ArrayList<Integer>();
        if (this.delegatingToConstructor()) {
            int instance = this.nextRegister(ValueType.OBJECT);
            this.add(builder -> builder.addNewInstance(instance, implMethod.holder));
            argValueTypes.add(ValueType.OBJECT);
            argRegisters.add(instance);
        }
        for (int i = 0; i < accessorParams.length; ++i) {
            DexType param = accessorParams[i];
            argValueTypes.add(ValueType.fromDexType(param));
            argRegisters.add(this.getParamRegister(i));
        }
        assert (!this.descriptor().implHandle.type.isInvokeInterface());
        this.add(builder -> builder.addInvoke(this.inferInvokeType(), implMethod, implMethod.proto, argValueTypes, argRegisters, false));
        if (this.proto.returnType == this.factory().voidType) {
            this.add(IRBuilder::addReturn);
        } else if (this.delegatingToConstructor()) {
            this.add(builder -> builder.addReturn((Integer)argRegisters.get(0)));
        } else {
            ValueType valueType = ValueType.fromDexType(this.proto.returnType);
            int tempValue = this.nextRegister(valueType);
            this.add(builder -> builder.addMoveResult(tempValue));
            this.add(builder -> builder.addReturn(tempValue));
        }
    }
}

