/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.NestBasedAccessDesugaring;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class D8NestBasedAccessDesugaring
extends NestBasedAccessDesugaring {
    private final Map<DexType, DexClass> metNestHosts = new ConcurrentHashMap<DexType, DexClass>();

    public D8NestBasedAccessDesugaring(AppView<?> appView) {
        super(appView);
    }

    public void rewriteNestBasedAccesses(DexEncodedMethod encodedMethod, IRCode code, AppView<?> appView) {
        DexClass currentClass = appView.definitionFor(encodedMethod.method.holder);
        assert (currentClass != null);
        if (!currentClass.isInANest()) {
            return;
        }
        this.metNestHosts.put(currentClass.getNestHost(), currentClass);
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator(code);
            while (instructions.hasNext()) {
                DexMethod bridge;
                DexEncodedField encodedField;
                Instruction instruction = (Instruction)instructions.next();
                if (instruction.isInvokeMethod()) {
                    InvokeMethod invokeMethod = instruction.asInvokeMethod();
                    DexMethod methodCalled = invokeMethod.getInvokedMethod();
                    DexEncodedMethod encodedMethodCalled = methodCalled.holder.isClassType() ? appView.definitionFor(methodCalled) : null;
                    if (encodedMethodCalled == null || !this.invokeRequiresRewriting(encodedMethodCalled, currentClass)) continue;
                    DexMethod bridge2 = this.ensureInvokeBridge(encodedMethodCalled);
                    if (encodedMethodCalled.isInstanceInitializer()) {
                        instructions.previous();
                        Value extraNullValue = instructions.insertConstNullInstruction(code, appView.options());
                        instructions.next();
                        ArrayList<Value> parameters = new ArrayList<Value>(invokeMethod.arguments());
                        parameters.add(extraNullValue);
                        instructions.replaceCurrentInstruction(new InvokeDirect(bridge2, invokeMethod.outValue(), parameters));
                        continue;
                    }
                    instructions.replaceCurrentInstruction(new InvokeStatic(bridge2, invokeMethod.outValue(), invokeMethod.arguments()));
                    continue;
                }
                if (!instruction.isFieldInstruction() || (encodedField = appView.definitionFor(instruction.asFieldInstruction().getField())) == null || !this.fieldAccessRequiresRewriting(encodedField, currentClass)) continue;
                if (instruction.isInstanceGet() || instruction.isStaticGet()) {
                    bridge = this.ensureFieldAccessBridge(encodedField, true);
                    instructions.replaceCurrentInstruction(new InvokeStatic(bridge, instruction.outValue(), instruction.inValues()));
                    continue;
                }
                assert (instruction.isInstancePut() || instruction.isStaticPut());
                bridge = this.ensureFieldAccessBridge(encodedField, false);
                instructions.replaceCurrentInstruction(new InvokeStatic(bridge, instruction.outValue(), instruction.inValues()));
            }
        }
    }

    private void processNestsConcurrently(ExecutorService executorService) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (DexClass clazz : this.metNestHosts.values()) {
            futures.add(this.asyncProcessNest(clazz, executorService));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void addDeferredBridges() {
        this.addDeferredBridges(this.bridges.values());
        this.addDeferredBridges(this.getFieldBridges.values());
        this.addDeferredBridges(this.putFieldBridges.values());
    }

    private void addDeferredBridges(Collection<DexEncodedMethod> bridges) {
        for (DexEncodedMethod bridge : bridges) {
            DexClass holder = this.definitionFor(bridge.method.holder);
            assert (holder != null && holder.isProgramClass());
            holder.asProgramClass().addMethod(bridge);
        }
    }

    private void optimizeDeferredBridgesConcurrently(ExecutorService executorService, IRConverter converter) throws ExecutionException {
        ArrayList<DexEncodedMethod> methods = new ArrayList<DexEncodedMethod>();
        methods.addAll(this.bridges.values());
        methods.addAll(this.getFieldBridges.values());
        methods.addAll(this.putFieldBridges.values());
        converter.processMethodsConcurrently(methods, executorService);
    }

    public void desugarNestBasedAccess(DexApplication.Builder<?> builder, ExecutorService executorService, IRConverter converter) throws ExecutionException {
        this.processNestsConcurrently(executorService);
        this.addDeferredBridges();
        this.synthesizeNestConstructor(builder);
        this.optimizeDeferredBridgesConcurrently(executorService, converter);
    }

    @Override
    protected boolean shouldProcessClassInNest(DexClass clazz, List<DexType> nest) {
        return clazz.isNotProgramClass();
    }

    @Override
    void reportMissingNestHost(DexClass clazz) {
        this.appView.options().nestDesugaringWarningMissingNestHost(clazz);
    }

    @Override
    void reportIncompleteNest(List<DexType> nest) {
        this.appView.options().nestDesugaringWarningIncompleteNest(nest, this.appView);
    }
}

