/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class SwitchUtils {
    public static EnumSwitchInfo analyzeSwitchOverEnum(Instruction switchInsn, AppView<AppInfoWithLiveness> appView) {
        AppInfoWithLiveness appInfo = appView.appInfo();
        Instruction input = switchInsn.inValues().get((int)0).definition;
        if (input == null || !input.isArrayGet()) {
            return null;
        }
        ArrayGet arrayGet = input.asArrayGet();
        Instruction index = arrayGet.index().definition;
        if (index == null || !index.isInvokeVirtual()) {
            return null;
        }
        InvokeVirtual ordinalInvoke = index.asInvokeVirtual();
        DexMethod ordinalMethod = ordinalInvoke.getInvokedMethod();
        DexClass enumClass = appInfo.definitionFor(ordinalMethod.holder);
        DexItemFactory dexItemFactory = appInfo.dexItemFactory();
        if (enumClass == null || !enumClass.accessFlags.isEnum() && enumClass.type != dexItemFactory.enumType || ordinalMethod.name != dexItemFactory.ordinalMethodName || ordinalMethod.proto.returnType != dexItemFactory.intType || !ordinalMethod.proto.parameters.isEmpty()) {
            return null;
        }
        Instruction array = arrayGet.array().definition;
        if (array == null || !array.isStaticGet()) {
            return null;
        }
        StaticGet staticGet = array.asStaticGet();
        Int2ReferenceMap<DexField> indexMap = appInfo.getSwitchMapFor(staticGet.getField());
        if (indexMap == null || indexMap.isEmpty()) {
            return null;
        }
        DexType enumType = ((DexField)indexMap.values().iterator().next()).holder;
        Map<DexField, AppInfoWithLiveness.EnumValueInfo> valueInfoMap = appInfo.getEnumValueInfoMapFor(enumType);
        if (valueInfoMap == null) {
            return null;
        }
        return new EnumSwitchInfo(enumType, ordinalInvoke, arrayGet, staticGet, indexMap, valueInfoMap);
    }

    public static final class EnumSwitchInfo {
        public final DexType enumClass;
        public final Instruction ordinalInvoke;
        public final Instruction arrayGet;
        public final Instruction staticGet;
        public final Int2ReferenceMap<DexField> indexMap;
        public final Map<DexField, AppInfoWithLiveness.EnumValueInfo> valueInfoMap;

        private EnumSwitchInfo(DexType enumClass, Instruction ordinalInvoke, Instruction arrayGet, Instruction staticGet, Int2ReferenceMap<DexField> indexMap, Map<DexField, AppInfoWithLiveness.EnumValueInfo> valueInfoMap) {
            this.enumClass = enumClass;
            this.ordinalInvoke = ordinalInvoke;
            this.arrayGet = arrayGet;
            this.staticGet = staticGet;
            this.indexMap = indexMap;
            this.valueInfoMap = valueInfoMap;
        }
    }
}

