/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstString;
import shadow.bundletool.com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.code.ConstString;
import shadow.bundletool.com.android.tools.r8.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassFilter;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

class IdentifierMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProguardClassFilter adaptClassStrings;
    private final NamingLens lens;

    IdentifierMinifier(AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        this.appView = appView;
        this.adaptClassStrings = appView.options().getProguardConfiguration().getAdaptClassStrings();
        this.lens = lens;
    }

    void run(ExecutorService executorService) throws ExecutionException {
        if (!this.adaptClassStrings.isEmpty()) {
            this.adaptClassStrings(executorService);
        }
        this.replaceDexItemBasedConstString(executorService);
    }

    private void adaptClassStrings(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            if (this.adaptClassStrings.matches(clazz.type)) {
                for (DexEncodedField field : clazz.staticFields()) {
                    this.adaptClassStringsInStaticField(field);
                }
                clazz.forEachMethod(this::adaptClassStringsInMethod);
            }
        }, executorService);
    }

    private void adaptClassStringsInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        DexValue staticValue = encodedField.getStaticValue();
        if (staticValue instanceof DexValue.DexValueString) {
            DexString original = (DexString)((DexValue.DexValueString)staticValue).getValue();
            encodedField.setStaticValue(new DexValue.DexValueString(this.getRenamedStringLiteral(original)));
        }
    }

    private void adaptClassStringsInMethod(DexEncodedMethod encodedMethod) {
        if (encodedMethod.shouldNotHaveCode()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        if (code.isDexCode()) {
            for (Instruction instruction : code.asDexCode().instructions) {
                if (!instruction.isConstString()) continue;
                ConstString cnst = instruction.asConstString();
                cnst.BBBB = this.getRenamedStringLiteral(cnst.getString());
            }
        } else {
            assert (code.isCfCode());
            for (CfInstruction instruction : code.asCfCode().getInstructions()) {
                if (!instruction.isConstString()) continue;
                CfConstString cnst = instruction.asConstString();
                cnst.setString(this.getRenamedStringLiteral(cnst.getString()));
            }
        }
    }

    private DexString getRenamedStringLiteral(DexString originalLiteral) {
        DexString renamed;
        String originalString = originalLiteral.toString();
        Map<String, DexType> renamedYetMatchedTypes = this.lens.getRenamedItems(DexType.class, type -> type.toSourceString().equals(originalString), DexType::toSourceString);
        DexType type2 = renamedYetMatchedTypes.get(originalString);
        if (type2 != null && (renamed = this.lens.lookupDescriptor(type2)) != originalLiteral) {
            return this.appView.dexItemFactory().createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
        }
        return originalLiteral;
    }

    private void replaceDexItemBasedConstString(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            for (DexEncodedField field : clazz.staticFields()) {
                this.replaceDexItemBasedConstStringInStaticField(field);
            }
            clazz.methods(DexEncodedMethod::hasCode).forEach(this::replaceDexItemBasedConstStringInMethod);
        }, executorService);
    }

    private void replaceDexItemBasedConstStringInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        DexValue staticValue = encodedField.getStaticValue();
        if (staticValue instanceof DexValue.DexItemBasedValueString) {
            DexValue.DexItemBasedValueString cnst = (DexValue.DexItemBasedValueString)staticValue;
            DexString replacement = cnst.getNameComputationInfo().computeNameFor((DexReference)cnst.getValue(), this.appView, this.lens);
            encodedField.setStaticValue(new DexValue.DexValueString(replacement));
        }
    }

    private void replaceDexItemBasedConstStringInMethod(DexEncodedMethod encodedMethod) {
        if (!encodedMethod.getOptimizationInfo().useIdentifierNameString()) assert (encodedMethod.getCode().isDexCode() && Arrays.stream(encodedMethod.getCode().asDexCode().instructions).noneMatch(Instruction::isDexItemBasedConstString) || encodedMethod.getCode().isCfCode() && encodedMethod.getCode().asCfCode().instructions.stream().noneMatch(CfInstruction::isDexItemBasedConstString));
        Code code = encodedMethod.getCode();
        assert (code != null);
        if (code.isDexCode()) {
            Instruction[] instructions = code.asDexCode().instructions;
            for (int i = 0; i < instructions.length; ++i) {
                Instruction instruction = instructions[i];
                if (!instruction.isDexItemBasedConstString()) continue;
                DexItemBasedConstString cnst = instruction.asDexItemBasedConstString();
                DexString replacement = cnst.getNameComputationInfo().computeNameFor(cnst.getItem(), this.appView, this.lens);
                ConstString constString = new ConstString((int)cnst.AA, replacement);
                constString.setOffset(instruction.getOffset());
                instructions[i] = constString;
            }
        } else {
            assert (code.isCfCode());
            List<CfInstruction> instructions = code.asCfCode().instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                CfInstruction instruction = instructions.get(i);
                if (!instruction.isDexItemBasedConstString()) continue;
                CfDexItemBasedConstString cnst = instruction.asDexItemBasedConstString();
                DexString replacement = cnst.getNameComputationInfo().computeNameFor(cnst.getItem(), this.appView, this.lens);
                instructions.set(i, new CfConstString(replacement));
            }
        }
    }
}

