/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring;

import shadow.bundletool.com.android.tools.r8.com.google.common.base.Strings;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class ClassNameComputationInfo
extends NameComputationInfo<DexType> {
    private static final ClassNameComputationInfo CANONICAL_NAME_INSTANCE = new ClassNameComputationInfo(ClassNameMapping.CANONICAL_NAME);
    private static final ClassNameComputationInfo NAME_INSTANCE = new ClassNameComputationInfo(ClassNameMapping.NAME);
    private static final ClassNameComputationInfo NONE_INSTANCE = new ClassNameComputationInfo(ClassNameMapping.NONE);
    private static final ClassNameComputationInfo SIMPLE_NAME_INSTANCE = new ClassNameComputationInfo(ClassNameMapping.SIMPLE_NAME);
    private static final ClassNameComputationInfo TYPE_NAME_INSTANCE = new ClassNameComputationInfo(ClassNameMapping.TYPE_NAME);
    private final int arrayDepth;
    private final ClassNameMapping mapping;

    private ClassNameComputationInfo(ClassNameMapping mapping) {
        this(mapping, 0);
    }

    private ClassNameComputationInfo(ClassNameMapping mapping, int arrayDepth) {
        this.mapping = mapping;
        this.arrayDepth = arrayDepth;
    }

    public static ClassNameComputationInfo create(ClassNameMapping mapping, int arrayDepth) {
        return arrayDepth > 0 ? new ClassNameComputationInfo(mapping, arrayDepth) : ClassNameComputationInfo.getInstance(mapping);
    }

    public static ClassNameComputationInfo getInstance(ClassNameMapping mapping) {
        switch (mapping) {
            case CANONICAL_NAME: {
                return CANONICAL_NAME_INSTANCE;
            }
            case NAME: {
                return NAME_INSTANCE;
            }
            case NONE: {
                return NONE_INSTANCE;
            }
            case SIMPLE_NAME: {
                return SIMPLE_NAME_INSTANCE;
            }
            case TYPE_NAME: {
                return TYPE_NAME_INSTANCE;
            }
        }
        throw new Unreachable("Unexpected ClassNameMapping: " + (Object)((Object)mapping));
    }

    public static ClassNameComputationInfo none() {
        return NONE_INSTANCE;
    }

    @Override
    public boolean needsToComputeName() {
        return this.mapping.needsToComputeClassName();
    }

    @Override
    public boolean needsToRegisterReference() {
        return this.mapping.needsToRegisterTypeReference();
    }

    @Override
    public DexString internalComputeNameFor(DexType type, DexDefinitionSupplier definitions, NamingLens namingLens) {
        return this.mapping.map(namingLens.lookupDescriptor(type).toString(), definitions.definitionFor(type), definitions.dexItemFactory(), this.arrayDepth);
    }

    @Override
    public boolean isClassNameComputationInfo() {
        return true;
    }

    @Override
    public ClassNameComputationInfo asClassNameComputationInfo() {
        return this;
    }

    public boolean equals(Object other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ClassNameComputationInfo otherInfo = (ClassNameComputationInfo)other;
        return this.arrayDepth == otherInfo.arrayDepth && this.mapping == otherInfo.mapping;
    }

    public int hashCode() {
        return this.mapping.ordinal() * 31 + this.arrayDepth;
    }

    public static final class ClassNameMapping
    extends Enum<ClassNameMapping> {
        public static final /* enum */ ClassNameMapping NONE = new ClassNameMapping();
        public static final /* enum */ ClassNameMapping NAME = new ClassNameMapping();
        public static final /* enum */ ClassNameMapping TYPE_NAME = new ClassNameMapping();
        public static final /* enum */ ClassNameMapping CANONICAL_NAME = new ClassNameMapping();
        public static final /* enum */ ClassNameMapping SIMPLE_NAME = new ClassNameMapping();
        private static final /* synthetic */ ClassNameMapping[] $VALUES;

        public static ClassNameMapping[] values() {
            return (ClassNameMapping[])$VALUES.clone();
        }

        public static ClassNameMapping valueOf(String name) {
            return Enum.valueOf(ClassNameMapping.class, name);
        }

        boolean needsToComputeClassName() {
            return this != NONE;
        }

        boolean needsToRegisterTypeReference() {
            return this == SIMPLE_NAME;
        }

        public DexString map(String descriptor, DexClass holder, DexItemFactory dexItemFactory) {
            return this.map(descriptor, holder, dexItemFactory, 0);
        }

        public DexString map(String descriptor, DexClass holder, DexItemFactory dexItemFactory, int arrayDepth) {
            String name;
            switch (this) {
                case NAME: {
                    name = DescriptorUtils.getClassNameFromDescriptor(descriptor);
                    if (arrayDepth <= 0) break;
                    name = Strings.repeat("[", arrayDepth) + "L" + name + ";";
                    break;
                }
                case TYPE_NAME: {
                    throw new Unreachable("Type#getTypeName not supported yet");
                }
                case CANONICAL_NAME: {
                    name = DescriptorUtils.getCanonicalNameFromDescriptor(descriptor);
                    if (arrayDepth <= 0) break;
                    name = name + Strings.repeat("[]", arrayDepth);
                    break;
                }
                case SIMPLE_NAME: {
                    assert (holder != null);
                    boolean renamed = !descriptor.equals(holder.type.toDescriptorString());
                    boolean needsToRetrieveInnerName = holder.isMemberClass() || holder.isLocalClass();
                    name = !renamed && needsToRetrieveInnerName ? holder.getInnerClassAttributeForThisClass().getInnerName().toString() : DescriptorUtils.getUnqualifiedClassNameFromDescriptor(descriptor);
                    if (arrayDepth <= 0) break;
                    name = name + Strings.repeat("[]", arrayDepth);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected ClassNameMapping: " + (Object)((Object)this));
                }
            }
            return dexItemFactory.createString(name);
        }

        static {
            $VALUES = new ClassNameMapping[]{NONE, NAME, TYPE_NAME, CANONICAL_NAME, SIMPLE_NAME};
        }
    }
}

