/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.references;

import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

@Keep
public final class ArrayReference
implements TypeReference {
    private final int dimensions;
    private final TypeReference baseType;
    private String descriptor;

    private ArrayReference(int dimensions, TypeReference baseType, String descriptor) {
        assert (dimensions > 0);
        this.dimensions = dimensions;
        this.baseType = baseType;
        this.descriptor = descriptor;
    }

    static ArrayReference fromDescriptor(String descriptor) {
        for (int i = 0; i < descriptor.length(); ++i) {
            if (descriptor.charAt(i) == '[') continue;
            if (i <= 0) break;
            return new ArrayReference(i, Reference.typeFromDescriptor(descriptor.substring(i)), descriptor);
        }
        throw new Unreachable("Invalid array type descriptor: " + descriptor);
    }

    static ArrayReference fromBaseType(TypeReference baseType, int dimensions) {
        return new ArrayReference(dimensions, baseType, DescriptorUtils.toArrayDescriptor(dimensions, baseType.getDescriptor()));
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public TypeReference getMemberType() {
        return Reference.arrayFromDescriptor(this.descriptor.substring(1));
    }

    public TypeReference getBaseType() {
        return this.baseType;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayReference asArray() {
        return this;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

