/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.references.ClassReference;
import shadow.bundletool.com.android.tools.r8.references.MethodReference;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.retrace.AmbiguousComparator;
import shadow.bundletool.com.android.tools.r8.retrace.Retrace;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBase;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceCommandLineResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceInvalidStackTraceLineDiagnostics;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceUtils;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public final class RetraceStackTrace {
    private final RetraceBase retraceBase;
    private final List<String> stackTrace;
    private final DiagnosticsHandler diagnosticsHandler;
    private final boolean verbose;

    RetraceStackTrace(RetraceBase retraceBase, List<String> stackTrace, DiagnosticsHandler diagnosticsHandler, boolean verbose) {
        this.retraceBase = retraceBase;
        this.stackTrace = stackTrace;
        this.diagnosticsHandler = diagnosticsHandler;
        this.verbose = verbose;
    }

    public RetraceCommandLineResult retrace() {
        ArrayList<StackTraceNode> result = new ArrayList<StackTraceNode>();
        this.retraceLine(this.stackTrace, 0, result);
        ArrayList<String> retracedStrings = new ArrayList<String>();
        for (StackTraceNode node : result) {
            node.append(retracedStrings);
        }
        return new RetraceCommandLineResult(retracedStrings);
    }

    private void retraceLine(List<String> stackTrace, int index, List<StackTraceNode> result) {
        if (stackTrace.size() <= index) {
            return;
        }
        StackTraceLine stackTraceLine = this.parseLine(index + 1, stackTrace.get(index));
        List<StackTraceLine> retraced = stackTraceLine.retrace(this.retraceBase, this.verbose);
        StackTraceNode node = new StackTraceNode(retraced);
        result.add(node);
        this.retraceLine(stackTrace, index + 1, result);
    }

    private StackTraceLine parseLine(int lineNumber, String line) {
        if (line == null) {
            this.diagnosticsHandler.error(RetraceInvalidStackTraceLineDiagnostics.createNull(lineNumber));
            throw new Retrace.RetraceAbortException();
        }
        StackTraceLine parsedLine = AtLine.tryParse(line);
        if (parsedLine != null) {
            return parsedLine;
        }
        parsedLine = ExceptionLine.tryParse(line);
        if (parsedLine != null) {
            return parsedLine;
        }
        parsedLine = MoreLine.tryParse(line);
        if (parsedLine == null) {
            this.diagnosticsHandler.warning(RetraceInvalidStackTraceLineDiagnostics.createParse(lineNumber, line));
        }
        parsedLine = new UnknownLine(line);
        return parsedLine;
    }

    static class UnknownLine
    extends StackTraceLine {
        private final String line;

        UnknownLine(String line) {
            this.line = line;
        }

        @Override
        List<StackTraceLine> retrace(RetraceBase retraceBase, boolean verbose) {
            return ImmutableList.of(new UnknownLine(this.line));
        }

        public String toString() {
            return this.line;
        }
    }

    static class MoreLine
    extends StackTraceLine {
        private final String line;

        MoreLine(String line) {
            this.line = line;
        }

        static StackTraceLine tryParse(String line) {
            int dotsSeen = 0;
            boolean isWhiteSpaceAllowed = true;
            for (int i = 0; i < line.length(); ++i) {
                char ch = line.charAt(i);
                if (Character.isWhitespace(ch) && isWhiteSpaceAllowed) continue;
                isWhiteSpaceAllowed = false;
                if (ch != '.') {
                    return null;
                }
                if (++dotsSeen != 3) continue;
                return new MoreLine(line);
            }
            return null;
        }

        @Override
        List<StackTraceLine> retrace(RetraceBase retraceBase, boolean verbose) {
            return ImmutableList.of(new MoreLine(this.line));
        }

        public String toString() {
            return this.line;
        }
    }

    static class AtLine
    extends StackTraceLine {
        private static final int NO_POSITION = -2;
        private static final int INVALID_POSITION = -1;
        private final String startingWhitespace;
        private final String at;
        private final String clazz;
        private final String method;
        private final String methodAsString;
        private final String fileName;
        private final int linePosition;
        private final boolean isAmbiguous;

        private AtLine(String startingWhitespace, String at, String clazz, String method, String methodAsString, String fileName, int linePosition, boolean isAmbiguous) {
            this.startingWhitespace = startingWhitespace;
            this.at = at;
            this.clazz = clazz;
            this.method = method;
            this.methodAsString = methodAsString;
            this.fileName = fileName;
            this.linePosition = linePosition;
            this.isAmbiguous = isAmbiguous;
        }

        static AtLine tryParse(String line) {
            if (line.length() == 0 || !Character.isWhitespace(line.charAt(0))) {
                return null;
            }
            int firstNonWhiteSpace = AtLine.firstNonWhiteSpaceCharacterFromIndex(line, 0);
            if (firstNonWhiteSpace + 2 >= line.length() || line.charAt(firstNonWhiteSpace) != 'a' || line.charAt(firstNonWhiteSpace + 1) != 't' || line.charAt(firstNonWhiteSpace + 2) != ' ') {
                return null;
            }
            int classStartIndex = AtLine.firstNonWhiteSpaceCharacterFromIndex(line, firstNonWhiteSpace + 2);
            if (classStartIndex >= line.length() || classStartIndex != firstNonWhiteSpace + 3) {
                return null;
            }
            int parensStart = AtLine.firstCharFromIndex(line, classStartIndex, '(');
            if (parensStart >= line.length()) {
                return null;
            }
            int parensEnd = AtLine.firstCharFromIndex(line, parensStart, ')');
            if (parensEnd >= line.length()) {
                return null;
            }
            if (AtLine.firstNonWhiteSpaceCharacterFromIndex(line, parensEnd) == line.length()) {
                return null;
            }
            int methodSeparator = line.lastIndexOf(46, parensStart);
            if (methodSeparator <= classStartIndex) {
                return null;
            }
            String fileName = "";
            int position = -2;
            int separatorIndex = AtLine.firstCharFromIndex(line, parensStart, ':');
            if (separatorIndex < parensEnd) {
                fileName = line.substring(parensStart + 1, separatorIndex);
                try {
                    String positionAsString = line.substring(separatorIndex + 1, parensEnd);
                    position = Integer.parseInt(positionAsString);
                }
                catch (NumberFormatException e) {
                    position = -1;
                }
            } else {
                fileName = line.substring(parensStart + 1, parensEnd);
            }
            String className = line.substring(classStartIndex, methodSeparator);
            String methodName = line.substring(methodSeparator + 1, parensStart);
            return new AtLine(line.substring(0, firstNonWhiteSpace), line.substring(firstNonWhiteSpace, classStartIndex), className, methodName, className + "." + methodName, fileName, position, false);
        }

        private boolean hasLinePosition() {
            return this.linePosition > -1;
        }

        @Override
        List<StackTraceLine> retrace(RetraceBase retraceBase, boolean verbose) {
            ArrayList<StackTraceLine> lines = new ArrayList<StackTraceLine>();
            ClassReference classReference = Reference.classFromTypeName(this.clazz);
            retraceBase.retrace(classReference).lookupMethod(this.method).narrowByLine(this.linePosition).forEach(methodElement -> {
                MethodReference methodReference = methodElement.getMethodReference();
                lines.add(new AtLine(this.startingWhitespace, this.at, methodReference.getHolderClass().getTypeName(), methodReference.getMethodName(), RetraceUtils.methodDescriptionFromMethodReference(methodReference, verbose), retraceBase.retraceSourceFile(classReference, this.fileName, methodReference.getHolderClass(), true), this.hasLinePosition() ? methodElement.getOriginalLineNumber(this.linePosition) : this.linePosition, methodElement.getRetraceMethodResult().isAmbiguous()));
            });
            return lines;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.startingWhitespace);
            sb.append(this.at);
            sb.append(this.methodAsString);
            sb.append("(");
            sb.append(this.fileName);
            if (this.linePosition != -2) {
                sb.append(":");
            }
            if (this.linePosition > -1) {
                sb.append(this.linePosition);
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        boolean isAtLine() {
            return true;
        }

        @Override
        AtLine asAtLine() {
            return this;
        }
    }

    static class ExceptionLine
    extends StackTraceLine {
        private static final String CAUSED_BY = "Caused by: ";
        private static final String SUPPRESSED = "Suppressed: ";
        private final String initialWhiteSpace;
        private final String description;
        private final String exceptionClass;
        private final String message;

        ExceptionLine(String initialWhiteSpace, String description, String exceptionClass, String message) {
            this.initialWhiteSpace = initialWhiteSpace;
            this.description = description;
            this.exceptionClass = exceptionClass;
            this.message = message;
        }

        static ExceptionLine tryParse(String line) {
            if (line.isEmpty()) {
                return null;
            }
            int firstNonWhiteSpaceChar = ExceptionLine.firstNonWhiteSpaceCharacterFromIndex(line, 0);
            String description = "";
            if (line.startsWith(CAUSED_BY, firstNonWhiteSpaceChar)) {
                description = CAUSED_BY;
            } else if (line.startsWith(SUPPRESSED, firstNonWhiteSpaceChar)) {
                description = SUPPRESSED;
            }
            int exceptionStartIndex = firstNonWhiteSpaceChar + description.length();
            int messageStartIndex = ExceptionLine.firstCharFromIndex(line, exceptionStartIndex, ':');
            String className = line.substring(exceptionStartIndex, messageStartIndex);
            if (!DescriptorUtils.isValidJavaType(className)) {
                return null;
            }
            return new ExceptionLine(line.substring(0, firstNonWhiteSpaceChar), description, className, line.substring(messageStartIndex));
        }

        @Override
        List<StackTraceLine> retrace(RetraceBase retraceBase, boolean verbose) {
            ArrayList<StackTraceLine> exceptionLines = new ArrayList<StackTraceLine>();
            retraceBase.retrace(Reference.classFromTypeName(this.exceptionClass)).forEach(element -> exceptionLines.add(new ExceptionLine(this.initialWhiteSpace, this.description, element.getClassReference().getTypeName(), this.message)));
            return exceptionLines;
        }

        public String toString() {
            return this.initialWhiteSpace + this.description + this.exceptionClass + this.message;
        }

        @Override
        boolean isExceptionLine() {
            return true;
        }

        @Override
        ExceptionLine asExceptionLine() {
            return this;
        }
    }

    static abstract class StackTraceLine {
        StackTraceLine() {
        }

        abstract List<StackTraceLine> retrace(RetraceBase var1, boolean var2);

        static int firstNonWhiteSpaceCharacterFromIndex(String line, int index) {
            return StackTraceLine.firstFromIndex(line, index, Predicates.not(Character::isWhitespace));
        }

        static int firstCharFromIndex(String line, int index, char ch) {
            return StackTraceLine.firstFromIndex(line, index, c -> c.charValue() == ch);
        }

        static int firstFromIndex(String line, int index, Predicate<Character> predicate) {
            for (int i = index; i < line.length(); ++i) {
                if (!predicate.test(Character.valueOf(line.charAt(i)))) continue;
                return i;
            }
            return line.length();
        }

        boolean isAtLine() {
            return false;
        }

        AtLine asAtLine() {
            return null;
        }

        boolean isExceptionLine() {
            return false;
        }

        ExceptionLine asExceptionLine() {
            return null;
        }
    }

    static class AtStackTraceLineComparator
    extends AmbiguousComparator<StackTraceLine> {
        AtStackTraceLineComparator() {
            super((line, t) -> {
                assert (line.isAtLine());
                AtLine atLine = line.asAtLine();
                switch (t) {
                    case CLASS: {
                        return atLine.clazz;
                    }
                    case METHOD: {
                        return atLine.method;
                    }
                    case SOURCE: {
                        return atLine.fileName;
                    }
                    case LINE: {
                        return atLine.linePosition + "";
                    }
                }
                assert (false);
                throw new RuntimeException("Comparator key is unknown");
            });
        }
    }

    public static class StackTraceNode {
        private final List<StackTraceLine> lines;

        StackTraceNode(List<StackTraceLine> lines) {
            this.lines = lines;
            assert (!lines.isEmpty());
            assert (lines.size() == 1 || lines.stream().allMatch(StackTraceLine::isAtLine));
        }

        public void append(List<String> strings) {
            assert (!this.lines.isEmpty());
            if (this.lines.size() == 1) {
                strings.add(this.lines.get(0).toString());
                return;
            }
            assert (this.lines.stream().allMatch(StackTraceLine::isAtLine));
            assert (this.lines.stream().allMatch(line -> line.asAtLine().isAmbiguous == this.lines.get(0).asAtLine().isAmbiguous));
            if (this.lines.get(0).asAtLine().isAmbiguous) {
                this.lines.sort(new AtStackTraceLineComparator());
            }
            boolean shouldPrintOr = false;
            for (StackTraceLine line2 : this.lines) {
                assert (line2.isAtLine());
                AtLine atLine = line2.asAtLine();
                if (atLine.isAmbiguous && shouldPrintOr) {
                    String atLineString = atLine.toString();
                    int firstNonWhitespaceCharacter = StringUtils.firstNonWhitespaceCharacter(atLineString);
                    strings.add(atLineString.substring(0, firstNonWhitespaceCharacter) + "<OR> " + atLineString.substring(firstNonWhitespaceCharacter));
                } else {
                    strings.add(atLine.toString());
                }
                shouldPrintOr = true;
            }
        }
    }
}

