/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Set;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;

public class MainDexDirectReferenceTracer {
    private final AnnotationDirectReferenceCollector annotationDirectReferenceCollector = new AnnotationDirectReferenceCollector();
    private final DirectReferencesCollector codeDirectReferenceCollector;
    private final AppInfoWithSubtyping appInfo;
    private final Consumer<DexType> consumer;

    public MainDexDirectReferenceTracer(AppInfoWithSubtyping appInfo, Consumer<DexType> consumer) {
        this.codeDirectReferenceCollector = new DirectReferencesCollector(appInfo.dexItemFactory());
        this.appInfo = appInfo;
        this.consumer = consumer;
    }

    public void run(Set<DexType> roots) {
        for (DexType type : roots) {
            DexClass clazz = this.appInfo.definitionFor(type);
            assert (clazz != null);
            this.consumer.accept(type);
            this.traceAnnotationsDirectDependencies(clazz.annotations);
            clazz.forEachField(field -> this.consumer.accept(field.field.type));
            clazz.forEachMethod(method -> {
                this.traceMethodDirectDependencies(method.method, this.consumer);
                method.registerCodeReferences(this.codeDirectReferenceCollector);
            });
        }
    }

    public void runOnCode(DexEncodedMethod method) {
        method.registerCodeReferences(this.codeDirectReferenceCollector);
    }

    public static boolean hasReferencesOutsideFromCode(AppInfoWithSubtyping appInfo, DexEncodedMethod method, Set<DexType> classes) {
        BooleanBox result = new BooleanBox();
        new MainDexDirectReferenceTracer(appInfo, type -> {
            DexClass cls;
            DexType baseType = type.toBaseType(appInfo.dexItemFactory());
            if (baseType.isClassType() && !classes.contains(baseType) && (cls = appInfo.definitionFor(baseType)) != null && cls.isProgramClass()) {
                result.value = true;
            }
        }).runOnCode(method);
        return result.value;
    }

    private void traceAnnotationsDirectDependencies(DexAnnotationSet annotations) {
        annotations.collectIndexedItems(this.annotationDirectReferenceCollector);
    }

    private void traceMethodDirectDependencies(DexMethod method, Consumer<DexType> consumer) {
        DexProto proto = method.proto;
        consumer.accept(proto.returnType);
        for (DexType parameterType : proto.parameters.values) {
            consumer.accept(parameterType);
        }
    }

    private class AnnotationDirectReferenceCollector
    implements IndexedItemCollection {
        private AnnotationDirectReferenceCollector() {
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            MainDexDirectReferenceTracer.this.consumer.accept(dexProgramClass.type);
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            MainDexDirectReferenceTracer.this.consumer.accept(field.holder);
            MainDexDirectReferenceTracer.this.consumer.accept(field.type);
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            MainDexDirectReferenceTracer.this.consumer.accept(method.holder);
            this.addProto(method.proto);
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            MainDexDirectReferenceTracer.this.consumer.accept(proto.returnType);
            for (DexType parameterType : proto.parameters.values) {
                MainDexDirectReferenceTracer.this.consumer.accept(parameterType);
            }
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            throw new AssertionError((Object)"CallSite are not supported when tracing for legacy multi dex");
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            throw new AssertionError((Object)"DexMethodHandle are not supported when tracing for legacy multi dex");
        }
    }

    private class DirectReferencesCollector
    extends UseRegistry {
        private DirectReferencesCollector(DexItemFactory factory) {
            super(factory);
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.registerInvoke(method);
        }

        protected boolean registerInvoke(DexMethod method) {
            MainDexDirectReferenceTracer.this.consumer.accept(method.holder);
            MainDexDirectReferenceTracer.this.traceMethodDirectDependencies(method, MainDexDirectReferenceTracer.this.consumer);
            return true;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.registerFieldAccess(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.registerFieldAccess(field);
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.registerFieldAccess(field);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.registerFieldAccess(field);
        }

        protected boolean registerFieldAccess(DexField field) {
            MainDexDirectReferenceTracer.this.consumer.accept(field.holder);
            MainDexDirectReferenceTracer.this.consumer.accept(field.type);
            return true;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
            return true;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
            return true;
        }
    }

    private static class BooleanBox {
        boolean value = false;

        private BooleanBox() {
        }
    }
}

