/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardPackageMatcher;

public class ProguardPackageNameList {
    private final Object2BooleanMap<ProguardPackageMatcher> packageNames;

    public static Builder builder() {
        return new Builder();
    }

    private ProguardPackageNameList(Object2BooleanMap<ProguardPackageMatcher> pacakgeNames) {
        this.packageNames = pacakgeNames;
    }

    public void writeTo(StringBuilder builder) {
        boolean first = true;
        for (Object2BooleanMap.Entry entry : this.packageNames.object2BooleanEntrySet()) {
            if (!first) {
                builder.append(',');
            }
            if (entry.getBooleanValue()) {
                builder.append('!');
            }
            builder.append(((ProguardPackageMatcher)entry.getKey()).toString());
            first = false;
        }
    }

    public boolean matches(DexType type) {
        for (Object2BooleanMap.Entry entry : this.packageNames.object2BooleanEntrySet()) {
            if (!((ProguardPackageMatcher)entry.getKey()).matches(type)) continue;
            return !entry.getBooleanValue();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProguardPackageNameList)) {
            return false;
        }
        ProguardPackageNameList other = (ProguardPackageNameList)o;
        if (this.packageNames.size() != other.packageNames.size()) {
            return false;
        }
        ObjectIterator<Object2BooleanMap.Entry<ProguardPackageMatcher>> i1 = this.packageNames.object2BooleanEntrySet().iterator();
        ObjectIterator<Object2BooleanMap.Entry<ProguardPackageMatcher>> i2 = other.packageNames.object2BooleanEntrySet().iterator();
        while (i1.hasNext()) {
            Object2BooleanMap.Entry e2;
            Object2BooleanMap.Entry e1 = (Object2BooleanMap.Entry)i1.next();
            if (e1.equals(e2 = (Object2BooleanMap.Entry)i2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (Object2BooleanMap.Entry entry : this.packageNames.object2BooleanEntrySet()) {
            hash *= entry.getBooleanValue() ? 1 : 2;
            hash = hash * 13 + ((ProguardPackageMatcher)entry.getKey()).hashCode();
        }
        return hash;
    }

    public static class Builder {
        private final Object2BooleanMap<ProguardPackageMatcher> matchers = new Object2BooleanArrayMap<ProguardPackageMatcher>();

        private Builder() {
        }

        public Builder addPackageName(boolean isNegated, ProguardPackageMatcher className) {
            this.matchers.put(className, isNegated);
            return this;
        }

        ProguardPackageNameList build() {
            return new ProguardPackageNameList(this.matchers);
        }
    }
}

