/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.DataResourceConsumer;
import shadow.bundletool.com.android.tools.r8.DesugarGraphConsumer;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.FeatureSplit;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.IncompleteNestNestDesugarDiagnosic;
import shadow.bundletool.com.android.tools.r8.errors.InterfaceDesugarMissingTypeDiagnostic;
import shadow.bundletool.com.android.tools.r8.errors.InvalidDebugInfoException;
import shadow.bundletool.com.android.tools.r8.errors.MissingNestHostNestDesugarDiagnostic;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.features.FeatureSplitConfiguration;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationRule;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import shadow.bundletool.com.android.tools.r8.utils.IROrdering;
import shadow.bundletool.com.android.tools.r8.utils.InternalOutputMode;
import shadow.bundletool.com.android.tools.r8.utils.OffOrAuto;
import shadow.bundletool.com.android.tools.r8.utils.Pair;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.VersionProperties;

public class InternalOptions {
    public static final boolean DETERMINISTIC_DEBUGGING = false;
    public static final int SUPPORTED_CF_MAJOR_VERSION = 55;
    public static final int SUPPORTED_DEX_VERSION = AndroidApiLevel.LATEST.getDexVersion().getIntValue();
    public static final int ASM_VERSION = 458752;
    public final DexItemFactory itemFactory;
    private final ProguardConfiguration proguardConfiguration;
    public final Reporter reporter;
    public ProgramConsumer programConsumer = null;
    public DataResourceConsumer dataResourceConsumer;
    public FeatureSplitConfiguration featureSplitConfiguration;
    public boolean printTimes = System.getProperty("shadow.bundletool.com.android.tools.r8.printtimes") != null;
    public boolean printMemory = System.getProperty("shadow.bundletool.com.android.tools.r8.printmemory") != null;
    public String dumpInputToFile = System.getProperty("shadow.bundletool.com.android.tools.r8.dumpinputtofile");
    public String dumpInputToDirectory = System.getProperty("shadow.bundletool.com.android.tools.r8.dumpinputtodirectory");
    public boolean passthroughDexCode = false;
    public boolean enableNeverMergePrefixes = true;
    public Set<String> neverMergePrefixes = ImmutableSet.of("j$.");
    public boolean libraryInterfacesMayHaveStaticInitialization = false;
    public boolean enableDynamicTypeOptimization = true;
    public boolean enableFieldBitAccessAnalysis = System.getProperty("shadow.bundletool.com.android.tools.r8.fieldBitAccessAnalysis") != null;
    public boolean enableHorizontalClassMerging = true;
    public boolean enableVerticalClassMerging = true;
    public boolean enableArgumentRemoval = true;
    public boolean enableUnusedArgumentRemoval = true;
    public boolean enableUnusedInterfaceRemoval = true;
    public boolean enableDevirtualization = true;
    public boolean enableNonNullTracking = true;
    public boolean enableInlining = !Version.isDevelopmentVersion() || System.getProperty("shadow.bundletool.com.android.tools.r8.disableinlining") == null;
    public boolean applyInliningToInlinee = System.getProperty("shadow.bundletool.com.android.tools.r8.applyInliningToInlinee") != null;
    public int applyInliningToInlineeMaxDepth = 0;
    public boolean enableInliningOfInvokesWithNullableReceivers = true;
    public boolean disableInliningOfLibraryMethodOverrides = true;
    public boolean enableClassInlining = true;
    public boolean enableClassStaticizer = true;
    public boolean enableInitializedClassesAnalysis = true;
    public boolean enableSideEffectAnalysis = true;
    public boolean enableDeterminismAnalysis = true;
    public boolean enableServiceLoaderRewriting = true;
    public boolean enableNameReflectionOptimization = true;
    public boolean enableStringConcatenationOptimization = true;
    public boolean enableTreeShakingOfLibraryMethodOverrides = false;
    public boolean enablePropagationOfDynamicTypesAtCallSites = true;
    public boolean enablePropagationOfConstantsAtCallSites = false;
    public boolean enableKotlinMetadataRewriting = false;
    public boolean encodeChecksums = false;
    public BiPredicate<String, Long> dexClassChecksumFilter = (name, checksum) -> true;
    public boolean enableCfInterfaceMethodDesugaring = false;
    public int callGraphLikelySpuriousCallEdgeThreshold = 50;
    public int classInliningInstructionLimit = 10;
    public int classInliningInstructionAllowance = 50;
    public int inliningInstructionLimit = 3;
    public int inliningInstructionAllowance = 1500;
    public int inliningMonitorEnterValuesAllowance = 4;
    public int inliningControlFlowResolutionBlocksThreshold = 15;
    public boolean enableStringSwitchConversion = System.getProperty("shadow.bundletool.com.android.tools.r8.stringSwitchConversion") != null;
    public boolean enableEnumValueOptimization = true;
    public final OutlineOptions outline = new OutlineOptions();
    public boolean enableInitializedClassesInInstanceMethodsAnalysis = true;
    public boolean enableRedundantFieldLoadElimination = true;
    public boolean enableValuePropagation = true;
    public boolean enableValuePropagationForInstanceFields = false;
    public boolean enableUninstantiatedTypeOptimization = true;
    public boolean enableUninstantiatedTypeOptimizationForInterfaces = false;
    public boolean enableRedundantConstNumberOptimization = false;
    public int numberOfThreads = -1;
    public boolean useSmaliSyntax = false;
    public boolean verbose = false;
    public boolean quiet = false;
    public boolean invalidDebugInfoFatal = false;
    public boolean ignoreMainDexMissingClasses = false;
    private boolean hasMarker = false;
    private Marker marker;
    public Set<String> extensiveLoggingFilter = InternalOptions.getExtensiveLoggingFilter();
    public Set<String> extensiveInterfaceMethodMinifierLoggingFilter = InternalOptions.getExtensiveInterfaceMethodMinifierLoggingFilter();
    public List<String> methodsFilter = ImmutableList.of();
    public int minApiLevel = AndroidApiLevel.getDefault().getLevel();
    public boolean intermediate = false;
    public boolean readCompileTimeAnnotations = true;
    public List<String> logArgumentsFilter = ImmutableList.of();
    public boolean enableLoadStoreOptimization = true;
    public boolean enableLambdaMerging = false;
    public boolean enableDesugaring = true;
    public boolean enableNestBasedAccessDesugaring = true;
    public boolean enableNestReduction = true;
    public OffOrAuto interfaceMethodDesugaring = OffOrAuto.Auto;
    public OffOrAuto tryWithResourcesDesugaring = OffOrAuto.Auto;
    public boolean processCovariantReturnTypeAnnotations = true;
    public boolean lookupLibraryBeforeProgram = false;
    public boolean enableMainDexListCheck = true;
    private final boolean enableTreeShaking;
    private final boolean enableMinification;
    public boolean printCfg = false;
    public String printCfgFile;
    public boolean ignoreMissingClasses = false;
    public boolean forceProguardCompatibility = false;
    public AssertionConfigurationWithDefault assertionsConfiguration = null;
    public boolean configurationDebugging = false;
    public boolean skipIR = false;
    public boolean debug = false;
    private final ProtoShrinkingOptions protoShrinking = new ProtoShrinkingOptions();
    private final KotlinOptimizationOptions kotlinOptimizationOptions = new KotlinOptimizationOptions();
    public final TestingOptions testing = new TestingOptions();
    public List<ProguardConfigurationRule> mainDexKeepRules = ImmutableList.of();
    public boolean minimalMainDex;
    public boolean enableInheritanceClassInDexDistributor = true;
    public LineNumberOptimization lineNumberOptimization = LineNumberOptimization.ON;
    private final Map<Origin, List<TypeVersionPair>> missingEnclosingMembers = new HashMap<Origin, List<TypeVersionPair>>();
    private final Map<Origin, List<InvalidParameterAnnotationInfo>> warningInvalidParameterAnnotations = new HashMap<Origin, List<InvalidParameterAnnotationInfo>>();
    private final Map<Origin, List<Pair<DexEncodedMethod, String>>> warningInvalidDebugInfo = new HashMap<Origin, List<Pair<DexEncodedMethod, String>>>();
    public boolean skipReadingDexCode = false;
    public StringConsumer mainDexListConsumer = null;
    public StringConsumer proguardMapConsumer = null;
    public StringConsumer usageInformationConsumer = null;
    public StringConsumer proguardSeedsConsumer = null;
    public StringConsumer configurationConsumer = null;
    public DesugaredLibraryConfiguration desugaredLibraryConfiguration = DesugaredLibraryConfiguration.empty();
    public StringConsumer desugaredLibraryKeepRuleConsumer = null;
    public GraphConsumer keptGraphConsumer = null;
    public GraphConsumer mainDexKeptGraphConsumer = null;
    public DesugarGraphConsumer desugarGraphConsumer = null;
    public Consumer<List<ProguardConfigurationRule>> syntheticProguardRulesConsumer = null;
    private final Set<DexItem> reportedMissingForDesugaring = Sets.newConcurrentHashSet();

    public boolean hasProguardConfiguration() {
        return this.proguardConfiguration != null;
    }

    public ProguardConfiguration getProguardConfiguration() {
        return this.proguardConfiguration;
    }

    public InternalOptions() {
        this.reporter = new Reporter();
        this.itemFactory = new DexItemFactory();
        this.proguardConfiguration = null;
        this.enableTreeShaking = false;
        this.enableMinification = false;
    }

    public InternalOptions(DexItemFactory factory, Reporter reporter) {
        assert (reporter != null);
        assert (factory != null);
        this.reporter = reporter;
        this.itemFactory = factory;
        this.proguardConfiguration = null;
        this.enableTreeShaking = false;
        this.enableMinification = false;
        this.disableGlobalOptimizations();
    }

    public InternalOptions(ProguardConfiguration proguardConfiguration, Reporter reporter) {
        assert (reporter != null);
        assert (proguardConfiguration != null);
        this.reporter = reporter;
        this.proguardConfiguration = proguardConfiguration;
        this.itemFactory = proguardConfiguration.getDexItemFactory();
        this.enableTreeShaking = proguardConfiguration.isShrinking();
        this.enableMinification = proguardConfiguration.isObfuscating();
        if (!proguardConfiguration.isOptimizing()) {
            this.disableAllOptimizations();
        }
        this.configurationDebugging = proguardConfiguration.isConfigurationDebugging();
    }

    void disableAllOptimizations() {
        this.disableGlobalOptimizations();
        this.enableNonNullTracking = false;
        this.enableNameReflectionOptimization = false;
        this.enableStringConcatenationOptimization = false;
    }

    public void disableGlobalOptimizations() {
        this.enableArgumentRemoval = false;
        this.enableDynamicTypeOptimization = false;
        this.enableInlining = false;
        this.enableClassInlining = false;
        this.enableClassStaticizer = false;
        this.enableDevirtualization = false;
        this.enableLambdaMerging = false;
        this.enableHorizontalClassMerging = false;
        this.enableVerticalClassMerging = false;
        this.enableUninstantiatedTypeOptimization = false;
        this.enableUnusedArgumentRemoval = false;
        this.outline.enabled = false;
        this.enableEnumValueOptimization = false;
        this.enableValuePropagation = false;
        this.enableSideEffectAnalysis = false;
        this.enableTreeShakingOfLibraryMethodOverrides = false;
        this.enablePropagationOfDynamicTypesAtCallSites = false;
        this.enablePropagationOfConstantsAtCallSites = false;
    }

    public void setMarker(Marker marker) {
        this.hasMarker = true;
        this.marker = marker;
    }

    public Marker getMarker(Marker.Tool tool) {
        if (this.hasMarker) {
            return this.marker;
        }
        return this.createMarker(tool);
    }

    private Marker createMarker(Marker.Tool tool) {
        if (tool == Marker.Tool.D8 && this.testing.dontCreateMarkerInD8) {
            return null;
        }
        Marker marker = new Marker(tool).setVersion("2.0.23").setCompilationMode(this.debug ? CompilationMode.DEBUG : CompilationMode.RELEASE).setHasChecksums(this.encodeChecksums);
        if (!this.isGeneratingClassFiles()) {
            marker.setMinApi(this.minApiLevel);
        }
        if (Version.isDevelopmentVersion()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        return marker;
    }

    public boolean hasConsumer() {
        return this.programConsumer != null;
    }

    public InternalOutputMode getInternalOutputMode() {
        assert (this.hasConsumer());
        if (this.isGeneratingDexIndexed()) {
            return InternalOutputMode.DexIndexed;
        }
        if (this.isGeneratingDexFilePerClassFile()) {
            return InternalOutputMode.DexFilePerClassFile;
        }
        if (this.isGeneratingClassFiles()) {
            return InternalOutputMode.ClassFile;
        }
        throw new UnsupportedOperationException("Cannot find internal output mode.");
    }

    public boolean isDesugaredLibraryCompilation() {
        return this.desugaredLibraryConfiguration.isLibraryCompilation();
    }

    public boolean shouldKeepStackMapTable() {
        return this.isDesugaredLibraryCompilation() || this.getProguardConfiguration().getKeepAttributes().stackMapTable;
    }

    public boolean isGeneratingDex() {
        return this.isGeneratingDexIndexed() || this.isGeneratingDexFilePerClassFile();
    }

    public boolean isGeneratingDexIndexed() {
        return this.programConsumer instanceof DexIndexedConsumer;
    }

    public boolean isGeneratingDexFilePerClassFile() {
        return this.programConsumer instanceof DexFilePerClassFileConsumer;
    }

    public boolean isGeneratingClassFiles() {
        return this.programConsumer instanceof ClassFileConsumer;
    }

    public DexIndexedConsumer getDexIndexedConsumer() {
        return (DexIndexedConsumer)this.programConsumer;
    }

    public DexFilePerClassFileConsumer getDexFilePerClassFileConsumer() {
        return (DexFilePerClassFileConsumer)this.programConsumer;
    }

    public ClassFileConsumer getClassFileConsumer() {
        return (ClassFileConsumer)this.programConsumer;
    }

    public void signalFinishedToConsumers() {
        if (this.programConsumer != null) {
            this.programConsumer.finished(this.reporter);
            if (this.dataResourceConsumer != null) {
                this.dataResourceConsumer.finished(this.reporter);
            }
        }
        if (this.featureSplitConfiguration != null) {
            for (FeatureSplit featureSplit : this.featureSplitConfiguration.getFeatureSplits()) {
                ProgramConsumer programConsumer = featureSplit.getProgramConsumer();
                programConsumer.finished(this.reporter);
                DataResourceConsumer dataResourceConsumer = programConsumer.getDataResourceConsumer();
                if (dataResourceConsumer == null) continue;
                dataResourceConsumer.finished(this.reporter);
            }
        }
        if (this.desugarGraphConsumer != null) {
            this.desugarGraphConsumer.finished();
        }
    }

    public boolean shouldDesugarNests() {
        if (this.testing.enableForceNestBasedAccessDesugaringForTest) {
            return true;
        }
        return this.enableNestBasedAccessDesugaring && !this.canUseNestBasedAccess();
    }

    public boolean isShrinking() {
        return this.enableTreeShaking;
    }

    public boolean isMinifying() {
        return this.enableMinification;
    }

    public ProtoShrinkingOptions protoShrinking() {
        return this.protoShrinking;
    }

    public KotlinOptimizationOptions kotlinOptimizationOptions() {
        return this.kotlinOptimizationOptions;
    }

    public static boolean shouldEnableKeepRuleSynthesisForRecompilation() {
        return System.getProperty("shadow.bundletool.com.android.tools.r8.keepRuleSynthesisForRecompilation") != null;
    }

    private static Set<String> getExtensiveLoggingFilter() {
        String property = System.getProperty("shadow.bundletool.com.android.tools.r8.extensiveLoggingFilter");
        if (property != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String method : property.split(";")) {
                builder.add(method);
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    private static Set<String> getExtensiveFieldMinifierLoggingFilter() {
        String property = System.getProperty("shadow.bundletool.com.android.tools.r8.extensiveFieldMinifierLoggingFilter");
        if (property != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String method : property.split(";")) {
                builder.add(method);
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    private static Set<String> getExtensiveInterfaceMethodMinifierLoggingFilter() {
        String property = System.getProperty("shadow.bundletool.com.android.tools.r8.extensiveInterfaceMethodMinifierLoggingFilter");
        if (property != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String method : property.split(";")) {
                builder.add(method);
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    private static Set<String> getNullableReceiverInliningFilter() {
        String property = System.getProperty("shadow.bundletool.com.android.tools.r8.nullableReceiverInliningFilter");
        if (property != null) {
            Path path = null;
            try {
                Path tmp = Paths.get(property, new String[0]);
                if (Files.exists(tmp, new LinkOption[0])) {
                    path = tmp;
                }
            }
            catch (NullPointerException | InvalidPathException tmp) {
                // empty catch block
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (path != null) {
                try {
                    Files.readAllLines(path).stream().map(String::trim).filter(Predicates.not(String::isEmpty)).forEach(builder::add);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                for (String method : property.split(";")) {
                    builder.add(method);
                }
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    public boolean hasUsageInformationConsumer() {
        return this.usageInformationConsumer != null;
    }

    public static boolean assertionsEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    public void errorMissingClassMissingNestHost(DexClass compiledClass) {
        throw this.reporter.fatalError(this.messageErrorMissingNestHost(compiledClass));
    }

    public void warningMissingClassMissingNestHost(DexClass compiledClass) {
        if (compiledClass.isLibraryClass()) {
            this.errorMissingClassMissingNestHost(compiledClass);
        }
        this.reporter.warning(new StringDiagnostic(this.messageWarningMissingNestHost(compiledClass)));
    }

    public void nestDesugaringWarningMissingNestHost(DexClass compiledClass) {
        if (compiledClass.isLibraryClass()) {
            this.errorMissingClassMissingNestHost(compiledClass);
        }
        this.reporter.warning(new MissingNestHostNestDesugarDiagnostic(compiledClass.getOrigin(), Position.UNKNOWN, this.messageWarningMissingNestHost(compiledClass)));
    }

    public void errorMissingClassIncompleteNest(List<DexType> nest, AppView<?> appView) {
        throw this.reporter.fatalError(this.messageErrorIncompleteNest(nest, appView));
    }

    public void warningMissingClassIncompleteNest(List<DexType> nest, AppView<?> appView) {
        for (DexType type : nest) {
            DexClass clazz = appView.definitionFor(type);
            if (clazz == null || !clazz.isLibraryClass()) continue;
            this.errorMissingClassIncompleteNest(nest, appView);
            return;
        }
        this.reporter.warning(new StringDiagnostic(this.messageWarningIncompleteNest(nest, appView)));
    }

    public void nestDesugaringWarningIncompleteNest(List<DexType> nest, AppView<?> appView) {
        DexClass availableClass = null;
        for (DexType type : nest) {
            DexClass clazz = appView.definitionFor(type);
            if (clazz != null && clazz.isProgramClass()) {
                availableClass = clazz;
                continue;
            }
            if (clazz == null || !clazz.isLibraryClass()) continue;
            this.errorMissingClassIncompleteNest(nest, appView);
            return;
        }
        assert (availableClass != null);
        this.reporter.warning(new IncompleteNestNestDesugarDiagnosic(availableClass.getOrigin(), Position.UNKNOWN, this.messageWarningIncompleteNest(nest, appView)));
    }

    private String messageErrorMissingNestHost(DexClass compiledClass) {
        String nestHostName = compiledClass.getNestHost().getName();
        return "Class " + compiledClass.type.getName() + " requires its nest host " + nestHostName + " to be on program or class path. ";
    }

    private String messageWarningMissingNestHost(DexClass compiledClass) {
        return this.messageErrorMissingNestHost(compiledClass) + "Class" + compiledClass.type.getName() + " is considered as not being part of any nest.";
    }

    private String messageErrorIncompleteNest(List<DexType> nest, AppView<?> appView) {
        ArrayList<String> programClassesFromNest = new ArrayList<String>();
        ArrayList<String> unavailableClasses = new ArrayList<String>();
        ArrayList<String> classPathClasses = new ArrayList<String>();
        ArrayList<String> libraryClasses = new ArrayList<String>();
        for (DexType type : nest) {
            DexClass clazz = appView.definitionFor(appView.graphLense().lookupType(type));
            if (clazz == null) {
                unavailableClasses.add(type.getName());
                continue;
            }
            if (clazz.isLibraryClass()) {
                libraryClasses.add(type.getName());
                continue;
            }
            if (clazz.isProgramClass()) {
                programClassesFromNest.add(type.getName());
                continue;
            }
            assert (clazz.isClasspathClass());
            classPathClasses.add(type.getName());
        }
        StringBuilder stringBuilder = new StringBuilder("Compilation of classes ").append(String.join((CharSequence)", ", programClassesFromNest)).append(" requires its nest mates ");
        if (!unavailableClasses.isEmpty()) {
            stringBuilder.append(String.join((CharSequence)", ", unavailableClasses)).append(" (unavailable) ");
        }
        if (!libraryClasses.isEmpty()) {
            stringBuilder.append(String.join((CharSequence)", ", unavailableClasses)).append(" (on library path) ");
        }
        stringBuilder.append("to be on program or class path.");
        if (!classPathClasses.isEmpty()) {
            stringBuilder.append("(Classes ").append(String.join((CharSequence)", ", classPathClasses)).append(" from the same nest are on class path).");
        }
        return stringBuilder.toString();
    }

    private String messageWarningIncompleteNest(List<DexType> nest, AppView<?> appView) {
        return this.messageErrorIncompleteNest(nest, appView) + " Unavailable classes are considered as not being part of the nest.";
    }

    public void warningMissingTypeForDesugar(Origin origin, Position position, DexType missingType, DexType contextType) {
        if (this.reportedMissingForDesugaring.add(missingType)) {
            this.reporter.warning(new InterfaceDesugarMissingTypeDiagnostic(origin, position, Reference.classFromDescriptor(missingType.toDescriptorString()), Reference.classFromDescriptor(contextType.toDescriptorString()), null));
        }
    }

    public void warningMissingInterfaceForDesugar(DexClass classToDesugar, DexClass implementing, DexType missing) {
        if (this.reportedMissingForDesugaring.add(missing)) {
            this.reporter.warning(new InterfaceDesugarMissingTypeDiagnostic(classToDesugar.getOrigin(), Position.UNKNOWN, Reference.classFromDescriptor(missing.toDescriptorString()), Reference.classFromDescriptor(classToDesugar.getType().toDescriptorString()), classToDesugar == implementing ? null : Reference.classFromDescriptor(implementing.getType().toDescriptorString())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningMissingEnclosingMember(DexType clazz, Origin origin, int version) {
        TypeVersionPair pair = new TypeVersionPair(version, clazz);
        Map<Origin, List<TypeVersionPair>> map2 = this.missingEnclosingMembers;
        synchronized (map2) {
            this.missingEnclosingMembers.computeIfAbsent(origin, k -> new ArrayList()).add(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningInvalidParameterAnnotations(DexMethod method, Origin origin, int expected, int actual) {
        InvalidParameterAnnotationInfo info = new InvalidParameterAnnotationInfo(method, expected, actual);
        Map<Origin, List<InvalidParameterAnnotationInfo>> map2 = this.warningInvalidParameterAnnotations;
        synchronized (map2) {
            this.warningInvalidParameterAnnotations.computeIfAbsent(origin, k -> new ArrayList()).add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningInvalidDebugInfo(DexEncodedMethod method, Origin origin, InvalidDebugInfoException e) {
        if (this.invalidDebugInfoFatal) {
            throw new CompilationError("Fatal warning: Invalid debug info", e);
        }
        Map<Origin, List<Pair<DexEncodedMethod, String>>> map2 = this.warningInvalidDebugInfo;
        synchronized (map2) {
            this.warningInvalidDebugInfo.computeIfAbsent(origin, k -> new ArrayList()).add(new Pair<DexEncodedMethod, String>(method, e.getMessage()));
        }
    }

    public boolean printWarnings() {
        StringBuilder builder;
        boolean printed = false;
        boolean printOutdatedToolchain = false;
        if (this.warningInvalidParameterAnnotations.size() > 0) {
            this.reporter.info(new StringDiagnostic("Invalid parameter counts in MethodParameter attributes. This is likely due to Proguard having removed a parameter."));
            for (Origin origin : new TreeSet<Origin>(this.warningInvalidParameterAnnotations.keySet())) {
                builder = new StringBuilder("Methods with invalid MethodParameter attributes:");
                for (InvalidParameterAnnotationInfo info : this.warningInvalidParameterAnnotations.get(origin)) {
                    builder.append("\n  ").append(info.method).append(" expected count: ").append(info.expectedParameterCount).append(" actual count: ").append(info.actualParameterCount);
                }
                this.reporter.info(new StringDiagnostic(builder.toString(), origin));
            }
            printed = true;
        }
        if (this.warningInvalidDebugInfo.size() > 0) {
            int count = 0;
            for (List<Pair<DexEncodedMethod, String>> methods : this.warningInvalidDebugInfo.values()) {
                count += methods.size();
            }
            this.reporter.info(new StringDiagnostic("Stripped invalid locals information from " + count + (count == 1 ? " method." : " methods.")));
            for (Origin origin : new TreeSet<Origin>(this.warningInvalidDebugInfo.keySet())) {
                StringBuilder builder2 = new StringBuilder("Methods with invalid locals information:");
                for (Pair pair : this.warningInvalidDebugInfo.get(origin)) {
                    builder2.append("\n  ").append(((DexEncodedMethod)pair.getFirst()).toSourceString());
                    builder2.append("\n  ").append((String)pair.getSecond());
                }
                this.reporter.info(new StringDiagnostic(builder2.toString(), origin));
            }
            printed = true;
            printOutdatedToolchain = true;
        }
        if (this.missingEnclosingMembers.size() > 0) {
            this.reporter.info(new StringDiagnostic("InnerClasses attribute has entries missing a corresponding EnclosingMethod attribute. Such InnerClasses attribute entries are ignored."));
            for (Origin origin : new TreeSet<Origin>(this.missingEnclosingMembers.keySet())) {
                builder = new StringBuilder("Classes with missing EnclosingMethod: ");
                boolean first = true;
                for (TypeVersionPair typeVersionPair : this.missingEnclosingMembers.get(origin)) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(typeVersionPair.type);
                    printOutdatedToolchain |= typeVersionPair.version < 49;
                }
                this.reporter.info(new StringDiagnostic(builder.toString(), origin));
            }
            printed = true;
        }
        if (printOutdatedToolchain) {
            this.reporter.info(new StringDiagnostic("Some warnings are typically a sign of using an outdated Java toolchain. To fix, recompile the source with an updated toolchain."));
        }
        return printed;
    }

    public boolean hasMethodsFilter() {
        return this.methodsFilter.size() > 0;
    }

    public boolean methodMatchesFilter(DexEncodedMethod method) {
        if (!this.hasMethodsFilter()) {
            return true;
        }
        String qualifiedName = method.qualifiedName();
        return this.methodsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean methodMatchesLogArgumentsFilter(DexEncodedMethod method) {
        if (this.logArgumentsFilter.size() == 0) {
            return false;
        }
        String qualifiedName = method.qualifiedName();
        return this.logArgumentsFilter.indexOf(qualifiedName) >= 0;
    }

    @VisibleForTesting
    public void disableNameReflectionOptimization() {
        this.enableNameReflectionOptimization = false;
    }

    @VisibleForTesting
    public void enablePropagationOfConstantsAtCallSites() {
        assert (!this.enablePropagationOfConstantsAtCallSites);
        this.enablePropagationOfConstantsAtCallSites = true;
    }

    @VisibleForTesting
    public void enableKotlinMetadataRewriting() {
        assert (!this.enableKotlinMetadataRewriting);
        this.enableKotlinMetadataRewriting = true;
    }

    private boolean hasMinApi(AndroidApiLevel level) {
        assert (this.isGeneratingDex());
        return this.minApiLevel >= level.getLevel();
    }

    public boolean canUseInvokePolymorphicOnVarHandle() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseInvokePolymorphic() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseConstantMethodHandle() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseConstantMethodType() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseInvokeCustom() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseDefaultAndStaticInterfaceMethods() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean canUseNestBasedAccess() {
        return this.isGeneratingClassFiles();
    }

    public boolean canLeaveStaticInterfaceMethodInvokes() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canUseTwrCloseResourceMethod() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUsePrivateInterfaceMethods() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean isInterfaceMethodDesugaringEnabled() {
        if (!this.hasConsumer()) {
            return false;
        }
        return this.enableDesugaring && this.interfaceMethodDesugaring == OffOrAuto.Auto && (!this.canUseDefaultAndStaticInterfaceMethods() || this.enableCfInterfaceMethodDesugaring);
    }

    public boolean isStringSwitchConversionEnabled() {
        return this.enableStringSwitchConversion && !this.debug;
    }

    public boolean canUseMultidex() {
        assert (this.isGeneratingDex());
        return this.intermediate || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canUseSuppressedExceptions() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseAssertionErrorTwoArgumentConstructor() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canInitCauseAfterAssertionErrorObjectConstructor() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.J);
    }

    public boolean canUseFilledNewArrayOfObjects() {
        assert (this.isGeneratingDex());
        return this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseSameArrayAndResultRegisterInArrayGetWide() {
        assert (this.isGeneratingDex());
        return this.minApiLevel > AndroidApiLevel.O_MR1.getLevel();
    }

    public boolean canHaveBoundsCheckEliminationBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canUseNotInstruction() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canHaveThisTypeVerifierBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveThisJitCodeDebuggingBug() {
        return this.minApiLevel < AndroidApiLevel.Q.getLevel();
    }

    public boolean canHaveOverlappingLongRegisterBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveCmpLongBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveCmpIfFloatBug() {
        return this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveMul2AddrBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveDex2OatLinkedListBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.N.getLevel();
    }

    public boolean canHaveDex2OatInliningIssue() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.N.getLevel();
    }

    public boolean canHaveArtStringNewInitBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.Q.getLevel();
    }

    public boolean canHaveNumberConversionRegisterAllocationBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveForwardingInitInliningBug() {
        return this.isGeneratingDex() && this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveExceptionTargetingLoopHeaderBug() {
        return this.isGeneratingDex() && !this.debug && this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveTracingPastInstructionsStreamBug() {
        return this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveArtInstanceOfVerifierBug() {
        assert (this.isGeneratingDex());
        return this.minApiLevel < AndroidApiLevel.Q.getLevel();
    }

    public boolean canHaveLongToIntBug() {
        return this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveExceptionTypeBug() {
        return this.minApiLevel < AndroidApiLevel.Q.getLevel();
    }

    public boolean canHaveArtCheckCastVerifierBug() {
        return this.minApiLevel < AndroidApiLevel.J.getLevel();
    }

    public boolean canHaveIncorrectJoinForArrayOfInterfacesBug() {
        return true;
    }

    public boolean canHaveDalvikCatchHandlerVerificationBug() {
        return this.isGeneratingClassFiles() || this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug() {
        return this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveDalvikIntUsedAsNonIntPrimitiveTypeBug() {
        return this.isGeneratingClassFiles() || this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public static class TestingOptions {
        public static int NO_LIMIT = -1;
        public byte[] forceDexVersionBytes = null;
        public IROrdering irOrdering = InternalOptions.assertionsEnabled() ? IROrdering.NondeterministicIROrdering.getInstance() : IROrdering.IdentityIROrdering.getInstance();
        public boolean addCallEdgesForLibraryInvokes = false;
        public boolean allowTypeErrors = !Version.isDevelopmentVersion() || System.getProperty("shadow.bundletool.com.android.tools.r8.allowTypeErrors") != null;
        public boolean allowInvokeErrors = false;
        public boolean disableL8AnnotationRemoval = false;
        public boolean allowClassInlinerGracefulExit = true;
        public boolean allowUnusedProguardConfigurationRules = true;
        public boolean reportUnusedProguardConfigurationRules = false;
        public boolean alwaysUsePessimisticRegisterAllocation = false;
        public boolean enableCheckCastAndInstanceOfRemoval = true;
        public boolean enableDeadSwitchCaseElimination = true;
        public boolean enableSwitchToIfRewriting = true;
        public boolean forceRedundantConstNumberRemoval = false;
        public boolean forceAssumeNoneInsertion = false;
        public boolean invertConditionals = false;
        public boolean placeExceptionalBlocksLast = false;
        public boolean dontCreateMarkerInD8 = false;
        public boolean forceJumboStringProcessing = false;
        public boolean nondeterministicCycleElimination = false;
        public Set<Inliner.Reason> validInliningReasons = null;
        public boolean noLocalsTableOnInput = false;
        public boolean forceNameReflectionOptimization = false;
        public boolean enableNarrowingChecksInD8 = false;
        public Consumer<IRCode> irModifier = null;
        public int basicBlockMuncherIterationLimit = NO_LIMIT;
        public boolean dontReportFailingCheckDiscarded = false;
        public boolean deterministicSortingBasedOnDexType = true;
        public PrintStream whyAreYouNotInliningConsumer = System.out;
        public boolean trackDesugaredAPIConversions = System.getProperty("shadow.bundletool.com.android.tools.r8.trackDesugaredAPIConversions") != null;
        public boolean allowNonAbstractClassesWithAbstractMethods = true;
        public boolean enableForceNestBasedAccessDesugaringForTest = false;
        public boolean verifyKeptGraphInfo = false;
        public boolean dumpAll = false;
        public boolean readInputStackMaps = false;
        public boolean allowOutlinerInterfaceArrayArguments = false;
        public MinifierTestingOptions minifier = new MinifierTestingOptions();
        public boolean measureProguardIfRuleEvaluations = false;
        public ProguardIfRuleEvaluationData proguardIfRuleEvaluationData = new ProguardIfRuleEvaluationData();
        public Consumer<DexEncodedMethod> callSiteOptimizationInfoInspector = null;

        public static class ProguardIfRuleEvaluationData {
            public int numberOfProguardIfRuleClassEvaluations = 0;
            public int numberOfProguardIfRuleMemberEvaluations = 0;
        }

        public static class MinifierTestingOptions {
            public Comparator<DexMethod> interfaceMethodOrdering = null;

            public Comparator<Equivalence.Wrapper<DexMethod>> getInterfaceMethodOrderingOrDefault(Comparator<Equivalence.Wrapper<DexMethod>> comparator) {
                if (this.interfaceMethodOrdering != null) {
                    return (a, b) -> this.interfaceMethodOrdering.compare((DexMethod)a.get(), (DexMethod)b.get());
                }
                return comparator;
            }
        }
    }

    public static class ProtoShrinkingOptions {
        public boolean enableGeneratedExtensionRegistryShrinking = System.getProperty("shadow.bundletool.com.android.tools.r8.generatedExtensionRegistryShrinking") != null;
        public boolean enableGeneratedMessageLiteShrinking = System.getProperty("shadow.bundletool.com.android.tools.r8.generatedMessageLiteShrinking") != null;
        public boolean enableGeneratedMessageLiteBuilderShrinking = System.getProperty("shadow.bundletool.com.android.tools.r8.generatedMessageLiteBuilderShrinking") != null;
        public boolean traverseOneOfAndRepeatedProtoFields = System.getProperty("shadow.bundletool.com.android.tools.r8.traverseOneOfAndRepeatedProtoFields") == null;

        public boolean isProtoShrinkingEnabled() {
            return this.enableGeneratedExtensionRegistryShrinking || this.enableGeneratedMessageLiteShrinking || this.enableGeneratedMessageLiteBuilderShrinking;
        }
    }

    public static class KotlinOptimizationOptions {
        public boolean disableKotlinSpecificOptimizations = System.getProperty("shadow.bundletool.com.android.tools.r8.disableKotlinSpecificOptimizations") != null;
    }

    public static class OutlineOptions {
        public static final String CLASS_NAME = "shadow.bundletool.com.android.tools.r8.GeneratedOutlineSupport";
        public static final String METHOD_PREFIX = "outline";
        public boolean enabled = true;
        public int minSize = 3;
        public int maxSize = 99;
        public int threshold = 20;
    }

    public static enum PackageObfuscationMode {
        NONE,
        REPACKAGE,
        FLATTEN;

    }

    private static class TypeVersionPair {
        final int version;
        final DexType type;

        public TypeVersionPair(int version, DexType type) {
            this.version = version;
            this.type = type;
        }
    }

    public static class InvalidParameterAnnotationInfo {
        final DexMethod method;
        final int expectedParameterCount;
        final int actualParameterCount;

        public InvalidParameterAnnotationInfo(DexMethod method, int expectedParameterCount, int actualParameterCount) {
            this.method = method;
            this.expectedParameterCount = expectedParameterCount;
            this.actualParameterCount = actualParameterCount;
        }
    }

    public static enum LineNumberOptimization {
        OFF,
        ON;

    }
}

