/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_InstallMultiApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.AdbShellCommandTask;
import com.android.tools.build.bundletool.device.BadgingPackageNameParser;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.device.IncompatibleDeviceException;
import com.android.tools.build.bundletool.device.MultiPackagesInstaller;
import com.android.tools.build.bundletool.device.PackagesParser;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.ResultUtils;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.auto.value.AutoValue;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.ByteStreams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class InstallMultiApksCommand {
    private static final Logger logger = Logger.getLogger(InstallMultiApksCommand.class.getName());
    public static final String COMMAND_NAME = "install-multi-apks";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<ImmutableList<Path>> APKS_ARCHIVES_FLAG = Flag.pathList("apks");
    private static final Flag<Path> APKS_ARCHIVE_ZIP_FLAG = Flag.path("apks-zip");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<Boolean> ENABLE_ROLLBACK_FLAG = Flag.booleanFlag("enable-rollback");
    private static final Flag<Boolean> UPDATE_ONLY_FLAG = Flag.booleanFlag("update-only");
    private static final Flag<Boolean> NO_COMMIT_FLAG = Flag.booleanFlag("no-commit");
    private static final Flag<Path> AAPT2_PATH_FLAG = Flag.path("aapt2");
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    abstract Path getAdbPath();

    abstract Optional<Aapt2Command> getAapt2Command();

    abstract ImmutableList<Path> getApksArchivePaths();

    abstract Optional<Path> getApksArchiveZipPath();

    abstract Optional<String> getDeviceId();

    abstract boolean getEnableRollback();

    abstract boolean getUpdateOnly();

    abstract boolean getNoCommitMode();

    abstract AdbServer getAdbServer();

    public static Builder builder() {
        return new AutoValue_InstallMultiApksCommand.Builder().setEnableRollback(false).setNoCommitMode(false).setUpdateOnly(false);
    }

    public static InstallMultiApksCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return InstallMultiApksCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static InstallMultiApksCommand fromFlags(ParsedFlags flags, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        Path adbPath = CommandUtils.getAdbPath(flags, ADB_PATH_FLAG, systemEnvironmentProvider);
        Builder command = InstallMultiApksCommand.builder().setAdbPath(adbPath).setAdbServer(adbServer);
        CommandUtils.getDeviceSerialName(flags, DEVICE_ID_FLAG, systemEnvironmentProvider).ifPresent(command::setDeviceId);
        ENABLE_ROLLBACK_FLAG.getValue(flags).ifPresent(command::setEnableRollback);
        UPDATE_ONLY_FLAG.getValue(flags).ifPresent(command::setUpdateOnly);
        NO_COMMIT_FLAG.getValue(flags).ifPresent(command::setNoCommitMode);
        AAPT2_PATH_FLAG.getValue(flags).ifPresent(aapt2Path -> command.setAapt2Command(Aapt2Command.createFromExecutablePath(aapt2Path)));
        Optional<ImmutableList<Path>> apksPaths = APKS_ARCHIVES_FLAG.getValue(flags);
        Optional<Path> apksArchiveZip = APKS_ARCHIVE_ZIP_FLAG.getValue(flags);
        if (apksPaths.isPresent() == apksArchiveZip.isPresent()) {
            throw new CommandExecutionException("Exactly one of --apks or --apks-zip must be set.");
        }
        apksPaths.ifPresent(command::setApksArchivePaths);
        apksArchiveZip.ifPresent(command::setApksArchiveZipPath);
        flags.checkNoUnknownFlags();
        return command.build();
    }

    public void execute() throws TimeoutException, IOException {
        this.validateInput();
        AdbServer adbServer = this.getAdbServer();
        adbServer.init(this.getAdbPath());
        try (TempDirectory tempDirectory = new TempDirectory();){
            DeviceAnalyzer deviceAnalyzer = new DeviceAnalyzer(adbServer);
            Devices.DeviceSpec deviceSpec = deviceAnalyzer.getDeviceSpec(this.getDeviceId());
            Device device = deviceAnalyzer.getAndValidateDevice(this.getDeviceId());
            MultiPackagesInstaller installer = new MultiPackagesInstaller(device, this.getEnableRollback(), this.getNoCommitMode());
            Path aapt2Dir = tempDirectory.getPath().resolve("aapt2");
            Files.createDirectory(aapt2Dir, new FileAttribute[0]);
            com.google.common.base.Supplier aapt2CommandSupplier = Suppliers.memoize(() -> this.getOrExtractAapt2Command(aapt2Dir));
            ImmutableSet<String> existingPackages = this.getUpdateOnly() ? InstallMultiApksCommand.listPackagesInstalledOnDevice(device) : ImmutableSet.of();
            ImmutableListMultimap apkToInstallByPackage = (ImmutableListMultimap)this.getActualApksPaths(tempDirectory).stream().flatMap(arg_0 -> InstallMultiApksCommand.lambda$execute$2(deviceSpec, (Supplier)aapt2CommandSupplier, arg_0)).filter(apk -> !this.getUpdateOnly() || InstallMultiApksCommand.isInstalled(apk, existingPackages)).flatMap(apks -> InstallMultiApksCommand.extractApkListFromApks(deviceSpec, apks, tempDirectory).stream()).collect(ImmutableListMultimap.toImmutableListMultimap(MultiPackagesInstaller.InstallableApk::getPackageName, Function.identity()));
            if (apkToInstallByPackage.isEmpty()) {
                logger.warning("No packages found to install! Exiting...");
                return;
            }
            installer.install((ImmutableListMultimap<String, MultiPackagesInstaller.InstallableApk>)apkToInstallByPackage);
        }
    }

    private static boolean isInstalled(MultiPackagesInstaller.InstallableApk apk, ImmutableSet<String> existingPackages) {
        boolean exist = existingPackages.contains((Object)apk.getPackageName());
        if (!exist) {
            logger.info(String.format("Package '%s' not present on device, skipping due to --%s.", apk.getPackageName(), UPDATE_ONLY_FLAG.getName()));
        }
        return exist;
    }

    private static ImmutableSet<String> listPackagesInstalledOnDevice(Device device) {
        ImmutableList<String> listPackagesOutput = new AdbShellCommandTask(device, "pm list packages").execute();
        return new PackagesParser().parse(listPackagesOutput);
    }

    private static Optional<MultiPackagesInstaller.InstallableApk> apksWithPackageName(Path apkArchivePath, Devices.DeviceSpec deviceSpec, Supplier<Aapt2Command> aapt2CommandSupplier) {
        Commands.BuildApksResult toc = ResultUtils.readTableOfContents(apkArchivePath);
        if (toc.getPackageName().isEmpty()) {
            return InstallMultiApksCommand.getApksWithPackageNameFromAapt2(apkArchivePath, deviceSpec, aapt2CommandSupplier);
        }
        return Optional.of(MultiPackagesInstaller.InstallableApk.create(apkArchivePath, toc.getPackageName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<MultiPackagesInstaller.InstallableApk> getApksWithPackageNameFromAapt2(Path apksArchivePath, Devices.DeviceSpec deviceSpec, Supplier<Aapt2Command> aapt2CommandSupplier) {
        try (TempDirectory tempDirectory = new TempDirectory();){
            Path extractedFile = (Path)ExtractApksCommand.builder().setApksArchivePath(apksArchivePath).setDeviceSpec(deviceSpec).setOutputDirectory(tempDirectory.getPath()).build().execute().get(0);
            String packageName = BadgingPackageNameParser.parse(aapt2CommandSupplier.get().dumpBadging(extractedFile));
            Optional<MultiPackagesInstaller.InstallableApk> optional = Optional.of(MultiPackagesInstaller.InstallableApk.create(apksArchivePath, packageName));
            return optional;
        }
        catch (IncompatibleDeviceException e4) {
            logger.warning(String.format("Unable to determine package name of %s, as it is not compatible with the attached device. Skipping.", apksArchivePath));
            return Optional.empty();
        }
    }

    private void validateInput() {
        this.getApksArchiveZipPath().ifPresent(zip -> {
            FilePreconditions.checkFileExistsAndReadable(zip);
            FilePreconditions.checkFileHasExtension("ZIP file", zip, ".zip");
        });
        this.getApksArchivePaths().forEach(InstallMultiApksCommand::checkValidApksFile);
        FilePreconditions.checkFileExistsAndExecutable(this.getAdbPath());
    }

    private static void checkValidApksFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        FilePreconditions.checkFileHasExtension("APKS file", path, ".apks");
    }

    private static ImmutableList<MultiPackagesInstaller.InstallableApk> extractApkListFromApks(Devices.DeviceSpec deviceSpec, MultiPackagesInstaller.InstallableApk apksArchive, TempDirectory tempDirectory) {
        logger.info(String.format("Extracting package '%s'", apksArchive.getPackageName()));
        try {
            Path output = tempDirectory.getPath().resolve(apksArchive.getPackageName());
            Files.createDirectory(output, new FileAttribute[0]);
            ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder().setApksArchivePath(apksArchive.getPath()).setDeviceSpec(deviceSpec).setOutputDirectory(output);
            return (ImmutableList)extractApksCommand.build().execute().stream().map(path -> MultiPackagesInstaller.InstallableApk.create(path, apksArchive.getPackageName())).collect(ImmutableList.toImmutableList());
        }
        catch (IncompatibleDeviceException e4) {
            logger.warning(String.format("Package '%s' is not supported by the attached device (SDK version %d). Skipping.", apksArchive.getPackageName(), deviceSpec.getSdkVersion()));
            return ImmutableList.of();
        }
        catch (IOException e5) {
            throw CommandExecutionException.builder().withMessage(String.format("Temp directory to extract files for package '%s' can't be created", apksArchive.getPackageName())).withCause(e5).build();
        }
    }

    private ImmutableList<Path> getActualApksPaths(TempDirectory tempDirectory) throws IOException {
        return this.getApksArchiveZipPath().isPresent() ? InstallMultiApksCommand.extractApksFromZip(this.getApksArchiveZipPath().get(), tempDirectory) : this.getApksArchivePaths();
    }

    private static ImmutableList<Path> extractApksFromZip(Path zipPath, TempDirectory tempDirectory) throws IOException {
        ImmutableList.Builder extractedApks = ImmutableList.builder();
        Path zipExtractedSubDirectory = tempDirectory.getPath().resolve("extracted");
        Files.createDirectory(zipExtractedSubDirectory, new FileAttribute[0]);
        try (ZipFile apksArchiveContainer = new ZipFile(zipPath.toFile());){
            ImmutableList apksToExtractList = (ImmutableList)apksArchiveContainer.stream().filter(zipEntry -> !zipEntry.isDirectory() && zipEntry.getName().toLowerCase(Locale.ROOT).endsWith(".apks")).collect(ImmutableList.toImmutableList());
            for (ZipEntry apksToExtract : apksToExtractList) {
                Path extractedApksPath = zipExtractedSubDirectory.resolve(ZipPath.create(apksToExtract.getName()).getFileName().toString());
                InputStream inputStream = BufferedIo.inputStream(apksArchiveContainer, apksToExtract);
                Throwable throwable = null;
                try {
                    OutputStream outputApks = BufferedIo.outputStream(extractedApksPath);
                    Throwable throwable2 = null;
                    try {
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputApks);
                        extractedApks.add((Object)extractedApksPath);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputApks == null) continue;
                        if (throwable2 != null) {
                            try {
                                outputApks.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        outputApks.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return extractedApks.build();
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Atomically install APKs and APEXs from multiple APK Sets to a connected device.").addAdditionalParagraph("This will extract and install from the APK Sets only the APKs that would be served to that device. If the app is not compatible with the device or if the APK Set was generated for a different type of device, this command will fail. If any one of the APK Sets fails to install, none of the APK Sets will be installed.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s or %s environment variable is set.", "ANDROID_HOME", "PATH").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected.", "ANDROID_SERIAL").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVES_FLAG.getName()).setExampleValue("/path/to/apks1.apks,/path/to/apks2.apks").setOptional(true).setDescription("The list of .apks files to install. Either --apks or --apks-zip is required.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_ZIP_FLAG.getName()).setExampleValue("/path/to/apks_containing.zip").setOptional(true).setDescription("Zip file containing .apks files to install. Either --apks or --apks-zip is required.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ENABLE_ROLLBACK_FLAG.getName()).setOptional(true).setDescription("Enables rollback of the entire atomic install by rolling back any one of the packages.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(UPDATE_ONLY_FLAG.getName()).setOptional(true).setDescription("If set, only packages that are already installed on the device will be updated. Entirely new packages will not be installed.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(NO_COMMIT_FLAG.getName()).setOptional(true).setDescription("Run the full install commands, but abandon the install session instead of committing it.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(AAPT2_PATH_FLAG.getName()).setExampleValue("path/to/aapt2").setOptional(true).setDescription("Path to the aapt2 binary to use.").build()).build();
    }

    private Aapt2Command getOrExtractAapt2Command(Path tempDirectoryForJarCommand) {
        if (this.getAapt2Command().isPresent()) {
            return this.getAapt2Command().get();
        }
        return CommandUtils.extractAapt2FromJar(tempDirectoryForJarCommand);
    }

    private static /* synthetic */ Stream lambda$execute$2(Devices.DeviceSpec deviceSpec, Supplier aapt2CommandSupplier, Path apksArchivePath) {
        return Streams.stream(InstallMultiApksCommand.apksWithPackageName(apksArchivePath, deviceSpec, aapt2CommandSupplier));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setAdbPath(Path var1);

        @CanIgnoreReturnValue
        abstract Builder setAapt2Command(Aapt2Command var1);

        @CanIgnoreReturnValue
        abstract Builder setApksArchivePaths(ImmutableList<Path> var1);

        abstract ImmutableList.Builder<Path> apksArchivePathsBuilder();

        @CanIgnoreReturnValue
        abstract Builder setApksArchiveZipPath(Path var1);

        @CanIgnoreReturnValue
        Builder addApksArchivePath(Path value) {
            this.apksArchivePathsBuilder().add((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        abstract Builder setDeviceId(String var1);

        abstract Builder setEnableRollback(boolean var1);

        abstract Builder setUpdateOnly(boolean var1);

        abstract Builder setNoCommitMode(boolean var1);

        abstract Builder setAdbServer(AdbServer var1);

        public abstract InstallMultiApksCommand build();
    }
}

