/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import java.lang.reflect.Array;

class ArrayUtils {
    private static final Object[] EMPTY = new Object[0];
    private static final int CACHE_SIZE = 73;
    private static Object[] sCache = new Object[73];

    private ArrayUtils() {
    }

    public static int idealByteArraySize(int need) {
        for (int i4 = 4; i4 < 32; ++i4) {
            if (need > (1 << i4) - 12) continue;
            return (1 << i4) - 12;
        }
        return need;
    }

    public static int idealBooleanArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need);
    }

    public static int idealShortArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need * 2) / 2;
    }

    public static int idealCharArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need * 2) / 2;
    }

    public static int idealIntArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need * 4) / 4;
    }

    public static int idealFloatArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need * 4) / 4;
    }

    public static int idealObjectArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need * 4) / 4;
    }

    public static int idealLongArraySize(int need) {
        return ArrayUtils.idealByteArraySize(need * 8) / 8;
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length < length || array2.length < length) {
            return false;
        }
        for (int i4 = 0; i4 < length; ++i4) {
            if (array1[i4] == array2[i4]) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] emptyArray(Class<T> kind) {
        if (kind == Object.class) {
            return EMPTY;
        }
        int bucket = (System.identityHashCode(kind) / 8 & Integer.MAX_VALUE) % 73;
        Object cache = sCache[bucket];
        if (cache == null || cache.getClass().getComponentType() != kind) {
            ArrayUtils.sCache[bucket] = cache = Array.newInstance(kind, 0);
        }
        return (Object[])cache;
    }

    public static <T> boolean contains(T[] array, T value) {
        for (T element : array) {
            if (!(element == null ? value == null : value != null && element.equals(value))) continue;
            return true;
        }
        return false;
    }
}

