/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import shadow.bundletool.com.android.utils.CharSequences;

public class OffsetTrackingDecodedXmlValue {
    private static final char[] DECODED = new char[]{'<', '>', '&', '\'', '\"'};
    private static final String[] ENCODED = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private final CharSequence myDecodedCharacters;
    private final int[] myOffsetMap;

    public OffsetTrackingDecodedXmlValue(CharSequence encodedValue) {
        StringBuilder decodedValue = null;
        int[] offsetMap = null;
        int escapedLength = encodedValue.length();
        int i4 = 0;
        block0: while (i4 < escapedLength) {
            for (int j4 = 0; j4 < ENCODED.length; ++j4) {
                String toReplace = ENCODED[j4];
                if (i4 + toReplace.length() > escapedLength || !CharSequences.regionMatches(encodedValue, i4, toReplace, 0, toReplace.length())) continue;
                if (decodedValue == null) {
                    decodedValue = new StringBuilder(escapedLength);
                    offsetMap = new int[escapedLength];
                    for (int k4 = 0; k4 < i4; ++k4) {
                        offsetMap[k4] = k4;
                        decodedValue.append(encodedValue.charAt(k4));
                    }
                }
                decodedValue.append(DECODED[j4]);
                offsetMap[decodedValue.length() - 1] = i4 += toReplace.length();
                continue block0;
            }
            if (decodedValue != null) {
                decodedValue.append(encodedValue.charAt(i4));
                offsetMap[decodedValue.length() - 1] = i4;
            }
            ++i4;
        }
        this.myOffsetMap = offsetMap;
        this.myDecodedCharacters = decodedValue == null ? encodedValue : decodedValue.toString();
    }

    public CharSequence getDecodedCharacters() {
        return this.myDecodedCharacters;
    }

    public int getEncodedOffset(int decodedOffset) {
        if (this.myOffsetMap == null || decodedOffset <= 0) {
            return decodedOffset;
        }
        if (decodedOffset <= this.myDecodedCharacters.length()) {
            return this.myOffsetMap[decodedOffset - 1];
        }
        return this.myOffsetMap[this.myDecodedCharacters.length() - 1] + decodedOffset - this.myDecodedCharacters.length();
    }
}

