/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.AbiName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

public final class AbiMatcher
extends TargetingDimensionMatcher<Targeting.AbiTargeting> {
    public AbiMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
    }

    @Override
    public boolean matchesTargeting(Targeting.AbiTargeting targeting) {
        if (targeting.equals(Targeting.AbiTargeting.getDefaultInstance())) {
            return true;
        }
        ImmutableSet valuesList = (ImmutableSet)targeting.getValueList().stream().map(Targeting.Abi::getAlias).collect(ImmutableSet.toImmutableSet());
        ImmutableSet alternativesList = (ImmutableSet)targeting.getAlternativesList().stream().map(Targeting.Abi::getAlias).collect(ImmutableSet.toImmutableSet());
        Sets.SetView intersection = Sets.intersection((Set)valuesList, (Set)alternativesList);
        Preconditions.checkArgument((boolean)intersection.isEmpty(), (String)"Expected targeting values and alternatives to be mutually exclusive, but both contain: %s", (Object)intersection);
        for (String abi : this.getDeviceSpec().getSupportedAbisList()) {
            Targeting.Abi.AbiAlias abiAlias = AbiName.fromPlatformName(abi).orElseThrow(() -> ValidationException.builder().withMessage("Unrecognized ABI '%s' in device spec.", abi).build()).toProto();
            if (valuesList.contains((Object)abiAlias)) {
                return true;
            }
            if (!alternativesList.contains((Object)abiAlias)) continue;
            return false;
        }
        return valuesList.isEmpty();
    }

    @Override
    protected Targeting.AbiTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getAbiTargeting();
    }

    @Override
    protected Targeting.AbiTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return variantTargeting.getAbiTargeting();
    }
}

