/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.exceptions.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestValidationException;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;

public abstract class ManifestSdkTargetingException
extends ManifestValidationException {
    @FormatMethod
    private ManifestSdkTargetingException(@FormatString String message, Object ... args) {
        super(message, args);
    }

    public static class MinSdkGreaterThanMaxSdkException
    extends ManifestSdkTargetingException {
        public MinSdkGreaterThanMaxSdkException(int minSdk, int maxSdk) {
            super("minSdkVersion ('%d') is greater than maxSdkVersion('%d').", new Object[]{minSdk, maxSdk});
        }
    }

    public static class MinSdkInvalidException
    extends ManifestSdkTargetingException {
        public MinSdkInvalidException(Resources.XmlAttribute attribute) {
            super("Type of minSdkVersion is expected to be decimal integer, found: '%s'.", new Object[]{attribute.getValue()});
        }

        public MinSdkInvalidException(int value) {
            super("minSdkVersion must be nonnegative, found: '%d'.", new Object[]{value});
        }
    }

    public static class MaxSdkInvalidException
    extends ManifestSdkTargetingException {
        public MaxSdkInvalidException(Resources.XmlAttribute attribute) {
            super("Type of maxSdkVersion is expected to be decimal integer, found: '%s'.", new Object[]{attribute.getValue()});
        }

        public MaxSdkInvalidException(int value) {
            super("maxSdkVersion must be nonnegative, found: '%d'.", new Object[]{value});
        }
    }
}

