/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.io.TempFiles;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.files.FileUtils;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import shadow.bundletool.com.android.tools.build.apkzlib.zfile.ZFiles;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRule;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRules;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFile;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFileOptions;

final class ApkSerializerHelper {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    @VisibleForTesting
    static final AlignmentRule APK_ALIGNMENT_RULE = AlignmentRules.compose(AlignmentRules.constantForSuffix(".so", 4096), AlignmentRules.constant(4));
    private static final com.google.common.base.Predicate<ZipPath> FILES_FOR_AAPT2 = path -> path.startsWith("res") || path.equals(BundleModule.RESOURCES_PROTO_PATH) || path.equals(ZipPath.create("AndroidManifest.xml"));
    private static final String BUILT_BY;
    private static final String CREATED_BY;
    private static final ImmutableSet<String> NO_COMPRESSION_EXTENSIONS;
    private final Aapt2Command aapt2Command;
    private final Optional<SigningConfiguration> signingConfig;
    private final ImmutableList<PathMatcher> uncompressedPathMatchers;

    ApkSerializerHelper(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.aapt2Command = aapt2Command;
        this.signingConfig = signingConfig;
        FileSystem fileSystem = FileSystems.getDefault();
        this.uncompressedPathMatchers = (ImmutableList)compression.getUncompressedGlobList().stream().map(glob -> "glob:" + glob).map(fileSystem::getPathMatcher).collect(ImmutableList.toImmutableList());
    }

    Path writeToZipFile(ModuleSplit split, Path outputPath) {
        TempFiles.withTempDirectory(tempDir -> this.writeToZipFile(split, outputPath, tempDir));
        return outputPath;
    }

    void writeToZipFile(ModuleSplit split, Path outputPath, Path tempDir) {
        FilePreconditions.checkFileDoesNotExist(outputPath);
        Path partialProtoApk = tempDir.resolve("proto.apk");
        this.writeProtoApk(split, partialProtoApk);
        Path binaryApk = tempDir.resolve("binary.apk");
        this.aapt2Command.convertApkProtoToBinary(partialProtoApk, binaryApk);
        Preconditions.checkState((boolean)Files.exists(binaryApk, new LinkOption[0]), (Object)"No APK created by aapt2 convert command.");
        int minSdkVersion = split.getAndroidManifest().get().getEffectiveMinSdkVersion();
        try (ZFile zOutputApk = ZFiles.apk(outputPath.toFile(), new ZFileOptions().setAlignmentRule(APK_ALIGNMENT_RULE).setCoverEmptySpaceUsingExtraField(true), (PrivateKey)this.signingConfig.map(config -> config.getPrivateKey()).orElse(null), (ImmutableList<X509Certificate>)((ImmutableList)this.signingConfig.map(config -> config.getCertificates()).orElse(null)), true, true, BUILT_BY, CREATED_BY, minSdkVersion);
             ZFile zAapt2Files = new ZFile(binaryApk.toFile(), new ZFileOptions(), true);){
            zOutputApk.mergeFrom(zAapt2Files, (Predicate<String>)Predicates.alwaysFalse());
            this.addNonAapt2Files(zOutputApk, split);
            zOutputApk.sortZipContents();
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Failed to write APK file '%s'.", outputPath).build();
        }
    }

    private Path writeProtoApk(ModuleSplit split, Path outputPath) {
        Preconditions.checkState((boolean)split.getAndroidManifest().isPresent(), (Object)"Missing AndroidManifest");
        boolean extractNativeLibs = split.getAndroidManifest().get().getExtractNativeLibsValue().orElse(true);
        ZipBuilder zipBuilder = new ZipBuilder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = this.toApkEntryPath(entry.getPath());
            if (!FILES_FOR_AAPT2.apply((Object)pathInApk)) continue;
            zipBuilder.addFile(pathInApk, () -> entry.getContent(), this.entryOptionForPath(pathInApk, !extractNativeLibs));
        }
        split.getResourceTable().ifPresent(resourceTable -> zipBuilder.addFileWithProtoContent(BundleModule.RESOURCES_PROTO_PATH, (MessageLite)resourceTable, new ZipBuilder.EntryOption[0]));
        zipBuilder.addFileWithProtoContent(ZipPath.create("AndroidManifest.xml"), (MessageLite)split.getAndroidManifest().get().getManifestRoot(), new ZipBuilder.EntryOption[0]);
        try {
            zipBuilder.writeTo(outputPath);
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error while writing APK to file '%s'.", outputPath.getFileName()).build();
        }
        return outputPath;
    }

    private ZipBuilder.EntryOption[] entryOptionForPath(ZipPath path, boolean uncompressNativeLibs) {
        if (this.shouldCompress(path, uncompressNativeLibs)) {
            return new ZipBuilder.EntryOption[0];
        }
        return new ZipBuilder.EntryOption[]{ZipBuilder.EntryOption.UNCOMPRESSED};
    }

    private boolean shouldCompress(ZipPath path, boolean uncompressNativeLibs) {
        if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path))) {
            return false;
        }
        if (NO_COMPRESSION_EXTENSIONS.contains((Object)FileUtils.getFileExtension(path))) {
            return false;
        }
        return !uncompressNativeLibs || !NATIVE_LIBRARIES_PATTERN.matcher(path.toString()).matches();
    }

    private void addNonAapt2Files(ZFile zFile, ModuleSplit split) throws IOException {
        boolean extractNativeLibs = split.getAndroidManifest().get().getExtractNativeLibsValue().orElse(true);
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = this.toApkEntryPath(entry.getPath());
            if (FILES_FOR_AAPT2.apply((Object)pathInApk)) continue;
            InputStream entryInputStream = entry.getContent();
            Throwable throwable = null;
            try {
                zFile.add(pathInApk.toString(), entryInputStream, this.shouldCompress(pathInApk, !extractNativeLibs));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (entryInputStream == null) continue;
                if (throwable != null) {
                    try {
                        entryInputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                entryInputStream.close();
            }
        }
    }

    private ZipPath toApkEntryPath(ZipPath pathInModule) {
        if (pathInModule.startsWith(BundleModule.DEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the dex directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under dex/ directory", pathInModule, ".dex");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.ROOT_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the root directory are supported but found: %s", (Object)pathInModule);
            return pathInModule.subpath(1, pathInModule.getNameCount());
        }
        return pathInModule;
    }

    static {
        CREATED_BY = BUILT_BY = "BundleTool " + BundleToolVersion.getCurrentVersion();
        NO_COMPRESSION_EXTENSIONS = ImmutableSet.of((Object)"3g2", (Object)"3gp", (Object)"3gpp", (Object)"3gpp2", (Object)"aac", (Object)"amr", (Object[])new String[]{"awb", "gif", "imy", "jet", "jpeg", "jpg", "m4a", "m4v", "mid", "midi", "mkv", "mp2", "mp3", "mp4", "mpeg", "mpg", "ogg", "png", "rtttl", "smf", "wav", "webm", "wma", "wmv", "xmf"});
    }
}

