/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.AutoValue_ModuleZipEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.files.BufferedIo;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class ModuleZipEntry
implements ModuleEntry {
    abstract ZipEntry getZipEntry();

    abstract ZipFile getZipFile();

    abstract int getPathNamesToSkip();

    @Override
    public InputStream getContent() {
        try {
            return BufferedIo.inputStream(this.getZipFile(), this.getZipEntry());
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error while reading the zip entry '%s'.", this.getZipEntry().getName()).build();
        }
    }

    @Override
    public ZipPath getPath() {
        ZipPath path = ZipPath.create(this.getZipEntry().getName());
        return path.subpath(this.getPathNamesToSkip(), path.getNameCount());
    }

    @Override
    public boolean isDirectory() {
        return this.getZipEntry().isDirectory();
    }

    public static ModuleZipEntry fromBundleZipEntry(ZipEntry zipEntry, ZipFile zipFile) {
        return ModuleZipEntry.create(zipEntry, zipFile, 1);
    }

    public static ModuleZipEntry fromModuleZipEntry(ZipEntry zipEntry, ZipFile zipFile) {
        return ModuleZipEntry.create(zipEntry, zipFile, 0);
    }

    private static ModuleZipEntry create(ZipEntry zipEntry, ZipFile zipFile, int pathNamesToSkip) {
        Preconditions.checkArgument((ZipPath.create(zipEntry.getName()).getNameCount() > pathNamesToSkip ? 1 : 0) != 0);
        return new AutoValue_ModuleZipEntry(zipEntry, zipFile, pathNamesToSkip);
    }
}

