/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

public class ResourceTableValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        Resources.ResourceTable resourceTable = module.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
        String moduleName = module.getName().getName();
        ImmutableSet resFiles = (ImmutableSet)module.findEntriesUnderPath(BundleModule.RESOURCES_DIRECTORY).map(ModuleEntry::getPath).collect(ImmutableSet.toImmutableSet());
        ImmutableSet<ZipPath> referencedFiles = ResourcesUtils.getAllFileReferences(resourceTable);
        for (ZipPath referencedFile : referencedFiles) {
            if (referencedFile.startsWith(BundleModule.RESOURCES_DIRECTORY)) continue;
            throw ValidationException.builder().withMessage("Resource table of module '%s' references file '%s' outside of the %s/ directory.", moduleName, referencedFile, BundleModule.RESOURCES_DIRECTORY).build();
        }
        Sets.SetView nonReferencedFiles = Sets.difference((Set)resFiles, referencedFiles);
        if (!nonReferencedFiles.isEmpty()) {
            throw ValidationException.builder().withMessage("Module '%s' contains resource files that are not referenced from the resource table: %s", moduleName, nonReferencedFiles).build();
        }
        Sets.SetView nonExistingFiles = Sets.difference(referencedFiles, (Set)resFiles);
        if (!nonExistingFiles.isEmpty()) {
            throw ValidationException.builder().withMessage("Resource table of module '%s' contains references to non-existing files: %s", moduleName, nonExistingFiles).build();
        }
    }
}

