/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.AndroidAppConsumers;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class DexRoundTrip {
    public static void process(D8Command.Builder builder) throws CompilationFailedException {
        builder.setDisableDesugaring(true);
        D8Command command = (D8Command)builder.build();
        InternalOptions options = command.getInternalOptions();
        AndroidApp app = command.getInputApp();
        options.passthroughDexCode = false;
        ExceptionUtils.withD8CompilationHandler(options.reporter, () -> D8.runForTesting(app, options));
    }

    public static void main(String[] args) throws CompilationFailedException, IOException, ResourceException {
        D8Command.Builder builder = D8Command.builder();
        for (String arg : args) {
            Path file = Paths.get(arg, new String[0]);
            if (!FileUtils.isDexFile(file)) {
                throw new IllegalArgumentException("Only DEX files are supported as inputs. Invalid file: " + file);
            }
            builder.addProgramFiles(file);
        }
        AndroidAppConsumers consumer = new AndroidAppConsumers();
        builder.setProgramConsumer(consumer.wrapDexIndexedConsumer(null));
        DexRoundTrip.process(builder);
        DexRoundTrip.process((D8Command.Builder)D8Command.builder(consumer.build()).setProgramConsumer(DexIndexedConsumer.emptyConsumer()));
    }
}

