/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class PrintClassList {
    public static void main(String[] args) throws IOException, ExecutionException {
        List<String> dexFiles = Arrays.asList(args);
        AndroidApp.Builder builder = AndroidApp.builder();
        Path proguardMapFile = null;
        if (args[0].endsWith("map")) {
            proguardMapFile = Paths.get(args[0], new String[0]);
            dexFiles = dexFiles.subList(1, dexFiles.size());
        }
        builder.addProgramFiles(ListUtils.map(dexFiles, x$0 -> Paths.get(x$0, new String[0])));
        ExecutorService executorService = Executors.newCachedThreadPool();
        DexApplication application = new ApplicationReader(builder.build(), new InternalOptions(), new Timing("PrintClassList")).read(proguardMapFile == null ? null : StringResource.fromFile(proguardMapFile), executorService);
        ClassNameMapper map = application.getProguardMap();
        for (DexProgramClass clazz : application.classes()) {
            System.out.print(PrintClassList.maybeDeobfuscateType(map, clazz.type));
            System.out.println();
            clazz.forEachMethod(method -> PrintClassList.printMethod(method, map));
            clazz.forEachField(field -> PrintClassList.printField(field, map));
        }
        executorService.shutdown();
    }

    private static void printMethod(DexEncodedMethod encodedMethod, ClassNameMapper map) {
        DexMethod method = encodedMethod.method;
        if (map != null) {
            System.out.println(map.originalNameOf(method));
        } else {
            MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(method);
            System.out.println(method.holder.toSourceString() + " " + signature);
        }
    }

    private static void printField(DexEncodedField encodedField, ClassNameMapper map) {
        DexField field = encodedField.field;
        if (map != null) {
            System.out.println(map.originalNameOf(field));
        } else {
            MemberNaming.FieldSignature signature = new MemberNaming.FieldSignature(field.name.toSourceString(), field.type.toSourceString());
            System.out.println(field.clazz.toSourceString() + " " + signature);
        }
    }

    private static String maybeDeobfuscateType(ClassNameMapper map, DexType type) {
        return map == null ? type.toSourceString() : map.originalNameOf(type);
    }
}

