/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.code.Const;
import shadow.bundletool.com.android.tools.r8.code.ConstString;
import shadow.bundletool.com.android.tools.r8.code.ConstStringJumbo;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.code.Throw;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.JumboStringRewriter;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSetRefList;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.SynthesizedCode;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class DexEncodedMethod
extends KeyedDexItem<DexMethod>
implements AppInfo.ResolutionResult {
    public static final DexEncodedMethod[] EMPTY_ARRAY = new DexEncodedMethod[0];
    public static final DexEncodedMethod SENTINEL = new DexEncodedMethod(null, null, null, null, null);
    public final DexMethod method;
    public final MethodAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    public DexAnnotationSetRefList parameterAnnotations;
    private Code code;
    private CompilationState compilationState = CompilationState.NOT_PROCESSED;
    private OptimizationInfo optimizationInfo = DefaultOptimizationInfo.DEFAULT;

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, DexAnnotationSetRefList parameterAnnotations, Code code) {
        this.method = method;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.code = code;
        assert (code == null || !accessFlags.isAbstract());
    }

    public boolean isProcessed() {
        return this.compilationState != CompilationState.NOT_PROCESSED;
    }

    public boolean isInstanceInitializer() {
        return this.accessFlags.isConstructor() && !this.accessFlags.isStatic();
    }

    public boolean isDefaultInitializer() {
        return this.isInstanceInitializer() && this.method.proto.parameters.isEmpty();
    }

    public boolean isClassInitializer() {
        return this.accessFlags.isConstructor() && this.accessFlags.isStatic();
    }

    public boolean isVirtualMethod() {
        return !this.accessFlags.isStatic() && !this.accessFlags.isPrivate() && !this.accessFlags.isConstructor();
    }

    public boolean isNonAbstractVirtualMethod() {
        return this.isVirtualMethod() && !this.accessFlags.isAbstract();
    }

    public boolean isPrivateMethod() {
        return this.accessFlags.isPrivate();
    }

    public boolean isDirectMethod() {
        return (this.accessFlags.isPrivate() || this.accessFlags.isConstructor()) && !this.accessFlags.isStatic();
    }

    public boolean isStaticMethod() {
        return this.accessFlags.isStatic();
    }

    public boolean isSyntheticMethod() {
        return this.accessFlags.isSynthetic();
    }

    public boolean isInliningCandidate(DexEncodedMethod container, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        if (this.isClassInitializer()) {
            return false;
        }
        if (inliningReason == Inliner.Reason.FORCE) {
            assert (this.isInliningCandidate(container, Inliner.Reason.SIMPLE, appInfo));
            return true;
        }
        switch (this.compilationState) {
            case PROCESSED_INLINING_CANDIDATE_ANY: {
                return true;
            }
            case PROCESSED_INLINING_CANDIDATE_SUBCLASS: {
                return container.method.getHolder().isSubtypeOf(this.method.getHolder(), appInfo);
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE: {
                return container.method.getHolder().isSamePackage(this.method.getHolder());
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_CLASS: {
                return container.method.getHolder() == this.method.getHolder();
            }
        }
        return false;
    }

    public boolean markProcessed(Inliner.Constraint state) {
        CompilationState prevCompilationState = this.compilationState;
        switch (state) {
            case ALWAYS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_ANY;
                break;
            }
            case SUBCLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SUBCLASS;
                break;
            }
            case PACKAGE: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE;
                break;
            }
            case SAMECLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_CLASS;
                break;
            }
            case NEVER: {
                this.compilationState = CompilationState.PROCESSED_NOT_INLINING_CANDIDATE;
            }
        }
        return prevCompilationState != this.compilationState;
    }

    public void markNotProcessed() {
        this.compilationState = CompilationState.NOT_PROCESSED;
    }

    public IRCode buildIR(InternalOptions options) throws ApiLevelException {
        return this.code == null ? null : this.code.buildIR(this, options);
    }

    public IRCode buildInliningIRForTesting(InternalOptions options, ValueNumberGenerator valueNumberGenerator) throws ApiLevelException {
        return this.buildInliningIR(options, valueNumberGenerator, null);
    }

    public IRCode buildInliningIR(InternalOptions options, ValueNumberGenerator valueNumberGenerator, Position callerPosition) throws ApiLevelException {
        return this.code.buildInliningIR(this, options, valueNumberGenerator, callerPosition);
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public void setCode(IRCode ir, RegisterAllocator registerAllocator, InternalOptions options) {
        DexBuilder builder = new DexBuilder(ir, registerAllocator, options);
        this.code = builder.build(this.method.getArity());
    }

    public String toString() {
        return "Encoded method " + this.method;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.method.collectIndexedItems(indexedItems);
        if (this.code != null) {
            this.code.collectIndexedItems(indexedItems);
        }
        this.annotations.collectIndexedItems(indexedItems);
        this.parameterAnnotations.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (this.code != null) {
            this.code.collectMixedSectionItems(mixedItems);
        }
        this.annotations.collectMixedSectionItems(mixedItems);
        this.parameterAnnotations.collectMixedSectionItems(mixedItems);
    }

    public Code getCode() {
        return this.code;
    }

    public void setDexCode(DexCode code) {
        this.code = code;
    }

    public void removeCode() {
        this.code = null;
    }

    public boolean hasDebugPositions() {
        assert (this.code != null && this.code.isDexCode());
        return this.code.asDexCode().hasDebugPositions();
    }

    public String qualifiedName() {
        return this.method.qualifiedName();
    }

    public String descriptor() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (DexType type : this.method.proto.parameters.values) {
            builder.append(type.descriptor.toString());
        }
        builder.append(")");
        builder.append(this.method.proto.returnType.descriptor.toString());
        return builder.toString();
    }

    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        builder.append(".method ");
        builder.append(this.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(this.method.name.toSmaliString());
        builder.append(this.method.proto.toSmaliString());
        builder.append("\n");
        if (this.code != null) {
            DexCode dexCode = this.code.asDexCode();
            builder.append("    .registers ");
            builder.append(dexCode.registerSize);
            builder.append("\n\n");
            builder.append(dexCode.toSmaliString(naming));
        }
        builder.append(".end method\n");
        return builder.toString();
    }

    @Override
    public String toSourceString() {
        return this.method.toSourceString();
    }

    public DexEncodedMethod toAbstractMethod() {
        this.accessFlags.setAbstract();
        this.code = null;
        return this;
    }

    private DexCode generateCodeFromTemplate(int numberOfRegisters, int outRegisters, Instruction ... instructions) {
        int offset = 0;
        for (Instruction instruction : instructions) {
            assert (!(instruction instanceof ConstString));
            instruction.setOffset(offset);
            offset += instruction.getSize();
        }
        int requiredArgRegisters = this.accessFlags.isStatic() ? 0 : 1;
        for (DexType type : this.method.proto.parameters.values) {
            requiredArgRegisters += ValueType.fromDexType(type).requiredRegisters();
        }
        return new DexCode(Math.max(numberOfRegisters, requiredArgRegisters), requiredArgRegisters, outRegisters, instructions, new DexCode.Try[0], new DexCode.TryHandler[0], null, null);
    }

    public DexEncodedMethod toEmptyThrowingMethod() {
        Instruction[] insn = new Instruction[]{new Const(0, 0), new Throw(0)};
        DexCode code = this.generateCodeFromTemplate(1, 0, insn);
        assert (!this.accessFlags.isAbstract());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        return builder.build();
    }

    public DexEncodedMethod toMethodThatLogsError(DexItemFactory itemFactory) {
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString("Shaking error: Missing method in " + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("TOIGHTNESS");
        DexType[] args = new DexType[]{itemFactory.stringType, itemFactory.stringType};
        DexProto proto = itemFactory.createProto(itemFactory.intType, args);
        DexMethod logMethod = itemFactory.createMethod(itemFactory.createType("Landroid/util/Log;"), proto, itemFactory.createString("e"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        DexCode code = this.isInstanceInitializer() ? this.generateCodeFromTemplate(3, 2, new ConstStringJumbo(0, tag), new ConstStringJumbo(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0), new InvokeDirect(1, this.method, 2, 0, 0, 0, 0)) : this.generateCodeFromTemplate(2, 2, new ConstStringJumbo(0, tag), new ConstStringJumbo(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0));
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        return builder.build();
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method) {
        if (this.method == method) {
            return this;
        }
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(method);
        return builder.build();
    }

    public DexEncodedMethod toRenamedMethod(DexString name, DexItemFactory factory) {
        if (this.method.name == name) {
            return this;
        }
        DexMethod newMethod = factory.createMethod(this.method.holder, this.method.proto, name);
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        return builder.build();
    }

    public DexEncodedMethod toForwardingMethod(DexClass holder, DexItemFactory itemFactory) {
        assert (this.accessFlags.isPublic());
        this.accessFlags.unsetFinal();
        DexMethod newMethod = itemFactory.createMethod(holder.type, this.method.proto, this.method.name);
        Invoke.Type type = this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.SUPER;
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        if (this.accessFlags.isAbstract()) {
            builder.accessFlags.setAbstract();
        } else {
            builder.setCode(new SynthesizedCode(new ForwardMethodSourceCode(this.accessFlags.isStatic() ? null : holder.type, this.method.proto, this.accessFlags.isStatic() ? null : this.method.holder, this.method, type), registry -> {
                if (this.accessFlags.isStatic()) {
                    registry.registerInvokeStatic(this.method);
                } else {
                    registry.registerInvokeSuper(this.method);
                }
            }));
        }
        builder.accessFlags.setSynthetic();
        return builder.build();
    }

    public synchronized void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, DexApplication application) {
        assert (this.code == null || this.code.isDexCode());
        if (this.code == null) {
            return;
        }
        DexCode code = this.code.asDexCode();
        if (code.highestSortingString != null && mapping.getOffsetFor(code.highestSortingString) > 65535) {
            JumboStringRewriter rewriter = new JumboStringRewriter(this, mapping.getFirstJumboString(), application.dexItemFactory);
            rewriter.rewrite();
        }
    }

    public String codeToString() {
        return this.code == null ? "<no code>" : this.code.toString(this, null);
    }

    @Override
    public DexMethod getKey() {
        return this.method;
    }

    public boolean hasAnnotation() {
        return !this.annotations.isEmpty() || !this.parameterAnnotations.isEmpty();
    }

    public void registerReachableDefinitions(UseRegistry registry) {
        if (this.code != null) {
            this.code.registerReachableDefinitions(registry);
        }
    }

    public static int slowCompare(DexEncodedMethod m1, DexEncodedMethod m2) {
        return m1.method.slowCompareTo(m2.method);
    }

    private synchronized OptimizationInfo ensureMutableOI() {
        if (this.optimizationInfo == DefaultOptimizationInfo.DEFAULT) {
            this.optimizationInfo = new OptimizationInfo();
        }
        return this.optimizationInfo;
    }

    public synchronized void markReturnsArgument(int argument) {
        this.ensureMutableOI().markReturnsArgument(argument);
    }

    public synchronized void markNeverReturnsNull() {
        this.ensureMutableOI().markNeverReturnsNull();
    }

    public synchronized void markNeverReturnsNormally() {
        this.ensureMutableOI().markNeverReturnsNormally();
    }

    public synchronized void markReturnsConstant(long value) {
        this.ensureMutableOI().markReturnsConstant(value);
    }

    public synchronized void markForceInline() {
        this.ensureMutableOI().markForceInline();
    }

    public synchronized void markUseIdentifierNameString() {
        this.ensureMutableOI().markUseIdentifierNameString();
    }

    public synchronized void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
        this.ensureMutableOI().markCheckNullReceiverBeforeAnySideEffect(mark);
    }

    public OptimizationInfo getOptimizationInfo() {
        return this.optimizationInfo;
    }

    private static Builder builder(DexEncodedMethod from) {
        return new Builder(from);
    }

    @Override
    public DexEncodedMethod asResultOfResolve() {
        return this;
    }

    @Override
    public DexEncodedMethod asSingleTarget() {
        return this;
    }

    @Override
    public boolean hasSingleTarget() {
        return true;
    }

    @Override
    public List<DexEncodedMethod> asListOfTargets() {
        return Collections.singletonList(this);
    }

    @Override
    public void forEachTarget(Consumer<DexEncodedMethod> consumer) {
        consumer.accept(this);
    }

    private static class Builder {
        private DexMethod method;
        private final MethodAccessFlags accessFlags;
        private final DexAnnotationSet annotations;
        private final DexAnnotationSetRefList parameterAnnotations;
        private Code code;
        private CompilationState compilationState = CompilationState.NOT_PROCESSED;
        private OptimizationInfo optimizationInfo = DefaultOptimizationInfo.DEFAULT;

        private Builder(DexEncodedMethod from) {
            this.method = from.method;
            this.accessFlags = from.accessFlags.copy();
            this.annotations = from.annotations;
            this.parameterAnnotations = from.parameterAnnotations;
            this.code = from.code;
            this.compilationState = from.compilationState;
            this.optimizationInfo = from.optimizationInfo.copy();
        }

        public void setMethod(DexMethod method) {
            this.method = method;
        }

        public void setCode(Code code) {
            this.code = code;
        }

        public DexEncodedMethod build() {
            assert (this.method != null);
            assert (this.accessFlags != null);
            assert (this.annotations != null);
            assert (this.parameterAnnotations != null);
            DexEncodedMethod result = new DexEncodedMethod(this.method, this.accessFlags, this.annotations, this.parameterAnnotations, this.code);
            result.compilationState = this.compilationState;
            result.optimizationInfo = this.optimizationInfo;
            return result;
        }
    }

    private static class DefaultOptimizationInfo
    extends OptimizationInfo {
        static final OptimizationInfo DEFAULT = new DefaultOptimizationInfo();

        private DefaultOptimizationInfo() {
        }

        @Override
        public OptimizationInfo copy() {
            return this;
        }
    }

    public static class OptimizationInfo {
        private int returnedArgument = -1;
        private boolean neverReturnsNull = false;
        private boolean neverReturnsNormally = false;
        private boolean returnsConstant = false;
        private long returnedConstant = 0L;
        private boolean forceInline = false;
        private boolean useIdentifierNameString = false;
        private boolean checksNullReceiverBeforeAnySideEffect = false;

        private OptimizationInfo() {
        }

        private OptimizationInfo(OptimizationInfo template) {
            this.returnedArgument = template.returnedArgument;
            this.neverReturnsNull = template.neverReturnsNull;
            this.returnsConstant = template.returnsConstant;
            this.returnedConstant = template.returnedConstant;
            this.forceInline = template.forceInline;
            this.useIdentifierNameString = template.useIdentifierNameString;
            this.checksNullReceiverBeforeAnySideEffect = template.checksNullReceiverBeforeAnySideEffect;
        }

        public boolean returnsArgument() {
            return this.returnedArgument != -1;
        }

        public int getReturnedArgument() {
            assert (this.returnsArgument());
            return this.returnedArgument;
        }

        public boolean neverReturnsNull() {
            return this.neverReturnsNull;
        }

        public boolean neverReturnsNormally() {
            return this.neverReturnsNormally;
        }

        public boolean returnsConstant() {
            return this.returnsConstant;
        }

        public long getReturnedConstant() {
            assert (this.returnsConstant());
            return this.returnedConstant;
        }

        public boolean forceInline() {
            return this.forceInline;
        }

        public boolean useIdentifierNameString() {
            return this.useIdentifierNameString;
        }

        public boolean checksNullReceiverBeforeAnySideEffect() {
            return this.checksNullReceiverBeforeAnySideEffect;
        }

        private void markReturnsArgument(int argument) {
            assert (argument >= 0);
            assert (this.returnedArgument == -1 || this.returnedArgument == argument);
            this.returnedArgument = argument;
        }

        private void markNeverReturnsNull() {
            this.neverReturnsNull = true;
        }

        private void markNeverReturnsNormally() {
            this.neverReturnsNormally = true;
        }

        private void markReturnsConstant(long value) {
            assert (!this.returnsConstant || this.returnedConstant == value);
            this.returnsConstant = true;
            this.returnedConstant = value;
        }

        private void markForceInline() {
            this.forceInline = true;
        }

        private void markUseIdentifierNameString() {
            this.useIdentifierNameString = true;
        }

        public OptimizationInfo copy() {
            return new OptimizationInfo(this);
        }

        private void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
            this.checksNullReceiverBeforeAnySideEffect = mark;
        }
    }

    public static enum CompilationState {
        NOT_PROCESSED,
        PROCESSED_NOT_INLINING_CANDIDATE,
        PROCESSED_INLINING_CANDIDATE_ANY,
        PROCESSED_INLINING_CANDIDATE_SUBCLASS,
        PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE,
        PROCESSED_INLINING_CANDIDATE_SAME_CLASS;

    }
}

