/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Arrays;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayLoad;
import shadow.bundletool.com.android.tools.r8.code.Aget;
import shadow.bundletool.com.android.tools.r8.code.AgetBoolean;
import shadow.bundletool.com.android.tools.r8.code.AgetByte;
import shadow.bundletool.com.android.tools.r8.code.AgetChar;
import shadow.bundletool.com.android.tools.r8.code.AgetObject;
import shadow.bundletool.com.android.tools.r8.code.AgetShort;
import shadow.bundletool.com.android.tools.r8.code.AgetWide;
import shadow.bundletool.com.android.tools.r8.code.Format23x;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class ArrayGet
extends Instruction {
    private final MemberType type;

    public ArrayGet(MemberType type, Value dest, Value array, Value index) {
        super(dest, Arrays.asList(array, index));
        this.type = type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    public Value index() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: 
            case INT_OR_FLOAT: {
                instruction = new Aget(dest, array, index);
                break;
            }
            case LONG: 
            case DOUBLE: 
            case LONG_OR_DOUBLE: {
                assert (builder.getOptions().canUseSameArrayAndResultRegisterInArrayGetWide() || dest != array);
                instruction = new AgetWide(dest, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AgetObject(dest, array, index);
                break;
            }
            case BOOLEAN: {
                instruction = new AgetBoolean(dest, array, index);
                break;
            }
            case BYTE: {
                instruction = new AgetByte(dest, array, index);
                break;
            }
            case CHAR: {
                instruction = new AgetChar(dest, array, index);
                break;
            }
            case SHORT: {
                instruction = new AgetShort(dest, array, index);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asArrayGet().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asArrayGet().type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isArrayGet() {
        return true;
    }

    @Override
    public ArrayGet asArrayGet() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.ALWAYS;
    }

    @Override
    public boolean hasInvariantVerificationType() {
        return false;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return helper.getType(this.array()).toArrayElementType(helper.getFactory());
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfArrayLoad(this.type));
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return getLatticeElement.apply(this.array()).arrayGet(appInfo);
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value) {
        return this.array() == value;
    }
}

