/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNewArray;
import shadow.bundletool.com.android.tools.r8.code.NewArray;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class NewArrayEmpty
extends Instruction {
    public final DexType type;

    public NewArrayEmpty(Value dest, Value size, DexType type) {
        super(dest, size);
        dest.markNeverNull();
        this.type = type;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.type.toString();
    }

    public Value dest() {
        return this.outValue;
    }

    public Value size() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int size = builder.allocatedRegister(this.size(), this.getNumber());
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new NewArray(dest, size, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asNewArrayEmpty().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.slowCompareTo(other.asNewArrayEmpty().type);
    }

    @Override
    public boolean isNewArrayEmpty() {
        return true;
    }

    @Override
    public NewArrayEmpty asNewArrayEmpty() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.classIsVisible(invocationContext, this.type, info);
    }

    @Override
    public boolean hasInvariantVerificationType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        assert (this.type.isArrayType());
        builder.add(new CfNewArray(this.type));
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return TypeLatticeElement.newArray(this.type, false);
    }
}

