/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.graph.AccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallSiteInformation;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.LensCodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NonNullTracker;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Outliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class Inliner {
    protected final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense graphLense;
    private final InternalOptions options;
    private boolean applyDoubleInlining = false;
    private final Set<DexEncodedMethod> doubleInlineCallers = Sets.newIdentityHashSet();
    private final Set<DexEncodedMethod> doubleInlineSelectedTargets = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, DexEncodedMethod> doubleInlineeCandidates = new HashMap<DexEncodedMethod, DexEncodedMethod>();
    private final Set<DexMethod> blackList = Sets.newIdentityHashSet();

    public Inliner(Enqueuer.AppInfoWithLiveness appInfo, GraphLense graphLense, InternalOptions options) {
        this.appInfo = appInfo;
        this.graphLense = graphLense;
        this.options = options;
        this.fillInBlackList(appInfo);
    }

    private void fillInBlackList(Enqueuer.AppInfoWithLiveness appInfo) {
        this.blackList.add(appInfo.dexItemFactory.kotlin.intrinsics.throwParameterIsNullException);
        this.blackList.add(appInfo.dexItemFactory.kotlin.intrinsics.throwNpe);
    }

    public boolean isBlackListed(DexMethod method) {
        return this.blackList.contains(method);
    }

    private Constraint instructionAllowedForInlining(DexEncodedMethod method, Instruction instruction) {
        Constraint result = instruction.inliningConstraint(this.appInfo, method.method.holder);
        if (result == Constraint.NEVER && instruction.isDebugInstruction()) {
            return Constraint.ALWAYS;
        }
        return result;
    }

    public Constraint computeInliningConstraint(IRCode code, DexEncodedMethod method) {
        Instruction instruction;
        Constraint state;
        Constraint result = Constraint.ALWAYS;
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext() && (result = Constraint.min(result, state = this.instructionAllowedForInlining(method, instruction = (Instruction)it.next()))) != Constraint.NEVER) {
        }
        return result;
    }

    boolean hasInliningAccess(DexEncodedMethod method, DexEncodedMethod target) {
        if (!this.isVisibleWithFlags(target.method.holder, method.method.holder, target.accessFlags)) {
            return false;
        }
        DexClass targetClass = this.appInfo.definitionFor(target.method.holder);
        return this.isVisibleWithFlags(target.method.holder, method.method.holder, targetClass.accessFlags);
    }

    private boolean isVisibleWithFlags(DexType target, DexType context, AccessFlags flags) {
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPrivate()) {
            return target == context;
        }
        if (flags.isProtected()) {
            return context.isSubtypeOf(target, this.appInfo) || target.isSamePackage(context);
        }
        return target.isSamePackage(context);
    }

    synchronized boolean isDoubleInliningTarget(CallSiteInformation callSiteInformation, DexEncodedMethod candidate) {
        return callSiteInformation.hasDoubleCallSite(candidate) || this.doubleInlineSelectedTargets.contains(candidate);
    }

    synchronized DexEncodedMethod doubleInlining(DexEncodedMethod method, DexEncodedMethod target) {
        if (!this.applyDoubleInlining) {
            if (this.doubleInlineeCandidates.containsKey(target)) {
                this.doubleInlineCallers.add(this.doubleInlineeCandidates.get(target));
                this.doubleInlineCallers.add(method);
                this.doubleInlineSelectedTargets.add(target);
            } else {
                this.doubleInlineeCandidates.put(target, method);
            }
            return null;
        }
        if (!this.doubleInlineSelectedTargets.contains(target)) {
            return null;
        }
        return target;
    }

    public synchronized void processDoubleInlineCallers(IRConverter converter, OptimizationFeedback feedback) throws ApiLevelException {
        if (this.doubleInlineCallers.size() > 0) {
            this.applyDoubleInlining = true;
            List methods = this.doubleInlineCallers.stream().sorted(DexEncodedMethod::slowCompare).collect(Collectors.toList());
            for (DexEncodedMethod method : methods) {
                converter.processMethod(method, feedback, x -> false, CallSiteInformation.empty(), Outliner::noProcessing);
                assert (method.isProcessed());
            }
        }
    }

    private int numberOfInstructions(IRCode code) {
        int numOfInstructions = 0;
        for (BasicBlock block : code.blocks) {
            numOfInstructions += block.getInstructions().size();
        }
        return numOfInstructions;
    }

    private boolean legalConstructorInline(DexEncodedMethod method, InvokeMethod invoke, IRCode code) {
        DexType callerMethodHolder = method.method.holder;
        boolean callerMethodIsConstructor = method.isInstanceInitializer();
        DexType calleeMethodHolder = invoke.asInvokeMethod().getInvokedMethod().holder;
        if (callerMethodIsConstructor && callerMethodHolder == calleeMethodHolder) {
            return true;
        }
        boolean receiverOfInnerCallIsThisOfOuter = invoke.asInvokeDirect().getReceiver().isThis();
        InstructionIterator iterator = code.instructionIterator();
        Instruction instruction = (Instruction)iterator.next();
        assert (instruction.isArgument());
        Value unInitializedObject = instruction.outValue();
        boolean seenSuperInvoke = false;
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            if (instruction.inValues().contains(unInitializedObject)) {
                if (instruction.isInvokeDirect() && !seenSuperInvoke) {
                    boolean callOnSupertypeOfThisInConstructor;
                    DexMethod target = instruction.asInvokeDirect().getInvokedMethod();
                    seenSuperInvoke = this.appInfo.dexItemFactory.isConstructor(target);
                    boolean callOnConstructorThatCallsConstructorSameClass = calleeMethodHolder == target.holder;
                    boolean bl = callOnSupertypeOfThisInConstructor = callerMethodHolder.isImmediateSubtypeOf(target.holder) && instruction.asInvokeDirect().getReceiver() == unInitializedObject && receiverOfInnerCallIsThisOfOuter && callerMethodIsConstructor;
                    if (seenSuperInvoke && !callOnConstructorThatCallsConstructorSameClass && !callOnSupertypeOfThisInConstructor) {
                        return false;
                    }
                }
                if (!seenSuperInvoke) {
                    return false;
                }
            }
            if (!instruction.isInstancePut()) continue;
            if (!callerMethodIsConstructor) {
                return false;
            }
            DexField field = instruction.asInstancePut().getField();
            DexEncodedField target = this.appInfo.lookupInstanceTarget(field.getHolder(), field);
            if (target == null || !target.accessFlags.isFinal()) continue;
            return false;
        }
        return true;
    }

    public void performInlining(DexEncodedMethod method, IRCode code, TypeEnvironment typeEnvironment, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation) throws ApiLevelException {
        int instruction_allowance = 1500;
        if ((instruction_allowance -= this.numberOfInstructions(code)) < 0) {
            return;
        }
        InliningOracle oracle = new InliningOracle(this, method, typeEnvironment, callSiteInformation, isProcessedConcurrently);
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext() && instruction_allowance >= 0) {
            BasicBlock block = blockIterator.next();
            if (blocksToRemove.contains(block)) continue;
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext() && instruction_allowance >= 0) {
                InvokeMethod invoke;
                InlineAction result;
                Instruction current = (Instruction)iterator.next();
                if (!current.isInvokeMethod() || (result = (invoke = current.asInvokeMethod()).computeInlining(oracle, method.method.holder)) == null) continue;
                DexEncodedMethod target = result.target;
                Position invokePosition = invoke.getPosition();
                if (invokePosition.method == null) {
                    assert (invokePosition.isNone());
                    invokePosition = Position.noneWithMethod(method.method, null);
                }
                assert (invokePosition.callerPosition == null || invokePosition.getOutermostCaller().method == method.method);
                IRCode inlinee = result.buildInliningIR(code.valueNumberGenerator, this.appInfo, this.graphLense, this.options, invokePosition);
                if (inlinee == null || block.hasCatchHandlers() && inlinee.computeNormalExitBlocks().isEmpty()) continue;
                if (!target.isProcessed()) {
                    assert (result.reason == Reason.FORCE);
                    this.performInlining(target, inlinee, typeEnvironment, isProcessedConcurrently, callSiteInformation);
                }
                assert (!target.isClassInitializer());
                if (target.isInstanceInitializer() && !this.legalConstructorInline(method, invoke, inlinee)) continue;
                DexType downcast = null;
                if (invoke.isInvokeMethodWithReceiver() && target.method.getHolder() != invoke.getInvokedMethod().getHolder()) {
                    downcast = result.target.method.getHolder();
                }
                iterator.previous();
                if ((instruction_allowance -= this.numberOfInstructions(inlinee)) < 0 && !result.ignoreInstructionBudget()) continue;
                iterator.inlineInvoke(code, inlinee, blockIterator, blocksToRemove, downcast);
                typeEnvironment.analyzeBlocks((List<BasicBlock>)inlinee.topologicallySortedBlocks());
                if (method.accessFlags.isBridge()) {
                    method.accessFlags.unsetSynthetic();
                    method.accessFlags.unsetBridge();
                }
                if (!target.getOptimizationInfo().useIdentifierNameString()) continue;
                method.markUseIdentifierNameString();
            }
        }
        oracle.finish();
        code.removeBlocks(blocksToRemove);
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    public static class InlineAction {
        public final DexEncodedMethod target;
        public final Invoke invoke;
        final Reason reason;

        InlineAction(DexEncodedMethod target, Invoke invoke, Reason reason) {
            this.target = target;
            this.invoke = invoke;
            this.reason = reason;
        }

        boolean ignoreInstructionBudget() {
            return this.reason != Reason.SIMPLE;
        }

        public IRCode buildInliningIR(ValueNumberGenerator generator, AppInfoWithSubtyping appInfo, GraphLense graphLense, InternalOptions options, Position callerPosition) throws ApiLevelException {
            IRCode code = this.target.buildInliningIR(options, generator, callerPosition);
            if (!this.target.isProcessed()) {
                new LensCodeRewriter(graphLense, appInfo).rewrite(code, this.target);
            }
            if (options.enableNonNullTracking) {
                new NonNullTracker().addNonNull(code);
            }
            return code;
        }
    }

    public static enum Reason {
        FORCE,
        ALWAYS,
        SINGLE_CALLER,
        DUAL_CALLER,
        SIMPLE;

    }

    public static final class Constraint
    extends Enum<Constraint> {
        public static final /* enum */ Constraint NEVER = new Constraint();
        public static final /* enum */ Constraint SAMECLASS = new Constraint();
        public static final /* enum */ Constraint PACKAGE = new Constraint();
        public static final /* enum */ Constraint SUBCLASS = new Constraint();
        public static final /* enum */ Constraint ALWAYS = new Constraint();
        private static final /* synthetic */ Constraint[] $VALUES;

        public static Constraint[] values() {
            return (Constraint[])$VALUES.clone();
        }

        public static Constraint valueOf(String name) {
            return Enum.valueOf(Constraint.class, name);
        }

        public static Constraint deriveConstraint(DexType contextHolder, DexType targetHolder, AccessFlags flags, AppInfoWithSubtyping appInfo) {
            if (flags.isPublic()) {
                return ALWAYS;
            }
            if (flags.isPrivate()) {
                return targetHolder == contextHolder ? SAMECLASS : NEVER;
            }
            if (flags.isProtected()) {
                if (targetHolder.isSamePackage(contextHolder)) {
                    return PACKAGE;
                }
                if (contextHolder.isSubtypeOf(targetHolder, appInfo)) {
                    return SUBCLASS;
                }
                return NEVER;
            }
            return targetHolder.isSamePackage(contextHolder) ? PACKAGE : NEVER;
        }

        public static Constraint classIsVisible(DexType context, DexType clazz, AppInfoWithSubtyping appInfo) {
            if (clazz.isArrayType()) {
                return Constraint.classIsVisible(context, clazz.toArrayElementType(appInfo.dexItemFactory), appInfo);
            }
            if (clazz.isPrimitiveType()) {
                return ALWAYS;
            }
            DexClass definition = appInfo.definitionFor(clazz);
            return definition == null ? NEVER : Constraint.deriveConstraint(context, clazz, definition.accessFlags, appInfo);
        }

        public static Constraint min(Constraint one, Constraint other) {
            return one.ordinal() < other.ordinal() ? one : other;
        }

        static {
            $VALUES = new Constraint[]{NEVER, SAMECLASS, PACKAGE, SUBCLASS, ALWAYS};
            assert (NEVER.ordinal() < SAMECLASS.ordinal());
            assert (SAMECLASS.ordinal() < PACKAGE.ordinal());
            assert (PACKAGE.ordinal() < SUBCLASS.ordinal());
            assert (SUBCLASS.ordinal() < ALWAYS.ordinal());
        }
    }
}

