/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_ExtractApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.files.BufferedIo;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class ExtractApksCommand {
    public static final String COMMAND_NAME = "extract-apks";
    private static final Flag<Path> APKS_ARCHIVE_FILE_FLAG = Flag.path("apks");
    private static final Flag<Path> DEVICE_SPEC_FLAG = Flag.path("device-spec");
    private static final Flag<Path> OUTPUT_DIRECTORY = Flag.path("output-dir");
    private static final Flag<ImmutableSet<String>> MODULES_FLAG = Flag.stringSet("modules");
    private static final String JSON_EXTENSION = "json";

    public abstract Path getApksArchivePath();

    public abstract Devices.DeviceSpec getDeviceSpec();

    public abstract Path getOutputDirectory();

    public abstract Optional<ImmutableSet<String>> getModules();

    public static Builder builder() {
        return new AutoValue_ExtractApksCommand.Builder();
    }

    public static ExtractApksCommand fromFlags(ParsedFlags flags) {
        Path apksArchivePath = APKS_ARCHIVE_FILE_FLAG.getRequiredValue(flags);
        Path deviceSpecPath = DEVICE_SPEC_FLAG.getRequiredValue(flags);
        Path outputDirectory = OUTPUT_DIRECTORY.getRequiredValue(flags);
        Optional<ImmutableSet<String>> modules = MODULES_FLAG.getValue(flags);
        flags.checkNoUnknownFlags();
        Builder command = ExtractApksCommand.builder();
        FilePreconditions.checkFileExistsAndReadable(apksArchivePath);
        command.setApksArchivePath(apksArchivePath);
        FilePreconditions.checkFileExistsAndReadable(deviceSpecPath);
        command.setDeviceSpec(ExtractApksCommand.parseDeviceSpec(deviceSpecPath));
        FilePreconditions.checkDirectoryExists(outputDirectory);
        command.setOutputDirectory(outputDirectory);
        modules.ifPresent(command::setModules);
        return command.build();
    }

    private static Devices.DeviceSpec parseDeviceSpec(Path deviceSpecFile) {
        Devices.DeviceSpec.Builder builder = Devices.DeviceSpec.newBuilder();
        try {
            if (!JSON_EXTENSION.equals(MoreFiles.getFileExtension((Path)deviceSpecFile))) {
                throw CommandExecutionException.builder().withMessage("Expected .json extension of the device spec file but found '%s'.", deviceSpecFile).build();
            }
            try (BufferedReader deviceSpecReader = BufferedIo.reader(deviceSpecFile);){
                JsonFormat.parser().merge((Reader)deviceSpecReader, (Message.Builder)builder);
            }
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while reading the device spec file '%s'.", deviceSpecFile).build();
        }
        return builder.build();
    }

    public ImmutableList<Path> execute() {
        this.validateInput();
        ApkMatcher apkMatcher = new ApkMatcher(this.getDeviceSpec(), this.getModules());
        ImmutableList<ZipPath> matchedApks = apkMatcher.getMatchingApks(this.readTableOfContents());
        return this.extractMatchedApks(matchedApks);
    }

    private void validateInput() {
        if (this.getModules().isPresent()) {
            ImmutableSet<String> modules = this.getModules().get();
            if (modules.isEmpty()) {
                throw new ValidationException("The set of modules cannot be empty.");
            }
            Sets.SetView unknownModules = Sets.difference(modules, (Set)((Set)this.readTableOfContents().getVariantList().stream().flatMap(variant -> variant.getApkSetList().stream()).map(Commands.ApkSet::getModuleMetadata).map(Commands.ModuleMetadata::getName).collect(ImmutableSet.toImmutableSet())));
            if (!unknownModules.isEmpty()) {
                throw ValidationException.builder().withMessage("The APK Set archive does not contain the following modules: %s", unknownModules).build();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImmutableList<Path> extractMatchedApks(ImmutableList<ZipPath> matchedApkPaths) {
        ImmutableList.Builder builder = ImmutableList.builder();
        try (ZipFile apksArchive = new ZipFile(this.getApksArchivePath().toFile());){
            for (ZipPath matchedApk : matchedApkPaths) {
                ZipEntry entry = apksArchive.getEntry(matchedApk.toString());
                Preconditions.checkNotNull((Object)entry);
                Path extractedApkPath = this.getOutputDirectory().resolve(matchedApk.getFileName().toString());
                try {
                    InputStream inputStream = BufferedIo.inputStream(apksArchive, entry);
                    Throwable throwable = null;
                    try {
                        OutputStream outputApk = BufferedIo.outputStream(extractedApkPath);
                        Throwable throwable2 = null;
                        try {
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputApk);
                            builder.add((Object)extractedApkPath);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (outputApk == null) continue;
                            if (throwable2 != null) {
                                try {
                                    outputApk.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            outputApk.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while extracting APK '%s' from the APK Set.", matchedApk).build();
                    return builder.build();
                }
            }
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("I/O error while processing the APK Set archive '%s'.", this.getApksArchivePath()).build();
        }
    }

    /*
     * Exception decompiling
     */
    private Commands.BuildApksResult readTableOfContents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Extracts from an APK Set the APKs that should be installed on a given device.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_FILE_FLAG.getName()).setExampleValue("archive.apks").setDescription("Path to the archive file generated by the '%s' command.", "build-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_SPEC_FLAG.getName()).setExampleValue("device-spec.json").setDescription("Path to the device spec file generated by the '%s' command.", "get-device-spec").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_DIRECTORY.getName()).setExampleValue("output-dir").setDescription("Path to where the matched APKs will be extracted from the archive file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("base,module1,module2").setOptional(true).setDescription("When specified and the device matches split APKs, then only APKs of the specified modules will be extracted. Cannot be used if the device matches a non-split APK.").build()).build();
    }

    ExtractApksCommand() {
    }

    public static abstract class Builder {
        public abstract Builder setApksArchivePath(Path var1);

        public abstract Builder setDeviceSpec(Devices.DeviceSpec var1);

        public abstract Builder setOutputDirectory(Path var1);

        public abstract Builder setModules(ImmutableSet<String> var1);

        public abstract ExtractApksCommand build();
    }
}

